/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import android.util.Log;
import com.superrtc.mediamanager.SRWebSocket;
import internal.org.java_websocket.b.h;
import internal.org.java_websocket.drafts.Draft;
import internal.org.java_websocket.drafts.c;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;

public class SRWebSocketExt {
    private SRWebSocket srwebsocket;
    private static final String TAG = "SRWebSocketExt";
    public String url;
    private Draft draft;
    public String name;
    public SRWebSocketDelegate delegate;
    private boolean isopen = false;

    public SRWebSocketExt(String string, SRWebSocketDelegate sRWebSocketDelegate, String string2) throws URISyntaxException {
        this.name = string2;
        this.delegate = sRWebSocketDelegate;
        this.url = string;
        this.draft = new c();
        this.srwebsocket = new SRWebSocket(new URI(string), this.draft){

            @Override
            public void onOpen(h h2) {
                SRWebSocketExt.this.isopen = true;
                SRWebSocketExt.this.delegate.webSocketDidOpen(SRWebSocketExt.this);
            }

            @Override
            public void onMessage(String string) {
                if (!SRWebSocketExt.this.isopen) {
                    Log.e((String)SRWebSocketExt.TAG, (String)"websocket is not open!");
                    return;
                }
                SRWebSocketExt.this.delegate.didReceiveMessageWithString(SRWebSocketExt.this, string);
            }

            @Override
            public void onClose(int n, String string, boolean bl) {
                SRWebSocketExt.this.isopen = false;
                SRWebSocketExt.this.delegate.didCloseWithCode(SRWebSocketExt.this, n, string, bl);
            }

            @Override
            public void onError(Exception exception) {
                SRWebSocketExt.this.delegate.didFailWithError(SRWebSocketExt.this, exception);
            }
        };
        if (this.url.indexOf("wss") != -1) {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, null, null);
                this.srwebsocket.setSocket(sSLContext.getSocketFactory().createSocket());
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                this.isopen = false;
                this.srwebsocket.close();
            }
            catch (Exception exception) {
                this.isopen = false;
                this.srwebsocket.close();
                exception.printStackTrace();
            }
        }
    }

    public void open() {
        if (this.isopen) {
            return;
        }
        this.srwebsocket.connect();
    }

    public void close() {
        this.isopen = false;
        this.srwebsocket.close();
    }

    public void send(String string) {
        if (this.srwebsocket != null && this.isopen) {
            this.srwebsocket.send(string);
        }
    }

    public void setHeaders(Map<String, String> map) {
        if (this.srwebsocket != null) {
            this.srwebsocket.setHeaders(map);
        }
    }

    public static interface SRWebSocketDelegate {
        public void invokeConnWithWebsocket(SRWebSocketExt var1, String var2);

        public void webSocketDidOpen(SRWebSocketExt var1);

        public void didReceiveMessageWithString(SRWebSocketExt var1, String var2);

        public void didReceiveMessageWithData(SRWebSocketExt var1, byte[] var2);

        public void didFailWithError(SRWebSocketExt var1, Exception var2);

        public void didCloseWithCode(SRWebSocketExt var1, int var2, String var3, boolean var4);

        public void didReceivePong(SRWebSocketExt var1, byte[] var2);
    }
}

