/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Log;

public class RTCNetworkReceiver
extends BroadcastReceiver {
    private NetworkListener networkListener;

    public void onReceive(Context context, Intent intent) {
        if (this.networkListener != null) {
            this.networkListener.onNetworkChanged(RTCNetworkReceiver.getNetworkTypes(context).ordinal());
        }
    }

    public static Types getNetworkTypes(Context context) {
        Types types = Types.NO_NETWORK;
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (Build.VERSION.SDK_INT >= 23) {
                Network network = connectivityManager.getActiveNetwork();
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
                if (networkCapabilities != null) {
                    boolean bl = networkCapabilities.hasTransport(0);
                    boolean bl2 = networkCapabilities.hasTransport(1);
                    boolean bl3 = networkCapabilities.hasTransport(2);
                    boolean bl4 = networkCapabilities.hasTransport(3);
                    boolean bl5 = networkCapabilities.hasTransport(4);
                    if (bl) {
                        types = Types.MOBILE;
                    } else if (bl2) {
                        types = Types.WIFI;
                    } else if (bl4) {
                        types = Types.ETHERNET;
                    } else if (bl3 || bl5) {
                        types = Types.OTHERS;
                    }
                }
                Log.i((String)"ContentValues", (String)("getNetworkTypes Network info: " + (Object)((Object)types)));
            } else {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                Log.i((String)"ContentValues", (String)("getNetworkTypes Active Network info: " + (networkInfo == null ? "null" : networkInfo.toString())));
                if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
                    int n = networkInfo.getType();
                    if (n == 1) {
                        types = Types.WIFI;
                    } else if (n == 0) {
                        types = Types.MOBILE;
                    } else if (n == 9) {
                        types = Types.ETHERNET;
                    } else if (n == 7 || n == 17) {
                        types = Types.OTHERS;
                    }
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)"ContentValues", (String)exception.getMessage());
        }
        return types;
    }

    public void setNetworkListener(NetworkListener networkListener) {
        this.networkListener = networkListener;
    }

    public static enum Types {
        NO_NETWORK,
        WIFI,
        MOBILE,
        ETHERNET,
        OTHERS;

    }

    public static interface NetworkListener {
        public void onNetworkChanged(int var1);
    }
}

