/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.graphics.Matrix;
import android.os.Handler;
import com.superrtc.RefCountDelegate;
import com.superrtc.ThreadUtils;
import com.superrtc.VideoFrame;
import com.superrtc.YuvConverter;
import javax.annotation.Nullable;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private final int unscaledWidth;
    private final int unscaledHeight;
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private final Matrix transformMatrix;
    private final Handler toI420Handler;
    private final YuvConverter yuvConverter;
    private final RefCountDelegate refCountDelegate;

    public TextureBufferImpl(int n, int n2, VideoFrame.TextureBuffer.Type type, int n3, Matrix matrix, Handler handler, YuvConverter yuvConverter, @Nullable Runnable runnable) {
        this.unscaledWidth = n;
        this.unscaledHeight = n2;
        this.width = n;
        this.height = n2;
        this.type = type;
        this.id = n3;
        this.transformMatrix = matrix;
        this.toI420Handler = handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(runnable);
    }

    private TextureBufferImpl(int n, int n2, int n3, int n4, VideoFrame.TextureBuffer.Type type, int n5, Matrix matrix, Handler handler, YuvConverter yuvConverter, @Nullable Runnable runnable) {
        this.unscaledWidth = n;
        this.unscaledHeight = n2;
        this.width = n3;
        this.height = n4;
        this.type = type;
        this.id = n5;
        this.transformMatrix = matrix;
        this.toI420Handler = handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(runnable);
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, () -> this.yuvConverter.convert(this));
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n, int n2, int n3, int n4, int n5, int n6) {
        Matrix matrix = new Matrix();
        int n7 = this.height - (n2 + n4);
        matrix.preTranslate((float)n / (float)this.width, (float)n7 / (float)this.height);
        matrix.preScale((float)n3 / (float)this.width, (float)n4 / (float)this.height);
        return this.applyTransformMatrix(matrix, Math.round((float)(this.unscaledWidth * n3) / (float)this.width), Math.round((float)(this.unscaledHeight * n4) / (float)this.height), n5, n6);
    }

    public int getUnscaledWidth() {
        return this.unscaledWidth;
    }

    public int getUnscaledHeight() {
        return this.unscaledHeight;
    }

    public TextureBufferImpl applyTransformMatrix(Matrix matrix, int n, int n2) {
        return this.applyTransformMatrix(matrix, n, n2, n, n2);
    }

    private TextureBufferImpl applyTransformMatrix(Matrix matrix, int n, int n2, int n3, int n4) {
        Matrix matrix2 = new Matrix(this.transformMatrix);
        matrix2.preConcat(matrix);
        this.retain();
        return new TextureBufferImpl(n, n2, n3, n4, this.type, this.id, matrix2, this.toI420Handler, this.yuvConverter, this::release);
    }
}

