/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.CalledByNative;
import com.superrtc.FrameDecryptor;
import com.superrtc.JniCommon;
import com.superrtc.MediaStreamTrack;
import com.superrtc.RtpParameters;
import javax.annotation.Nullable;

public class RtpReceiver {
    private long nativeRtpReceiver;
    private long nativeObserver;
    @Nullable
    private MediaStreamTrack cachedTrack;

    @CalledByNative
    public RtpReceiver(long l) {
        this.nativeRtpReceiver = l;
        long l2 = RtpReceiver.nativeGetTrack(l);
        this.cachedTrack = MediaStreamTrack.createMediaStreamTrack(l2);
    }

    @Nullable
    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public boolean setParameters(@Nullable RtpParameters rtpParameters) {
        this.checkRtpReceiverExists();
        return rtpParameters == null ? false : RtpReceiver.nativeSetParameters(this.nativeRtpReceiver, rtpParameters);
    }

    public RtpParameters getParameters() {
        this.checkRtpReceiverExists();
        return RtpReceiver.nativeGetParameters(this.nativeRtpReceiver);
    }

    public String id() {
        this.checkRtpReceiverExists();
        return RtpReceiver.nativeGetId(this.nativeRtpReceiver);
    }

    @CalledByNative
    public void dispose() {
        this.checkRtpReceiverExists();
        this.cachedTrack.dispose();
        if (this.nativeObserver != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, this.nativeObserver);
            this.nativeObserver = 0L;
        }
        JniCommon.nativeReleaseRef(this.nativeRtpReceiver);
        this.nativeRtpReceiver = 0L;
    }

    public void SetObserver(Observer observer) {
        this.checkRtpReceiverExists();
        if (this.nativeObserver != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, this.nativeObserver);
        }
        this.nativeObserver = RtpReceiver.nativeSetObserver(this.nativeRtpReceiver, observer);
    }

    public void setFrameDecryptor(FrameDecryptor frameDecryptor) {
        this.checkRtpReceiverExists();
        RtpReceiver.nativeSetFrameDecryptor(this.nativeRtpReceiver, frameDecryptor.getNativeFrameDecryptor());
    }

    public MediaType getMediaType() {
        int n = RtpReceiver.nativeMediaType(this.nativeRtpReceiver);
        if (n == 0) {
            return MediaType.MEDIA_TYPE_AUDIO;
        }
        if (n == 1) {
            return MediaType.MEDIA_TYPE_VIDEO;
        }
        return MediaType.MEDIA_TYPE_DATA;
    }

    public Object getEMSources() {
        return RtpReceiver.nativeEMGetSources(this.nativeRtpReceiver);
    }

    private void checkRtpReceiverExists() {
        if (this.nativeRtpReceiver == 0L) {
            throw new IllegalStateException("RtpReceiver has been disposed.");
        }
    }

    private static native long nativeGetTrack(long var0);

    private static native boolean nativeSetParameters(long var0, RtpParameters var2);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native String nativeGetId(long var0);

    private static native long nativeSetObserver(long var0, Observer var2);

    private static native void nativeUnsetObserver(long var0, long var2);

    private static native void nativeSetFrameDecryptor(long var0, long var2);

    private static native int nativeMediaType(long var0);

    private static native Object nativeEMGetSources(long var0);

    public static enum MediaType {
        MEDIA_TYPE_AUDIO,
        MEDIA_TYPE_VIDEO,
        MEDIA_TYPE_DATA;

    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onFirstPacketReceived(MediaStreamTrack.MediaType var1);
    }
}

