/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import com.superrtc.ContextUtils;
import com.superrtc.Logging;
import com.superrtc.NativeLibraryLoader;
import internal.com.getkeepsafe.relinker.ReLinker;

class NativeLibrary {
    private static String TAG = "NativeLibrary";
    private static Object lock = new Object();
    private static boolean libraryLoaded;

    NativeLibrary() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initialize(NativeLibraryLoader nativeLibraryLoader, String string) {
        Object object = lock;
        synchronized (object) {
            if (libraryLoaded) {
                Logging.d(TAG, "Native library has already been loaded.");
                return;
            }
            Logging.d(TAG, "Loading native library: " + string);
            libraryLoaded = nativeLibraryLoader.load(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isLoaded() {
        Object object = lock;
        synchronized (object) {
            return libraryLoaded;
        }
    }

    static class ReLinkerLoader
    implements NativeLibraryLoader {
        ReLinkerLoader() {
        }

        @Override
        public boolean load(String string) {
            Logging.d(TAG, "ReLinker loading library: " + string);
            try {
                ReLinker.loadLibrary(ContextUtils.getApplicationContext(), string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Logging.e(TAG, "ReLinker failed to load native library: " + string, unsatisfiedLinkError);
                return false;
            }
            return true;
        }
    }

    static class DefaultLoader
    implements NativeLibraryLoader {
        DefaultLoader() {
        }

        @Override
        public boolean load(String string) {
            Logging.d(TAG, "Loading library: " + string);
            try {
                System.loadLibrary(string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Logging.e(TAG, "Failed to load native library: " + string, unsatisfiedLinkError);
                return false;
            }
            return true;
        }
    }
}

