/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import com.superrtc.AndroidVideoDecoder;
import com.superrtc.EglBase;
import com.superrtc.Logging;
import com.superrtc.MediaCodecUtils;
import com.superrtc.MediaCodecWrapperFactoryImpl;
import com.superrtc.VideoCodecInfo;
import com.superrtc.VideoCodecType;
import com.superrtc.VideoDecoder;
import com.superrtc.VideoDecoderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;

class MediaCodecVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "MediaCodecVideoDecoderFactory";
    @Nullable
    private final EglBase.Context sharedContext;
    private final String[] prefixWhitelist;
    private final String[] prefixBlacklist;

    public MediaCodecVideoDecoderFactory(@Nullable EglBase.Context context, String[] stringArray, String[] stringArray2) {
        this.sharedContext = context;
        this.prefixWhitelist = Arrays.copyOf(stringArray, stringArray.length);
        this.prefixBlacklist = Arrays.copyOf(stringArray2, stringArray2.length);
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo videoCodecInfo) {
        VideoCodecType videoCodecType = VideoCodecType.valueOf(videoCodecInfo.getName());
        MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
        if (mediaCodecInfo == null) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(videoCodecType.mimeType());
        return new AndroidVideoDecoder(new MediaCodecWrapperFactoryImpl(), mediaCodecInfo.getName(), videoCodecType, MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, codecCapabilities), this.sharedContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
        for (VideoCodecType videoCodecType : new VideoCodecType[]{VideoCodecType.VP8, VideoCodecType.VP9, VideoCodecType.H264}) {
            MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
            if (mediaCodecInfo == null) continue;
            String string = videoCodecType.name();
            if (videoCodecType == VideoCodecType.H264 && this.isH264HighProfileSupported(mediaCodecInfo)) {
                arrayList.add(new VideoCodecInfo(string, MediaCodecUtils.getCodecProperties(videoCodecType, true)));
            }
            arrayList.add(new VideoCodecInfo(string, MediaCodecUtils.getCodecProperties(videoCodecType, false)));
        }
        return arrayList.toArray(new VideoCodecInfo[arrayList.size()]);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecType videoCodecType) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int k = 0; k < MediaCodecList.getCodecCount(); ++k) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)k);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder() || !this.isSupportedCodec(mediaCodecInfo, videoCodecType)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        String string = mediaCodecInfo.getName();
        if (!MediaCodecUtils.codecSupportsType(mediaCodecInfo, videoCodecType)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(videoCodecType.mimeType())) == null) {
            return false;
        }
        return this.isWhitelisted(string) && !this.isBlacklisted(string);
    }

    private boolean isWhitelisted(String string) {
        for (String string2 : this.prefixWhitelist) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlacklisted(String string) {
        for (String string2 : this.prefixBlacklist) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo mediaCodecInfo) {
        String string = mediaCodecInfo.getName();
        if (Build.VERSION.SDK_INT >= 21 && string.startsWith("OMX.qcom.")) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && string.startsWith("OMX.Exynos.");
    }
}

