/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import com.superrtc.BaseBitrateAdjuster;
import com.superrtc.BitrateAdjuster;
import com.superrtc.DynamicBitrateAdjuster;
import com.superrtc.EglBase;
import com.superrtc.EglBase14;
import com.superrtc.FramerateBitrateAdjuster;
import com.superrtc.H264Utils;
import com.superrtc.HardwareVideoEncoder;
import com.superrtc.Logging;
import com.superrtc.MediaCodecUtils;
import com.superrtc.MediaCodecWrapperFactoryImpl;
import com.superrtc.VideoCodecInfo;
import com.superrtc.VideoCodecType;
import com.superrtc.VideoEncoder;
import com.superrtc.VideoEncoderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class HardwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "HardwareVideoEncoderFactory";
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000;
    private static final List<String> H264_HW_EXCEPTION_MODELS = Arrays.asList("SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4");
    @Nullable
    private final EglBase14.Context sharedContext;
    private final boolean enableIntelVp8Encoder;
    private final boolean enableH264HighProfile;

    public HardwareVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2) {
        if (context instanceof EglBase14.Context) {
            this.sharedContext = (EglBase14.Context)context;
        } else {
            Logging.w(TAG, "No shared EglBase.Context.  Encoders will not use texture mode.");
            this.sharedContext = null;
        }
        this.enableIntelVp8Encoder = bl;
        this.enableH264HighProfile = bl2;
    }

    @Deprecated
    public HardwareVideoEncoderFactory(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo videoCodecInfo) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        VideoCodecType videoCodecType = VideoCodecType.valueOf(videoCodecInfo.name);
        MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
        if (mediaCodecInfo == null) {
            return null;
        }
        String string = mediaCodecInfo.getName();
        String string2 = videoCodecType.mimeType();
        Integer n = MediaCodecUtils.selectColorFormat(MediaCodecUtils.TEXTURE_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(string2));
        Integer n2 = MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(string2));
        if (videoCodecType == VideoCodecType.H264) {
            boolean bl = H264Utils.isSameH264Profile(videoCodecInfo.params, MediaCodecUtils.getCodecProperties(videoCodecType, true));
            boolean bl2 = H264Utils.isSameH264Profile(videoCodecInfo.params, MediaCodecUtils.getCodecProperties(videoCodecType, false));
            if (!bl && !bl2) {
                return null;
            }
            if (bl && !this.isH264HighProfileSupported(mediaCodecInfo)) {
                return null;
            }
        }
        return new HardwareVideoEncoder(new MediaCodecWrapperFactoryImpl(), string, videoCodecType, n, n2, videoCodecInfo.params, this.getKeyFrameIntervalSec(videoCodecType), this.getForcedKeyFrameIntervalMs(videoCodecType, string), this.createBitrateAdjuster(videoCodecType, string), this.sharedContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        if (Build.VERSION.SDK_INT < 19) {
            return new VideoCodecInfo[0];
        }
        ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
        for (VideoCodecType videoCodecType : new VideoCodecType[]{VideoCodecType.VP8, VideoCodecType.VP9, VideoCodecType.H264}) {
            MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
            if (mediaCodecInfo == null) continue;
            String string = videoCodecType.name();
            if (videoCodecType == VideoCodecType.H264 && this.isH264HighProfileSupported(mediaCodecInfo)) {
                arrayList.add(new VideoCodecInfo(string, MediaCodecUtils.getCodecProperties(videoCodecType, true)));
            }
            arrayList.add(new VideoCodecInfo(string, MediaCodecUtils.getCodecProperties(videoCodecType, false)));
        }
        return arrayList.toArray(new VideoCodecInfo[arrayList.size()]);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecType videoCodecType) {
        for (int k = 0; k < MediaCodecList.getCodecCount(); ++k) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)k);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder() || !this.isSupportedCodec(mediaCodecInfo, videoCodecType)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        if (!MediaCodecUtils.codecSupportsType(mediaCodecInfo, videoCodecType)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(videoCodecType.mimeType())) == null) {
            return false;
        }
        return this.isHardwareSupportedInCurrentSdk(mediaCodecInfo, videoCodecType);
    }

    private boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        switch (videoCodecType) {
            case VP8: {
                return this.isHardwareSupportedInCurrentSdkVp8(mediaCodecInfo);
            }
            case VP9: {
                return this.isHardwareSupportedInCurrentSdkVp9(mediaCodecInfo);
            }
            case H264: {
                return this.isHardwareSupportedInCurrentSdkH264(mediaCodecInfo);
            }
        }
        return false;
    }

    private boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo mediaCodecInfo) {
        String string = mediaCodecInfo.getName();
        return string.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || string.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || string.startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21 && this.enableIntelVp8Encoder;
    }

    private boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo mediaCodecInfo) {
        String string = mediaCodecInfo.getName();
        return (string.startsWith("OMX.qcom.") || string.startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
    }

    private boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo mediaCodecInfo) {
        if (H264_HW_EXCEPTION_MODELS.contains(Build.MODEL)) {
            return false;
        }
        String string = mediaCodecInfo.getName();
        return string.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || string.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 21;
    }

    private int getKeyFrameIntervalSec(VideoCodecType videoCodecType) {
        switch (videoCodecType) {
            case VP8: 
            case VP9: {
                return 100;
            }
            case H264: {
                return 20;
            }
        }
        throw new IllegalArgumentException("Unsupported VideoCodecType " + (Object)((Object)videoCodecType));
    }

    private int getForcedKeyFrameIntervalMs(VideoCodecType videoCodecType, String string) {
        if (videoCodecType == VideoCodecType.VP8 && string.startsWith("OMX.qcom.")) {
            if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
                return 15000;
            }
            if (Build.VERSION.SDK_INT == 23) {
                return 20000;
            }
            if (Build.VERSION.SDK_INT > 23) {
                return 15000;
            }
        }
        return 0;
    }

    private BitrateAdjuster createBitrateAdjuster(VideoCodecType videoCodecType, String string) {
        if (string.startsWith("OMX.Exynos.")) {
            if (videoCodecType == VideoCodecType.VP8) {
                return new DynamicBitrateAdjuster();
            }
            return new FramerateBitrateAdjuster();
        }
        return new BaseBitrateAdjuster();
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo mediaCodecInfo) {
        return this.enableH264HighProfile && Build.VERSION.SDK_INT > 23 && mediaCodecInfo.getName().startsWith("OMX.Exynos.");
    }
}

