/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Bundle;
import android.view.Surface;
import com.superrtc.BitrateAdjuster;
import com.superrtc.EglBase;
import com.superrtc.EglBase14;
import com.superrtc.EncodedImage;
import com.superrtc.GlRectDrawer;
import com.superrtc.Logging;
import com.superrtc.MediaCodecWrapper;
import com.superrtc.MediaCodecWrapperFactory;
import com.superrtc.ThreadUtils;
import com.superrtc.VideoCodecStatus;
import com.superrtc.VideoCodecType;
import com.superrtc.VideoEncoder;
import com.superrtc.VideoFrame;
import com.superrtc.VideoFrameDrawer;
import com.superrtc.YuvHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@TargetApi(value=19)
class HardwareVideoEncoder
implements VideoEncoder {
    private static final String TAG = "HardwareVideoEncoder";
    private static final int VIDEO_ControlRateConstant = 2;
    private static final String KEY_BITRATE_MODE = "bitrate-mode";
    private static final int VIDEO_AVC_PROFILE_HIGH = 8;
    private static final int VIDEO_AVC_LEVEL_3 = 256;
    private static final int MAX_VIDEO_FRAMERATE = 30;
    private static final int MAX_ENCODER_Q_SIZE = 2;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private final VideoCodecType codecType;
    private final Integer surfaceColorFormat;
    private final Integer yuvColorFormat;
    private final YuvFormat yuvFormat;
    private final Map<String, String> params;
    private final int keyFrameIntervalSec;
    private final long forcedKeyFrameNs;
    private final BitrateAdjuster bitrateAdjuster;
    private final EglBase14.Context sharedContext;
    private final GlRectDrawer textureDrawer = new GlRectDrawer();
    private final VideoFrameDrawer videoFrameDrawer = new VideoFrameDrawer();
    private final BlockingDeque<EncodedImage.Builder> outputBuilders = new LinkedBlockingDeque<EncodedImage.Builder>();
    private final ThreadUtils.ThreadChecker encodeThreadChecker = new ThreadUtils.ThreadChecker();
    private final ThreadUtils.ThreadChecker outputThreadChecker = new ThreadUtils.ThreadChecker();
    private VideoEncoder.Callback callback;
    private boolean automaticResizeOn;
    @Nullable
    private MediaCodecWrapper codec;
    @Nullable
    private Thread outputThread;
    @Nullable
    private EglBase14 textureEglBase;
    @Nullable
    private Surface textureInputSurface;
    private int width;
    private int height;
    private boolean useSurfaceMode;
    private long lastKeyFrameNs;
    @Nullable
    private ByteBuffer configBuffer;
    private int adjustedBitrate;
    private volatile boolean running;
    @Nullable
    private volatile Exception shutdownException;

    public HardwareVideoEncoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String string, VideoCodecType videoCodecType, Integer n, Integer n2, Map<String, String> map, int n3, int n4, BitrateAdjuster bitrateAdjuster, EglBase14.Context context) {
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = string;
        this.codecType = videoCodecType;
        this.surfaceColorFormat = n;
        this.yuvColorFormat = n2;
        this.yuvFormat = YuvFormat.valueOf(n2);
        this.params = map;
        this.keyFrameIntervalSec = n3;
        this.forcedKeyFrameNs = TimeUnit.MILLISECONDS.toNanos(n4);
        this.bitrateAdjuster = bitrateAdjuster;
        this.sharedContext = context;
        this.encodeThreadChecker.detachThread();
    }

    @Override
    public VideoCodecStatus initEncode(VideoEncoder.Settings settings, VideoEncoder.Callback callback) {
        this.encodeThreadChecker.checkIsOnValidThread();
        this.callback = callback;
        this.automaticResizeOn = settings.automaticResizeOn;
        this.width = settings.width;
        this.height = settings.height;
        this.useSurfaceMode = this.canUseSurface();
        if (settings.startBitrate != 0 && settings.maxFramerate != 0) {
            this.bitrateAdjuster.setTargets(settings.startBitrate * 1000, settings.maxFramerate);
        }
        this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
        Logging.d(TAG, "initEncode: " + this.width + " x " + this.height + ". @ " + settings.startBitrate + "kbps. Fps: " + settings.maxFramerate + " Use surface mode: " + this.useSurfaceMode);
        return this.initEncodeInternal();
    }

    private VideoCodecStatus initEncodeInternal() {
        this.encodeThreadChecker.checkIsOnValidThread();
        this.lastKeyFrameNs = -1L;
        try {
            this.codec = this.mediaCodecWrapperFactory.createByCodecName(this.codecName);
        }
        catch (IOException | IllegalArgumentException exception) {
            Logging.e(TAG, "Cannot create media encoder " + this.codecName);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        int n = this.useSurfaceMode ? this.surfaceColorFormat : this.yuvColorFormat;
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)this.width, (int)this.height);
            mediaFormat.setInteger("bitrate", this.adjustedBitrate);
            mediaFormat.setInteger(KEY_BITRATE_MODE, 2);
            mediaFormat.setInteger("color-format", n);
            mediaFormat.setInteger("frame-rate", this.bitrateAdjuster.getCodecConfigFramerate());
            mediaFormat.setInteger("i-frame-interval", this.keyFrameIntervalSec);
            if (this.codecType == VideoCodecType.H264) {
                String string = this.params.get("profile-level-id");
                if (string == null) {
                    string = "42e01f";
                }
                switch (string) {
                    case "640c1f": {
                        mediaFormat.setInteger("profile", 8);
                        mediaFormat.setInteger("level", 256);
                        break;
                    }
                    case "42e01f": {
                        break;
                    }
                    default: {
                        Logging.w(TAG, "Unknown profile level id: " + string);
                    }
                }
            }
            Logging.d(TAG, "Format: " + mediaFormat);
            this.codec.configure(mediaFormat, null, null, 1);
            if (this.useSurfaceMode) {
                this.textureEglBase = new EglBase14(this.sharedContext, EglBase.CONFIG_RECORDABLE);
                this.textureInputSurface = this.codec.createInputSurface();
                this.textureEglBase.createSurface(this.textureInputSurface);
                this.textureEglBase.makeCurrent();
            }
            this.codec.start();
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initEncodeInternal failed", illegalStateException);
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.running = true;
        this.outputThreadChecker.detachThread();
        this.outputThread = this.createOutputThread();
        this.outputThread.start();
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus release() {
        VideoCodecStatus videoCodecStatus;
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.outputThread == null) {
            videoCodecStatus = VideoCodecStatus.OK;
        } else {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                videoCodecStatus = VideoCodecStatus.TIMEOUT;
            } else if (this.shutdownException != null) {
                Logging.e(TAG, "Media encoder release exception", this.shutdownException);
                videoCodecStatus = VideoCodecStatus.ERROR;
            } else {
                videoCodecStatus = VideoCodecStatus.OK;
            }
        }
        this.textureDrawer.release();
        this.videoFrameDrawer.release();
        if (this.textureEglBase != null) {
            this.textureEglBase.release();
            this.textureEglBase = null;
        }
        if (this.textureInputSurface != null) {
            this.textureInputSurface.release();
            this.textureInputSurface = null;
        }
        this.outputBuilders.clear();
        this.codec = null;
        this.outputThread = null;
        this.encodeThreadChecker.detachThread();
        return videoCodecStatus;
    }

    @Override
    public VideoCodecStatus encode(VideoFrame videoFrame, VideoEncoder.EncodeInfo encodeInfo) {
        VideoCodecStatus videoCodecStatus;
        boolean bl;
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.codec == null) {
            return VideoCodecStatus.UNINITIALIZED;
        }
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        boolean bl2 = buffer instanceof VideoFrame.TextureBuffer;
        int n = videoFrame.getBuffer().getWidth();
        int n2 = videoFrame.getBuffer().getHeight();
        boolean bl3 = bl = this.canUseSurface() && bl2;
        if ((n != this.width || n2 != this.height || bl != this.useSurfaceMode) && (videoCodecStatus = this.resetCodec(n, n2, bl)) != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        if (this.outputBuilders.size() > 2) {
            Logging.e(TAG, "Dropped frame, encoder queue full");
            return VideoCodecStatus.NO_OUTPUT;
        }
        boolean bl4 = false;
        for (EncodedImage.FrameType frameType : encodeInfo.frameTypes) {
            if (frameType != EncodedImage.FrameType.VideoFrameKey) continue;
            bl4 = true;
        }
        if (bl4 || this.shouldForceKeyFrame(videoFrame.getTimestampNs())) {
            this.requestKeyFrame(videoFrame.getTimestampNs());
        }
        int n3 = buffer.getHeight() * buffer.getWidth() * 3 / 2;
        EncodedImage.Builder builder = EncodedImage.builder().setCaptureTimeNs(videoFrame.getTimestampNs()).setCompleteFrame(true).setEncodedWidth(videoFrame.getBuffer().getWidth()).setEncodedHeight(videoFrame.getBuffer().getHeight()).setRotation(videoFrame.getRotation());
        this.outputBuilders.offer(builder);
        VideoCodecStatus videoCodecStatus2 = this.useSurfaceMode ? this.encodeTextureBuffer(videoFrame) : this.encodeByteBuffer(videoFrame, buffer, n3);
        if (videoCodecStatus2 != VideoCodecStatus.OK) {
            this.outputBuilders.pollLast();
        }
        return videoCodecStatus2;
    }

    private VideoCodecStatus encodeTextureBuffer(VideoFrame videoFrame) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            GLES20.glClear((int)16384);
            VideoFrame videoFrame2 = new VideoFrame(videoFrame.getBuffer(), 0, videoFrame.getTimestampNs());
            this.videoFrameDrawer.drawFrame(videoFrame2, this.textureDrawer, null);
            this.textureEglBase.swapBuffers(videoFrame.getTimestampNs());
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "encodeTexture failed", runtimeException);
            return VideoCodecStatus.ERROR;
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus encodeByteBuffer(VideoFrame videoFrame, VideoFrame.Buffer buffer, int n) {
        ByteBuffer byteBuffer;
        int n2;
        this.encodeThreadChecker.checkIsOnValidThread();
        long l = (videoFrame.getTimestampNs() + 500L) / 1000L;
        try {
            n2 = this.codec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueInputBuffer failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        if (n2 == -1) {
            Logging.d(TAG, "Dropped frame, no input buffers available");
            return VideoCodecStatus.NO_OUTPUT;
        }
        try {
            byteBuffer = this.codec.getInputBuffers()[n2];
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "getInputBuffers failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        this.fillInputBuffer(byteBuffer, buffer);
        try {
            this.codec.queueInputBuffer(n2, 0, n, l, 0);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "queueInputBuffer failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus setChannelParameters(short s, long l) {
        this.encodeThreadChecker.checkIsOnValidThread();
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus setRateAllocation(VideoEncoder.BitrateAllocation bitrateAllocation, int n) {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (n > 30) {
            n = 30;
        }
        this.bitrateAdjuster.setTargets(bitrateAllocation.getSum(), n);
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoEncoder.ScalingSettings getScalingSettings() {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.automaticResizeOn) {
            if (this.codecType == VideoCodecType.VP8) {
                int n = 29;
                int n2 = 95;
                return new VideoEncoder.ScalingSettings(29, 95);
            }
            if (this.codecType == VideoCodecType.H264) {
                int n = 24;
                int n3 = 37;
                return new VideoEncoder.ScalingSettings(24, 37);
            }
        }
        return VideoEncoder.ScalingSettings.OFF;
    }

    @Override
    public String getImplementationName() {
        return "HWEncoder";
    }

    private VideoCodecStatus resetCodec(int n, int n2, boolean bl) {
        this.encodeThreadChecker.checkIsOnValidThread();
        VideoCodecStatus videoCodecStatus = this.release();
        if (videoCodecStatus != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        this.width = n;
        this.height = n2;
        this.useSurfaceMode = bl;
        return this.initEncodeInternal();
    }

    private boolean shouldForceKeyFrame(long l) {
        this.encodeThreadChecker.checkIsOnValidThread();
        return this.forcedKeyFrameNs > 0L && l > this.lastKeyFrameNs + this.forcedKeyFrameNs;
    }

    private void requestKeyFrame(long l) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            Bundle bundle = new Bundle();
            bundle.putInt("request-sync", 0);
            this.codec.setParameters(bundle);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "requestKeyFrame failed", illegalStateException);
            return;
        }
        this.lastKeyFrameNs = l;
    }

    private Thread createOutputThread() {
        return new Thread(){

            @Override
            public void run() {
                while (HardwareVideoEncoder.this.running) {
                    HardwareVideoEncoder.this.deliverEncodedImage();
                }
                HardwareVideoEncoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    protected void deliverEncodedImage() {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n = this.codec.dequeueOutputBuffer(bufferInfo, 100000L);
            if (n < 0) {
                return;
            }
            ByteBuffer byteBuffer = this.codec.getOutputBuffers()[n];
            byteBuffer.position(bufferInfo.offset);
            byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
            if ((bufferInfo.flags & 2) != 0) {
                Logging.d(TAG, "Config frame generated. Offset: " + bufferInfo.offset + ". Size: " + bufferInfo.size);
                this.configBuffer = ByteBuffer.allocateDirect(bufferInfo.size);
                this.configBuffer.put(byteBuffer);
            } else {
                ByteBuffer byteBuffer2;
                boolean bl;
                this.bitrateAdjuster.reportEncodedFrame(bufferInfo.size);
                if (this.adjustedBitrate != this.bitrateAdjuster.getAdjustedBitrateBps()) {
                    this.updateBitrate();
                }
                boolean bl2 = bl = (bufferInfo.flags & 1) != 0;
                if (bl) {
                    Logging.d(TAG, "Sync frame generated");
                }
                if (bl && this.codecType == VideoCodecType.H264) {
                    Logging.d(TAG, "Prepending config frame of size " + this.configBuffer.capacity() + " to output buffer with offset " + bufferInfo.offset + ", size " + bufferInfo.size);
                    byteBuffer2 = ByteBuffer.allocateDirect(bufferInfo.size + this.configBuffer.capacity());
                    this.configBuffer.rewind();
                    byteBuffer2.put(this.configBuffer);
                    byteBuffer2.put(byteBuffer);
                    byteBuffer2.rewind();
                } else {
                    byteBuffer2 = byteBuffer.slice();
                }
                EncodedImage.FrameType frameType = bl ? EncodedImage.FrameType.VideoFrameKey : EncodedImage.FrameType.VideoFrameDelta;
                EncodedImage.Builder builder = this.outputBuilders.poll();
                builder.setBuffer(byteBuffer2).setFrameType(frameType);
                this.callback.onEncodedFrame(builder.createEncodedImage(), new VideoEncoder.CodecSpecificInfo());
            }
            this.codec.releaseOutputBuffer(n, false);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "deliverOutput failed", illegalStateException);
        }
    }

    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Releasing MediaCodec on output thread");
        try {
            this.codec.stop();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media encoder stop failed", exception);
        }
        try {
            this.codec.release();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media encoder release failed", exception);
            this.shutdownException = exception;
        }
        this.configBuffer = null;
        Logging.d(TAG, "Release on output thread done");
    }

    private VideoCodecStatus updateBitrate() {
        this.outputThreadChecker.checkIsOnValidThread();
        this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
        try {
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", this.adjustedBitrate);
            this.codec.setParameters(bundle);
            return VideoCodecStatus.OK;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "updateBitrate failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
    }

    private boolean canUseSurface() {
        return this.sharedContext != null && this.surfaceColorFormat != null;
    }

    protected void fillInputBuffer(ByteBuffer byteBuffer, VideoFrame.Buffer buffer) {
        this.yuvFormat.fillBuffer(byteBuffer, buffer);
    }

    private static enum YuvFormat {
        I420{

            @Override
            void fillBuffer(ByteBuffer byteBuffer, VideoFrame.Buffer buffer) {
                VideoFrame.I420Buffer i420Buffer = buffer.toI420();
                YuvHelper.I420Copy(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), byteBuffer, i420Buffer.getWidth(), i420Buffer.getHeight());
                i420Buffer.release();
            }
        }
        ,
        NV12{

            @Override
            void fillBuffer(ByteBuffer byteBuffer, VideoFrame.Buffer buffer) {
                VideoFrame.I420Buffer i420Buffer = buffer.toI420();
                YuvHelper.I420ToNV12(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), byteBuffer, i420Buffer.getWidth(), i420Buffer.getHeight());
                i420Buffer.release();
            }
        };


        abstract void fillBuffer(ByteBuffer var1, VideoFrame.Buffer var2);

        static YuvFormat valueOf(int n) {
            switch (n) {
                case 19: {
                    return I420;
                }
                case 21: 
                case 2141391872: 
                case 2141391876: {
                    return NV12;
                }
            }
            throw new IllegalArgumentException("Unsupported colorFormat: " + n);
        }
    }
}

