/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.microedition.khronos.egl.EGL10;

public class GlUtil {
    private GlUtil() {
    }

    public static void checkNoGLES2Error(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            throw new RuntimeException(string + ": GLES20 error: " + n);
        }
    }

    public static FloatBuffer createFloatBuffer(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return floatBuffer;
    }

    public static int generateTexture(int n) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        int n2 = nArray[0];
        GLES20.glBindTexture((int)n, (int)n2);
        GLES20.glTexParameterf((int)n, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)n, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)n, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)n, (int)10243, (float)33071.0f);
        GLES20.glDisable((int)2929);
        GLES20.glDisable((int)2884);
        GLES20.glDisable((int)3042);
        GLES20.glActiveTexture((int)33984);
        GlUtil.checkNoGLES2Error("generateTexture");
        return n2;
    }

    public static void checkGlError(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"CheckGL: ", (String)(string + ": glGetError: 0x" + Integer.toHexString(n)));
            throw new RuntimeException("glGetError encountered (see log)");
        }
    }

    private static void checkEglError(String string, EGL10 eGL10) {
        int n;
        while ((n = eGL10.eglGetError()) != 12288) {
            Log.e((String)"CheckGL: ", (String)String.format("%s: EGL error: 0x%x", string, n));
        }
    }

    public static void checkLocation(int n, String string) {
        if (n < 0) {
            throw new RuntimeException("Unable to locate '" + string + "' in program");
        }
    }

    public static int createExternalTextureObject() {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GlUtil.checkGlError("glGenTextures");
        int n = nArray[0];
        GLES20.glBindTexture((int)36197, (int)n);
        GlUtil.checkGlError("glBindTexture " + n);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GlUtil.checkGlError("glTexParameter");
        return n;
    }

    public static int loadTexture(Bitmap bitmap) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            Log.e((String)"ContentValues", (String)"Could not generate a new OpenGL texture object!");
            return 0;
        }
        if (bitmap == null) {
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            return 0;
        }
        GLES20.glBindTexture((int)3553, (int)nArray[0]);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9987);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        GLES20.glGenerateMipmap((int)3553);
        GLES20.glBlendFunc((int)770, (int)771);
        GLES20.glEnable((int)3042);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glDisable((int)3042);
        return nArray[0];
    }
}

