/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc;

import android.hardware.Camera;
import android.os.SystemClock;
import com.superrtc.Camera1Capturer;
import com.superrtc.CameraEnumerationAndroid;
import com.superrtc.CameraEnumerator;
import com.superrtc.CameraVideoCapturer;
import com.superrtc.Logging;
import com.superrtc.Size;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class Camera1Enumerator
implements CameraEnumerator {
    private static final String TAG = "Camera1Enumerator";
    private static List<List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats;
    private final boolean captureToTexture;

    public Camera1Enumerator() {
        this(true);
    }

    public Camera1Enumerator(boolean bl) {
        this.captureToTexture = bl;
    }

    @Override
    public String[] getDeviceNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int k = 0; k < Camera.getNumberOfCameras(); ++k) {
            String string = Camera1Enumerator.getDeviceName(k);
            if (string != null) {
                arrayList.add(string);
                Logging.d(TAG, "Index: " + k + ". " + string);
                continue;
            }
            Logging.e(TAG, "Index: " + k + ". Failed to query camera name.");
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    @Override
    public boolean isFrontFacing(String string) {
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(string));
        return cameraInfo != null && cameraInfo.facing == 1;
    }

    @Override
    public boolean isBackFacing(String string) {
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(string));
        return cameraInfo != null && cameraInfo.facing == 0;
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(String string) {
        return Camera1Enumerator.getSupportedFormats(Camera1Enumerator.getCameraIndex(string));
    }

    @Override
    public CameraVideoCapturer createCapturer(String string, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler) {
        return new Camera1Capturer(string, cameraEventsHandler, this.captureToTexture);
    }

    @Nullable
    private static Camera.CameraInfo getCameraInfo(int n) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
        }
        catch (Exception exception) {
            Logging.e(TAG, "getCameraInfo failed on index " + n, exception);
            return null;
        }
        return cameraInfo;
    }

    static synchronized List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(int n) {
        if (cachedSupportedFormats == null) {
            cachedSupportedFormats = new ArrayList<List<CameraEnumerationAndroid.CaptureFormat>>();
            for (int k = 0; k < Camera.getNumberOfCameras(); ++k) {
                cachedSupportedFormats.add(Camera1Enumerator.enumerateFormats(k));
            }
        }
        return cachedSupportedFormats.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CameraEnumerationAndroid.CaptureFormat> enumerateFormats(int n) {
        Camera.Parameters parameters;
        Logging.d(TAG, "Get supported formats for camera index " + n + ".");
        long l = SystemClock.elapsedRealtime();
        Camera camera = null;
        try {
            Logging.d(TAG, "Opening camera with index " + n);
            camera = Camera.open((int)n);
            parameters = camera.getParameters();
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Open camera failed on camera index " + n, runtimeException);
            ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            return arrayList;
        }
        finally {
            if (camera != null) {
                camera.release();
            }
        }
        ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
        try {
            Object object;
            Object exception;
            boolean n2 = false;
            boolean bl = false;
            List list = parameters.getSupportedPreviewFpsRange();
            if (list != null) {
                Object object2 = (int[])list.get(list.size() - 1);
                exception = object2[0];
                object = object2[1];
            }
            for (Camera.Size size : parameters.getSupportedPreviewSizes()) {
                arrayList.add(new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, (int)exception, (int)object));
            }
        }
        catch (Exception l2) {
            Logging.e(TAG, "getSupportedFormats() failed on camera index " + n, l2);
        }
        long l2 = SystemClock.elapsedRealtime();
        Logging.d(TAG, "Get supported formats for camera index " + n + " done. Time spent: " + (l2 - l) + " ms.");
        return arrayList;
    }

    static List<Size> convertSizes(List<Camera.Size> list) {
        ArrayList<Size> arrayList = new ArrayList<Size>();
        for (Camera.Size size : list) {
            arrayList.add(new Size(size.width, size.height));
        }
        return arrayList;
    }

    static List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> convertFramerates(List<int[]> list) {
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        for (int[] nArray : list) {
            arrayList.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange(nArray[0], nArray[1]));
        }
        return arrayList;
    }

    static int getCameraIndex(String string) {
        Logging.d(TAG, "getCameraIndex: " + string);
        for (int k = 0; k < Camera.getNumberOfCameras(); ++k) {
            if (!string.equals(Camera1Enumerator.getDeviceName(k))) continue;
            return k;
        }
        throw new IllegalArgumentException("No such camera: " + string);
    }

    @Nullable
    static String getDeviceName(int n) {
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(n);
        if (cameraInfo == null) {
            return null;
        }
        String string = cameraInfo.facing == 1 ? "front" : "back";
        return "Camera " + n + ", Facing " + string + ", Orientation " + cameraInfo.orientation;
    }
}

