/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMChatRoomChangeListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMChatRoom;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMPageResult;
import com.hyphenate.chat.EMSessionManager;
import com.hyphenate.chat.adapter.EMAChatRoom;
import com.hyphenate.chat.adapter.EMAChatRoomManager;
import com.hyphenate.chat.adapter.EMAChatRoomManagerListener;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.exceptions.HyphenateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EMChatRoomManager {
    EMAChatRoomManager emaObject;
    private List<EMChatRoomChangeListener> chatRoomListeners = Collections.synchronizedList(new ArrayList());
    private ExecutorService threadPool = null;
    private List<EMChatRoom> chatRooms = Collections.synchronizedList(new ArrayList());
    EMClient mClient;
    EMAChatRoomManagerListener chatRoomListenerImpl = new EMAChatRoomManagerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveChatRoom(EMAChatRoom eMAChatRoom, int n) {
            EMClient.getInstance().chatManager().caches.remove(eMAChatRoom.getId());
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        if (n == 1) {
                            eMChatRoomChangeListener.onChatRoomDestroyed(eMAChatRoom.getId(), eMAChatRoom.getName());
                            continue;
                        }
                        eMChatRoomChangeListener.onRemovedFromChatRoom(n, eMAChatRoom.getId(), eMAChatRoom.getName(), EMClient.getInstance().getCurrentUser());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberJoinedChatRoom(EMAChatRoom eMAChatRoom, String string) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMemberJoined(eMAChatRoom.getId(), string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberLeftChatRoom(EMAChatRoom eMAChatRoom, String string) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMemberExited(eMAChatRoom.getId(), eMAChatRoom.getName(), string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddMuteList(EMAChatRoom eMAChatRoom, List<String> list, long l) {
            List list2 = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list2) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMuteListAdded(eMAChatRoom.getId(), list, l);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveMutes(EMAChatRoom eMAChatRoom, List<String> list) {
            List list2 = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list2) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onMuteListRemoved(eMAChatRoom.getId(), list);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhiteListAdded(EMAChatRoom eMAChatRoom, List<String> list) {
            List list2 = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list2) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onWhiteListAdded(eMAChatRoom.getId(), list);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhiteListRemoved(EMAChatRoom eMAChatRoom, List<String> list) {
            List list2 = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list2) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onWhiteListRemoved(eMAChatRoom.getId(), list);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAllMemberMuteStateChanged(EMAChatRoom eMAChatRoom, boolean bl) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onAllMemberMuteStateChanged(eMAChatRoom.getId(), bl);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddAdmin(EMAChatRoom eMAChatRoom, String string) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onAdminAdded(eMAChatRoom.getId(), string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveAdmin(EMAChatRoom eMAChatRoom, String string) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onAdminRemoved(eMAChatRoom.getId(), string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOwnerChanged(EMAChatRoom eMAChatRoom, String string, String string2) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onOwnerChanged(eMAChatRoom.getId(), string, string2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAnnouncementChanged(EMAChatRoom eMAChatRoom, String string) {
            List list = EMChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (EMChatRoomChangeListener eMChatRoomChangeListener : EMChatRoomManager.this.chatRoomListeners) {
                        eMChatRoomChangeListener.onAnnouncementChanged(eMAChatRoom.getId(), string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    };

    public EMChatRoomManager(EMClient eMClient, EMAChatRoomManager eMAChatRoomManager) {
        this.emaObject = eMAChatRoomManager;
        this.emaObject.addListener(this.chatRoomListenerImpl);
        this.mClient = eMClient;
        this.threadPool = Executors.newCachedThreadPool();
    }

    public void addChatRoomChangeListener(EMChatRoomChangeListener eMChatRoomChangeListener) {
        this.chatRoomListeners.add(eMChatRoomChangeListener);
    }

    @Deprecated
    public void removeChatRoomChangeListener(EMChatRoomChangeListener eMChatRoomChangeListener) {
        this.removeChatRoomListener(eMChatRoomChangeListener);
    }

    public void removeChatRoomListener(EMChatRoomChangeListener eMChatRoomChangeListener) {
        this.chatRoomListeners.remove(eMChatRoomChangeListener);
    }

    public void joinChatRoom(final String string, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMAChatRoom eMAChatRoom = EMChatRoomManager.this.emaObject.joinChatRoom(string, eMAError);
                EMChatRoom eMChatRoom = new EMChatRoom(eMAChatRoom);
                if (eMAError.errCode() == 0 || eMAError.errCode() == 701) {
                    eMValueCallBack.onSuccess(eMChatRoom);
                } else {
                    eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void leaveChatRoom(final String string) {
        EMChatRoom eMChatRoom = this.getChatRoom(string);
        if (eMChatRoom == null) {
            return;
        }
        EMOptions eMOptions = EMClient.getInstance().getOptions();
        boolean bl = eMOptions.isChatroomOwnerLeaveAllowed();
        String string2 = eMChatRoom.getOwner();
        if (!bl && string2.equals(EMSessionManager.getInstance().getLastLoginUser())) {
            return;
        }
        boolean bl2 = eMOptions.isDeleteMessagesAsExitChatRoom();
        if (bl2) {
            EMClient.getInstance().chatManager().deleteConversation(string, true);
        }
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMChatRoomManager.this.emaObject.leaveChatRoom(string, eMAError);
            }
        });
    }

    public EMPageResult<EMChatRoom> fetchPublicChatRoomsFromServer(int n, int n2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMPageResult<EMAChatRoom> eMPageResult = this.emaObject.fetchChatroomsWithPage(n, n2, eMAError);
        this.handleError(eMAError);
        List list = (List)eMPageResult.getData();
        int n3 = eMPageResult.getPageCount();
        EMPageResult<EMChatRoom> eMPageResult2 = new EMPageResult<EMChatRoom>();
        ArrayList<EMChatRoom> arrayList = new ArrayList<EMChatRoom>();
        for (EMAChatRoom eMAChatRoom : list) {
            arrayList.add(new EMChatRoom(eMAChatRoom));
        }
        eMPageResult2.setPageCount(n3);
        eMPageResult2.setData(arrayList);
        this.chatRooms.clear();
        this.chatRooms.addAll(arrayList);
        return eMPageResult2;
    }

    public EMCursorResult<EMChatRoom> fetchPublicChatRoomsFromServer(int n, String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMAChatRoom> eMCursorResult = this.emaObject.fetchChatroomsWithCursor(string, n, eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMChatRoom> eMCursorResult2 = new EMCursorResult<EMChatRoom>();
        ArrayList<EMChatRoom> arrayList = new ArrayList<EMChatRoom>();
        for (EMAChatRoom eMAChatRoom : (List)eMCursorResult.getData()) {
            arrayList.add(new EMChatRoom(eMAChatRoom));
        }
        eMCursorResult2.setCursor(eMCursorResult.getCursor());
        eMCursorResult2.setData(arrayList);
        this.chatRooms.clear();
        this.chatRooms.addAll(arrayList);
        return eMCursorResult2;
    }

    public void asyncFetchPublicChatRoomsFromServer(final int n, final String string, final EMValueCallBack<EMCursorResult<EMChatRoom>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult<EMChatRoom> eMCursorResult = EMChatRoomManager.this.fetchPublicChatRoomsFromServer(n, string);
                    eMValueCallBack.onSuccess(eMCursorResult);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void asyncFetchPublicChatRoomsFromServer(final int n, final int n2, final EMValueCallBack<EMPageResult<EMChatRoom>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMPageResult<EMChatRoom> eMPageResult = EMChatRoomManager.this.fetchPublicChatRoomsFromServer(n, n2);
                    eMValueCallBack.onSuccess(eMPageResult);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom fetchChatRoomFromServer(String string) throws HyphenateException {
        return this.fetchChatRoomFromServer(string, false);
    }

    public EMChatRoom fetchChatRoomFromServer(String string, boolean bl) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.fetchChatroomSpecification(string, eMAError, bl);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncFetchChatRoomFromServer(final String string, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatRoom eMChatRoom = EMChatRoomManager.this.fetchChatRoomFromServer(string);
                    eMValueCallBack.onSuccess(eMChatRoom);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom getChatRoom(String string) {
        EMAChatRoom eMAChatRoom = this.emaObject.getChatroom(string);
        if (eMAChatRoom == null) {
            return null;
        }
        return new EMChatRoom(eMAChatRoom);
    }

    public List<EMChatRoom> getAllChatRooms() {
        return Collections.unmodifiableList(this.chatRooms);
    }

    public EMChatRoom createChatRoom(String string, String string2, String string3, int n, List<String> list) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.createChatRoom(string, string2, string3, EMChatRoom.EMChatRoomStyle.EMChatRoomStylePublicOpenJoin.ordinal(), n, list, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncCreateChatRoom(final String string, final String string2, final String string3, final int n, final List<String> list, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.createChatRoom(string, string2, string3, n, list));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void destroyChatRoom(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.destroyChatroom(string, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDestroyChatRoom(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatRoomManager.this.destroyChatRoom(string);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom changeChatRoomSubject(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.changeChatroomSubject(string, string2, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncChangeChatRoomSubject(final String string, final String string2, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.changeChatRoomSubject(string, string2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom changeChatroomDescription(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.changeChatroomDescription(string, string2, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncChangeChatroomDescription(final String string, final String string2, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.changeChatroomDescription(string, string2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMCursorResult<String> fetchChatRoomMembers(String string, String string2, int n) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<String> eMCursorResult = this.emaObject.fetchChatroomMembers(string, string2, n, eMAError);
        this.handleError(eMAError);
        return eMCursorResult;
    }

    public void asyncFetchChatRoomMembers(final String string, final String string2, final int n, final EMValueCallBack<EMCursorResult<String>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.fetchChatRoomMembers(string, string2, n));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom muteChatRoomMembers(String string, List<String> list, long l) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.muteChatroomMembers(string, list, l, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncMuteChatRoomMembers(final String string, final List<String> list, final long l, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.muteChatRoomMembers(string, list, l));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom unMuteChatRoomMembers(String string, List<String> list) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.unmuteChatRoomMembers(string, list, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncUnMuteChatRoomMembers(final String string, final List<String> list, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.unMuteChatRoomMembers(string, list));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom changeOwner(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.transferChatroomOwner(string, string2, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncChangeOwner(final String string, final String string2, final EMValueCallBack<EMChatRoom> eMValueCallBack) throws HyphenateException {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.changeOwner(string, string2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom addChatRoomAdmin(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.addChatroomAdmin(string, string2, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncAddChatRoomAdmin(final String string, final String string2, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.addChatRoomAdmin(string, string2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom removeChatRoomAdmin(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.removeChatRoomAdmin(string, string2, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncRemoveChatRoomAdmin(final String string, final String string2, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.removeChatRoomAdmin(string, string2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public Map<String, Long> fetchChatRoomMuteList(String string, int n, int n2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        Map<String, Long> map = this.emaObject.fetchChatRoomMuteList(string, n, n2, eMAError);
        this.handleError(eMAError);
        return map;
    }

    public void asyncFetchChatRoomMuteList(final String string, final int n, final int n2, final EMValueCallBack<Map<String, Long>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.fetchChatRoomMuteList(string, n, n2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom removeChatRoomMembers(String string, List<String> list) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.removeChatRoomMembers(string, list, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncRemoveChatRoomMembers(final String string, final List<String> list, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.removeChatRoomMembers(string, list));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom blockChatroomMembers(String string, List<String> list) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.blockChatroomMembers(string, list, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncBlockChatroomMembers(final String string, final List<String> list, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.blockChatroomMembers(string, list));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMChatRoom unblockChatRoomMembers(String string, List<String> list) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.unblockChatRoomMembers(string, list, eMAError);
        this.handleError(eMAError);
        return new EMChatRoom(eMAChatRoom);
    }

    public void asyncUnBlockChatRoomMembers(final String string, final List<String> list, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.unblockChatRoomMembers(string, list));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public List<String> fetchChatRoomBlackList(String string, int n, int n2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.fetchChatRoomBlackList(string, n, n2, eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncFetchChatRoomBlackList(final String string, final int n, final int n2, final EMValueCallBack<List<String>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.fetchChatRoomBlackList(string, n, n2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void addToChatRoomWhiteList(final String string, final List<String> list, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAChatRoom eMAChatRoom = EMChatRoomManager.this.emaObject.addToWhiteList(string, list, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    eMValueCallBack.onSuccess(new EMChatRoom(eMAChatRoom));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void removeFromChatRoomWhiteList(final String string, final List<String> list, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAChatRoom eMAChatRoom = EMChatRoomManager.this.emaObject.removeFromWhiteList(string, list, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    eMValueCallBack.onSuccess(new EMChatRoom(eMAChatRoom));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void checkIfInChatRoomWhiteList(final String string, final EMValueCallBack<Boolean> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    Boolean bl = EMChatRoomManager.this.emaObject.checkIfInWhiteList(string, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    eMValueCallBack.onSuccess(bl);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void fetchChatRoomWhiteList(final String string, final EMValueCallBack<List<String>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    List<String> list = EMChatRoomManager.this.emaObject.fetchChatRoomWhiteList(string, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    eMValueCallBack.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void muteAllMembers(final String string, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAChatRoom eMAChatRoom = EMChatRoomManager.this.emaObject.muteAllMembers(string, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    eMValueCallBack.onSuccess(new EMChatRoom(eMAChatRoom));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void unmuteAllMembers(final String string, final EMValueCallBack<EMChatRoom> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAChatRoom eMAChatRoom = EMChatRoomManager.this.emaObject.unmuteAllMembers(string, eMAError);
                    EMChatRoomManager.this.handleError(eMAError);
                    eMValueCallBack.onSuccess(new EMChatRoom(eMAChatRoom));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void updateChatRoomAnnouncement(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.updateChatRoomAnnouncement(string, string2, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUpdateChatRoomAnnouncement(final String string, final String string2, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatRoomManager.this.updateChatRoomAnnouncement(string, string2);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public String fetchChatRoomAnnouncement(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string2 = this.emaObject.fetchChatRoomAnnouncement(string, eMAError);
        this.handleError(eMAError);
        return string2;
    }

    public void asyncFetchChatRoomAnnouncement(final String string, final EMValueCallBack<String> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMChatRoomManager.this.fetchChatRoomAnnouncement(string));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            throw new HyphenateException(eMAError);
        }
    }

    void onLogout() {
        this.chatRoomListeners.clear();
    }
}

