/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.content.Context;
import com.superrtc.call.CameraEnumerationAndroid;
import com.superrtc.call.SurfaceTextureHelper;
import java.util.List;

public interface VideoCapturer {
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats();

    public SurfaceTextureHelper getSurfaceTextureHelper();

    public boolean getSupportedGetCameraFormats();

    public void startCapture(int var1, int var2, int var3, Context var4, CapturerObserver var5);

    public void stopCapture() throws InterruptedException;

    public void dispose();

    public static class NativeObserver
    implements CapturerObserver {
        private final long nativeCapturer;

        public NativeObserver(long l) {
            this.nativeCapturer = l;
        }

        @Override
        public void onCapturerStarted(boolean bl) {
            this.nativeCapturerStarted(this.nativeCapturer, bl);
        }

        @Override
        public void onByteBufferFrameCaptured(byte[] byArray, int n, int n2, int n3, long l) {
            this.nativeOnByteBufferFrameCaptured(this.nativeCapturer, byArray, byArray.length, n, n2, n3, l);
        }

        @Override
        public void onBitmapFrameCaptured(int[] nArray, int n, int n2, int n3, long l) {
            this.nativeOnBitmapFrameCpatured(this.nativeCapturer, nArray, nArray.length, n, n2, n3, l);
        }

        @Override
        public void onTextureFrameCaptured(int n, int n2, int n3, float[] fArray, int n4, long l) {
            this.nativeOnTextureFrameCaptured(this.nativeCapturer, n, n2, n3, fArray, n4, l);
        }

        @Override
        public void onOutputFormatRequest(int n, int n2, int n3) {
            this.nativeOnOutputFormatRequest(this.nativeCapturer, n, n2, n3);
        }

        private native void nativeCapturerStarted(long var1, boolean var3);

        private native void nativeOnByteBufferFrameCaptured(long var1, byte[] var3, int var4, int var5, int var6, int var7, long var8);

        private native void nativeOnBitmapFrameCpatured(long var1, int[] var3, int var4, int var5, int var6, int var7, long var8);

        private native void nativeOnTextureFrameCaptured(long var1, int var3, int var4, int var5, float[] var6, int var7, long var8);

        private native void nativeOnOutputFormatRequest(long var1, int var3, int var4, int var5);
    }

    public static interface CapturerObserver {
        public void onCapturerStarted(boolean var1);

        public void onByteBufferFrameCaptured(byte[] var1, int var2, int var3, int var4, long var5);

        public void onBitmapFrameCaptured(int[] var1, int var2, int var3, int var4, long var5);

        public void onTextureFrameCaptured(int var1, int var2, int var3, float[] var4, int var5, long var6);

        public void onOutputFormatRequest(int var1, int var2, int var3);
    }
}

