/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.view.Surface;
import com.superrtc.call.EglBase;
import com.superrtc.call.EglBase14;
import com.superrtc.call.GlRectDrawer;
import com.superrtc.call.Logging;
import com.superrtc.call.ThreadUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@TargetApi(value=19)
public class MediaCodecVideoEncoder {
    private static final String TAG = "MediaCodecVideoEncoder";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_TIMEOUT = 0;
    private static MediaCodecVideoEncoder runningInstance = null;
    private static MediaCodecVideoEncoderErrorCallback errorCallback = null;
    private static int codecErrors = 0;
    private static Set<String> hwEncoderDisabledTypes = new HashSet<String>();
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    private ByteBuffer[] outputBuffers;
    private EglBase14 eglBase;
    private int width;
    private int height;
    private Surface inputSurface;
    private GlRectDrawer drawer;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String[] supportedVp8HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Intel."};
    private static final String[] supportedVp9HwCodecPrefixes = new String[]{"OMX.qcom."};
    private static final String[] supportedH264HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.hisi."};
    private static final String[] H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4"};
    private static final int VIDEO_ControlRateConstant = 2;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int[] supportedColorList = new int[]{19, 21, 2141391872, 2141391876};
    private static final int[] supportedSurfaceColorList = new int[]{2130708361};
    private VideoCodecType type;
    private int colorFormat;
    private ByteBuffer configData = null;

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback mediaCodecVideoEncoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoEncoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isVp9HwSupported() {
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isH264HwSupported() {
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isVp8HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, supportedSurfaceColorList) != null;
    }

    public static boolean isVp9HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes, supportedSurfaceColorList) != null;
    }

    public static boolean isH264HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedSurfaceColorList) != null;
    }

    private static EncoderProperties findHwEncoder(String string, String[] codecCapabilities, int[] nArray) {
        List<String> list;
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        if (string.equals(H264_MIME_TYPE) && (list = Arrays.asList(H264_HW_EXCEPTION_MODELS)).contains(Build.MODEL)) {
            Logging.w(TAG, "Model: " + Build.MODEL + " has black listed H.264 encoder.");
            return null;
        }
        for (int k = 0; k < MediaCodecList.getCodecCount(); ++k) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)k);
            if (!mediaCodecInfo.isEncoder()) continue;
            String string2 = null;
            for (String string3 : mediaCodecInfo.getSupportedTypes()) {
                if (!string3.equals(string)) continue;
                string2 = mediaCodecInfo.getName();
                break;
            }
            if (string2 == null) continue;
            Logging.v(TAG, "Found candidate encoder " + string2);
            boolean bl = false;
            for (String string4 : codecCapabilities) {
                if (!string2.startsWith(string4)) continue;
                bl = true;
                break;
            }
            Logging.d(TAG, "hw encoder supportedCodec  = " + bl);
            if (!bl) continue;
            MediaCodecInfo.CodecCapabilities codecCapabilities2 = mediaCodecInfo.getCapabilitiesForType(string);
            for (int n : codecCapabilities2.colorFormats) {
                Logging.v(TAG, "   Color: 0x" + Integer.toHexString(n));
            }
            for (int n : nArray) {
                for (int n2 : codecCapabilities2.colorFormats) {
                    if (n2 != n) continue;
                    Logging.d(TAG, "Found target encoder for mime " + string + " : " + string2 + ". Color: 0x" + Integer.toHexString(n2));
                    return new EncoderProperties(string2, n2);
                }
            }
        }
        return null;
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new RuntimeException("MediaCodecVideoEncoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoEncoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoEncoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoEncoder stacks trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    static MediaCodec createByCodecName(String string) {
        try {
            return MediaCodec.createByCodecName((String)string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    boolean initEncode(VideoCodecType videoCodecType, int n, int n2, int n3, int n4, EglBase14.Context context) {
        boolean bl = context != null;
        Logging.d(TAG, "Java initEncode: " + (Object)((Object)videoCodecType) + " : " + n + " x " + n2 + ". @ " + n3 + " kbps. Fps: " + n4 + ". Encode from texture : " + bl);
        this.width = n;
        this.height = n2;
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("Forgot to release()?");
        }
        EncoderProperties encoderProperties = null;
        String string = null;
        int n5 = 0;
        if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP8) {
            string = VP8_MIME_TYPE;
            encoderProperties = MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, bl ? supportedSurfaceColorList : supportedColorList);
            n5 = 100;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP9) {
            string = VP9_MIME_TYPE;
            encoderProperties = MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedH264HwCodecPrefixes, bl ? supportedSurfaceColorList : supportedColorList);
            n5 = 100;
        } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_H264) {
            string = H264_MIME_TYPE;
            encoderProperties = MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, bl ? supportedSurfaceColorList : supportedColorList);
            n5 = 20;
        }
        if (encoderProperties == null) {
            throw new RuntimeException("Can not find HW encoder for " + (Object)((Object)videoCodecType));
        }
        runningInstance = this;
        this.colorFormat = encoderProperties.colorFormat;
        Logging.d(TAG, "Color format: " + this.colorFormat);
        this.mediaCodecThread = Thread.currentThread();
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)string, (int)n, (int)n2);
            mediaFormat.setInteger("bitrate", 1000 * n3);
            mediaFormat.setInteger("bitrate-mode", 2);
            mediaFormat.setInteger("color-format", encoderProperties.colorFormat);
            mediaFormat.setInteger("frame-rate", n4);
            mediaFormat.setInteger("i-frame-interval", n5);
            Logging.d(TAG, "  Format: " + mediaFormat);
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(encoderProperties.codecName);
            this.type = videoCodecType;
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media encoder");
                return false;
            }
            this.mediaCodec.configure(mediaFormat, null, null, 1);
            if (bl) {
                this.eglBase = new EglBase14(context, EglBase.CONFIG_RECORDABLE);
                this.inputSurface = this.mediaCodec.createInputSurface();
                this.eglBase.createSurface(this.inputSurface);
                this.drawer = new GlRectDrawer();
            }
            this.mediaCodec.start();
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            Logging.d(TAG, "Output buffers: " + this.outputBuffers.length);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initEncode failed", illegalStateException);
            return false;
        }
        return true;
    }

    ByteBuffer[] getInputBuffers() {
        ByteBuffer[] byteBufferArray = this.mediaCodec.getInputBuffers();
        Logging.d(TAG, "Input buffers: " + byteBufferArray.length);
        return byteBufferArray;
    }

    boolean encodeBuffer(boolean bl, int n, int n2, long l) {
        this.checkOnMediaCodecThread();
        try {
            if (bl) {
                Logging.d(TAG, "Sync frame request");
                Bundle bundle = new Bundle();
                bundle.putInt("request-sync", 0);
                this.mediaCodec.setParameters(bundle);
            }
            this.mediaCodec.queueInputBuffer(n, 0, n2, l, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "encodeBuffer failed", illegalStateException);
            return false;
        }
    }

    boolean encodeTexture(boolean bl, int n, float[] fArray, long l) {
        this.checkOnMediaCodecThread();
        try {
            if (bl) {
                Logging.d(TAG, "Sync frame request");
                Bundle bundle = new Bundle();
                bundle.putInt("request-sync", 0);
                this.mediaCodec.setParameters(bundle);
            }
            this.eglBase.makeCurrent();
            GLES20.glClear((int)16384);
            this.drawer.drawOes(n, fArray, 0, 0, this.width, this.height);
            this.eglBase.swapBuffers(TimeUnit.MICROSECONDS.toNanos(l));
            return true;
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "encodeTexture failed", runtimeException);
            return false;
        }
    }

    void release() {
        Logging.d(TAG, "Java releaseEncoder");
        this.checkOnMediaCodecThread();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Logging.d(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread");
                    MediaCodecVideoEncoder.this.mediaCodec.stop();
                    MediaCodecVideoEncoder.this.mediaCodec.release();
                    Logging.d(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread done");
                }
                catch (Exception exception) {
                    Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder release failed", exception);
                }
                countDownLatch.countDown();
            }
        };
        new Thread(runnable).start();
        if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
            Logging.e(TAG, "Media encoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        if (this.drawer != null) {
            this.drawer.release();
            this.drawer = null;
        }
        if (this.eglBase != null) {
            this.eglBase.release();
            this.eglBase = null;
        }
        if (this.inputSurface != null) {
            this.inputSurface.release();
            this.inputSurface = null;
        }
        runningInstance = null;
        Logging.d(TAG, "Java releaseEncoder done");
    }

    private boolean setRates(int n, int n2) {
        this.checkOnMediaCodecThread();
        Logging.v(TAG, "setRates: " + n + " kbps. Fps: " + n2);
        try {
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", 1000 * n);
            this.mediaCodec.setParameters(bundle);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "setRates failed", illegalStateException);
            return false;
        }
    }

    int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    OutputBufferInfo dequeueOutputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
            if (n >= 0) {
                boolean bl;
                boolean bl2 = bl = (bufferInfo.flags & 2) != 0;
                if (bl) {
                    Logging.d(TAG, "Config frame generated. Offset: " + bufferInfo.offset + ". Size: " + bufferInfo.size);
                    this.configData = ByteBuffer.allocateDirect(bufferInfo.size);
                    this.outputBuffers[n].position(bufferInfo.offset);
                    this.outputBuffers[n].limit(bufferInfo.offset + bufferInfo.size);
                    this.configData.put(this.outputBuffers[n]);
                    this.mediaCodec.releaseOutputBuffer(n, false);
                    n = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
                }
            }
            if (n >= 0) {
                boolean bl;
                ByteBuffer byteBuffer = this.outputBuffers[n].duplicate();
                byteBuffer.position(bufferInfo.offset);
                byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
                boolean bl3 = bl = (bufferInfo.flags & 1) != 0;
                if (bl) {
                    Logging.d(TAG, "Sync frame generated");
                }
                if (bl && this.type == VideoCodecType.VIDEO_CODEC_H264) {
                    Logging.d(TAG, "Appending config frame of size " + this.configData.capacity() + " to output buffer with offset " + bufferInfo.offset + ", size " + bufferInfo.size);
                    ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.configData.capacity() + bufferInfo.size);
                    this.configData.rewind();
                    byteBuffer2.put(this.configData);
                    byteBuffer2.put(byteBuffer);
                    byteBuffer2.position(0);
                    return new OutputBufferInfo(n, byteBuffer2, bl, bufferInfo.presentationTimeUs);
                }
                return new OutputBufferInfo(n, byteBuffer.slice(), bl, bufferInfo.presentationTimeUs);
            }
            if (n == -3) {
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                return this.dequeueOutputBuffer();
            }
            if (n == -2) {
                return this.dequeueOutputBuffer();
            }
            if (n == -1) {
                return null;
            }
            throw new RuntimeException("dequeueOutputBuffer: " + n);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueOutputBuffer failed", illegalStateException);
            return new OutputBufferInfo(-1, null, false, -1L);
        }
    }

    boolean releaseOutputBuffer(int n) {
        this.checkOnMediaCodecThread();
        try {
            this.mediaCodec.releaseOutputBuffer(n, false);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "releaseOutputBuffer failed", illegalStateException);
            return false;
        }
    }

    static class OutputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        public OutputBufferInfo(int n, ByteBuffer byteBuffer, boolean bl, long l) {
            this.index = n;
            this.buffer = byteBuffer;
            this.isKeyFrame = bl;
            this.presentationTimestampUs = l;
        }
    }

    private static class EncoderProperties {
        public final String codecName;
        public final int colorFormat;

        public EncoderProperties(String string, int n) {
            this.codecName = string;
            this.colorFormat = n;
        }
    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;

    }
}

