/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.graphics.ImageFormat;
import android.hardware.Camera;
import com.superrtc.call.CameraEnumerator;
import com.superrtc.call.Logging;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CameraEnumerationAndroid {
    private static final String TAG = "CameraEnumerationAndroid";
    private static Enumerator enumerator = new CameraEnumerator();

    public static synchronized void setEnumerator(Enumerator enumerator) {
        CameraEnumerationAndroid.enumerator = enumerator;
    }

    public static synchronized List<CaptureFormat> getSupportedFormats(int n) {
        List<CaptureFormat> list = enumerator.getSupportedFormats(n);
        Logging.d(TAG, "Supported formats for camera " + n + ": " + list);
        return list;
    }

    public static String[] getDeviceNames() {
        String[] stringArray = new String[Camera.getNumberOfCameras()];
        for (int k = 0; k < Camera.getNumberOfCameras(); ++k) {
            stringArray[k] = CameraEnumerationAndroid.getDeviceName(k);
        }
        return stringArray;
    }

    public static int getDeviceCount() {
        return Camera.getNumberOfCameras();
    }

    public static String getDeviceName(int n) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
        }
        catch (Exception exception) {
            Logging.e(TAG, "getCameraInfo failed on index " + n, exception);
            return null;
        }
        String string = cameraInfo.facing == 1 ? "front" : "back";
        return "Camera " + n + ", Facing " + string + ", Orientation " + cameraInfo.orientation;
    }

    public static String getNameOfFrontFacingDevice() {
        return CameraEnumerationAndroid.getNameOfDevice(1);
    }

    public static String getNameOfBackFacingDevice() {
        return CameraEnumerationAndroid.getNameOfDevice(0);
    }

    public static int[] getFramerateRange(Camera.Parameters parameters, final int n) {
        List list = parameters.getSupportedPreviewFpsRange();
        if (list.isEmpty()) {
            Logging.w(TAG, "No supported preview fps range");
            return new int[]{0, 0};
        }
        return Collections.min(list, new ClosestComparator<int[]>(){

            @Override
            int diff(int[] nArray) {
                int n2 = 10;
                return nArray[0] + 10 * Math.abs(n - nArray[1]);
            }
        });
    }

    public static Camera.Size getClosestSupportedSize(List<Camera.Size> list, final int n, final int n2) {
        return Collections.min(list, new ClosestComparator<Camera.Size>(){

            @Override
            int diff(Camera.Size size) {
                return Math.abs(n - size.width) + Math.abs(n2 - size.height);
            }
        });
    }

    private static String getNameOfDevice(int n) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int k = 0; k < Camera.getNumberOfCameras(); ++k) {
            try {
                Camera.getCameraInfo((int)k, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing != n) continue;
                return CameraEnumerationAndroid.getDeviceName(k);
            }
            catch (Exception exception) {
                Logging.e(TAG, "getCameraInfo() failed on index " + k, exception);
            }
        }
        return null;
    }

    private static abstract class ClosestComparator<T>
    implements Comparator<T> {
        private ClosestComparator() {
        }

        abstract int diff(T var1);

        @Override
        public int compare(T t, T t2) {
            return this.diff(t) - this.diff(t2);
        }
    }

    public static class CaptureFormat {
        public final int width;
        public final int height;
        public final int maxFramerate;
        public final int minFramerate;
        public final int imageFormat = 17;

        public CaptureFormat(int n, int n2, int n3, int n4) {
            this.width = n;
            this.height = n2;
            this.minFramerate = n3;
            this.maxFramerate = n4;
        }

        public int frameSize() {
            return CaptureFormat.frameSize(this.width, this.height, 17);
        }

        public static int frameSize(int n, int n2, int n3) {
            if (n3 != 17) {
                throw new UnsupportedOperationException("Don't know how to calculate the frame size of non-NV21 image formats.");
            }
            return n * n2 * ImageFormat.getBitsPerPixel((int)n3) / 8;
        }

        public String toString() {
            return this.width + "x" + this.height + "@[" + this.minFramerate + ":" + this.maxFramerate + "]";
        }

        public boolean isSameFormat(CaptureFormat captureFormat) {
            if (captureFormat == null) {
                return false;
            }
            return this.width == captureFormat.width && this.height == captureFormat.height && this.maxFramerate == captureFormat.maxFramerate && this.minFramerate == captureFormat.minFramerate;
        }
    }

    public static interface Enumerator {
        public List<CaptureFormat> getSupportedFormats(int var1);
    }
}

