package com.hyphenate.push.platform.mi;

import android.content.Context;
import android.content.Intent;

import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.util.EMLog;
import com.xiaomi.mipush.sdk.ErrorCode;
import com.xiaomi.mipush.sdk.MiPushClient;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;

import java.util.List;

/**
 * Created by zhangsong on 19-2-20
 * <p>
 * 文档地址：https://dev.mi.com/console/doc/detail?pId=41
 */
public class EMMiMsgReceiver extends PushMessageReceiver {
    private static final String TAG = "EMMiMsgReceiver";

    public void onReceivePassThroughMessage(Context context, MiPushMessage message) {
        EMLog.i(TAG, "onReceivePassThroughMessage is called. " + message.toString());
    }

    public void onNotificationMessageClicked(Context context, MiPushMessage message) {
        EMLog.i(TAG, "onNotificationMessageClicked is called. " + message.toString());
        Intent msgIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        msgIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(msgIntent);
    }

    public void onNotificationMessageArrived(Context context, MiPushMessage message) {
        EMLog.i(TAG, "onNotificationMessageArrived is called. " + message.toString());
    }

    public void onCommandResult(Context context, MiPushCommandMessage message) {
        EMLog.i(TAG, "onCommandResult is called. " + message.toString());
    }

    public void onReceiveRegisterResult(Context context, MiPushCommandMessage message) {
        String command = message.getCommand();
        List<String> arguments = message.getCommandArguments();
        String cmdArg1 = arguments != null && arguments.size() > 0 ? (String) arguments.get(0) : null;
        String cmdArg2 = arguments != null && arguments.size() > 1 ? (String) arguments.get(1) : null;
        EMLog.i(TAG, "onReceiveRegisterResult. cmdArg1: " + cmdArg1 + "; cmdArg2:" + cmdArg2);
        if (MiPushClient.COMMAND_REGISTER.equals(command)) {
            if (message.getResultCode() == ErrorCode.SUCCESS) {
                EMPushHelper.getInstance().onReceiveToken(EMPushType.MIPUSH, cmdArg1);
            } else {
                EMPushHelper.getInstance().onErrorResponse(EMPushType.MIPUSH, message.getResultCode());
            }
        }
    }
}
