/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.core;

import com.hyphenate.chat.EMClient;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;

public class EMPreferenceUtils {
    /**
     * saved PreferenceName
     */
    private static final String PREFERENCE_NAME = "hyphenate.sdk.pref";
    private static SharedPreferences mSharedPreferences;
    private static SharedPreferences.Editor mEditor;
    private static EMPreferenceUtils mPreferenceUtils;

    private static String SHARED_KEY_DDVERSION = "shared_key_ddversion";
    private static String SHARED_KEY_DDXML = "shared_key_ddxml";
    private static String SHARED_KEY_DDTIME = "shared_key_ddtime";
    private static String VALID_BEFORE = "valid_before";
    private static String SCHEDULED_LOGOUT_TIME = "scheduled_logout_time";
    private static String SHARED_KEY_GCM_ID = "shared_key_gcm_id";
    private static String SHARED_KEY_FCM_ID = "shared_key_fcm_id";
    private static String PUSH_FLAG = "push_flag";
    private static String HW_APP_ID = "huawei_app_id";
    private static String HMS_TOKEN = "huawei_hms_token";
    private long reservedLogoutTime = 0;

    @SuppressLint("CommitPrefEdits")
    private EMPreferenceUtils(Context ctx){
        mSharedPreferences = ctx.getSharedPreferences(PREFERENCE_NAME, Context.MODE_PRIVATE);
        mEditor = mSharedPreferences.edit();
    }

    public static synchronized EMPreferenceUtils getInstance(){
        if(mPreferenceUtils == null){
            mPreferenceUtils = new EMPreferenceUtils(EMClient.getInstance().getContext());
        }
        return mPreferenceUtils;
    }

   /**
     * 设置DNS version
     * @param version
     */
    public void setDNSConfigVersion(String version){
        mEditor.putString(SHARED_KEY_DDVERSION, version);
        mEditor.commit();
    }

    /**
     * 设置DNS xml
     */
    public void setDNSConfig(String config){
        mEditor.putString(SHARED_KEY_DDXML, config);
        mEditor.commit();
    }

    /**
     * 设置DNS xml的获取时间
     * @param time
     */
    public void setDNSConfigTime(long time){
        mEditor.putLong(SHARED_KEY_DDTIME, time);
        mEditor.commit();
    }

    public void setDNSValidBefore(long time){
        mEditor.putLong(VALID_BEFORE, time);
        mEditor.commit();
    }

 public long getDNSValidBefore(){
        return mSharedPreferences.getLong(VALID_BEFORE, -1);
    }

    /**
     * 获取DNS 版本
     * @return
     */
    public String getDNSVersion(){
        return mSharedPreferences.getString(SHARED_KEY_DDVERSION, "");
    }

    /**
     * 获取DNS xml
     * @return
     */
    public String getDNSConfig(){
        return mSharedPreferences.getString(SHARED_KEY_DDXML, "");
    }

    /**
     * 从Server获取DNSxml时间（毫秒）
     * @return
     */
    public long getDNSTime(){
        return mSharedPreferences.getLong(SHARED_KEY_DDTIME, -1);
    }

    /**
     * 判断是否曾经预约过退出登录
     * @return
     */
    public boolean hasReservedLogoutTime() {
        if (reservedLogoutTime != 0) {
            return true;
        }
        return mSharedPreferences.contains(SCHEDULED_LOGOUT_TIME);
    }

    /**
     * 客服模式下获取预约的退出登录时间
     * @return
     */
    public long getLogoutTime(){
        if (reservedLogoutTime != 0) {
            return reservedLogoutTime;
        }
        reservedLogoutTime = mSharedPreferences.getLong(SCHEDULED_LOGOUT_TIME, -1);
        return reservedLogoutTime;
    }

    /**
     * 客服模式下设定预约的退出登录时间
     * @return
     */
    public void setLogoutTime(long time){
        reservedLogoutTime = time;
        mEditor.putLong(SCHEDULED_LOGOUT_TIME, time);
        mEditor.commit();
    }

    /**
     * 删除已经存在的退出登录时间的记录
     */
    public void removeLogoutTime() {
        if (hasReservedLogoutTime()) {
            reservedLogoutTime = 0;
            mEditor.remove(SCHEDULED_LOGOUT_TIME);
            mEditor.commit();
        }
    }

    public void setDebugServer(String imAddress, String restAddress){

        if(imAddress == null && restAddress == null){
            mEditor.remove("debugIM");
            mEditor.remove("debugRest");
        }else{
            mEditor.putString("debugIM", imAddress);
            mEditor.putString("debugRest", restAddress);
        }

        mEditor.commit();
    }

    public String getDebugIMAddress(){
        return mSharedPreferences.getString("debugIM", null);
    }

    public String getDebugRestAddress(){
        return mSharedPreferences.getString("debugRest", null);
    }

    public void setDebugAppkey(String appkey){
        mEditor.putString("debugAppkey", appkey);
        mEditor.commit();
    }

    public String getDebugAppkey(){
        return mSharedPreferences.getString("debugAppkey", null);
    }

    public void setDebugMode(boolean debugMode){
        mEditor.putString("debugMode", String.valueOf(debugMode));
        mEditor.commit();
    }

    public String getDebugMode(){
        return mSharedPreferences.getString("debugMode", null);
    }

    public void setPushToken(String regId) {
        mEditor.putString(SHARED_KEY_GCM_ID, regId);
        mEditor.commit();
    }
    
    public String getPushToken() {
        return mSharedPreferences.getString(SHARED_KEY_GCM_ID, null);
    }

    public String getFCMPushToken() {
        return mSharedPreferences.getString(SHARED_KEY_FCM_ID, null);
    }

    public void setFCMPushToken(String regId) {
        mEditor.putString(SHARED_KEY_FCM_ID, regId);
        mEditor.commit();
    }

    public void setPushFlag(String flag){
        mEditor.putString(PUSH_FLAG, flag);
        mEditor.commit();
    }

    public String getPushFlag(){
        return mSharedPreferences.getString(PUSH_FLAG, null);
    }

    public void setHWAppId(String appId){
        mEditor.putString(HW_APP_ID, appId);
        mEditor.commit();
    }

    public String getHWAppId(){
        return mSharedPreferences.getString(HW_APP_ID, null);
    }

    public void setHMSToken(String token){
        mEditor.putString(HMS_TOKEN, token);
        mEditor.commit();
    }

    public String getHMSToken(){
        return mSharedPreferences.getString(HMS_TOKEN, null);
    }

    /**
     * define hyphenate token
     * @author
     *
     */
    public static class Token {
        String token;
        long savedTime;

        public Token(){}

        public Token(String token, long savedTime){
            this.token = token;
            this.savedTime = savedTime;
        }

        public String getToken() {
            if(savedTime <= 0){
                token = null;
            }
            return token;
        }
        public Token setToken(String token) {
            this.token = token;
            return this;
        }

        public long getSavedTime() {
            return savedTime;
        }
        public Token setSavedTime(long savedTime) {
            this.savedTime = savedTime;
            return this;
        }
    }
}

