/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.core;

import android.content.ContentValues;
import android.content.Context;
import android.content.ContextWrapper;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Environment;

import com.hyphenate.chat.EMClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EasyUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class EMMonitorDB {
    
    private static final String TAG = "EMMonitorDB";
    private static final int version = 1;
    private static final String name = "monitor.db";

    private EMMonitorDBHelper dbHelper = null;
    
    private static final String APPS_TABLE_NAME = "apps";
    private static final String COLUMN_APPS_NAME = "appname";

    private static final String CREATE_APPS_TABLE = "create table " + APPS_TABLE_NAME + " ("
            + COLUMN_APPS_NAME + " text primary key);";

    public EMMonitorDB(){
        try {
            String dirPath = Environment.getExternalStorageDirectory() + "/emlibs/libs";
            dbHelper = new EMMonitorDBHelper(EMClient.getInstance().getContext(), name, version, dirPath);
        } catch (Exception e) {
            EMLog.d(TAG, e.getMessage());
        }
    }
    
    
    public void addApp(String appname){
    	try{
    		if(dbHelper != null){
                SQLiteDatabase db = dbHelper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put(COLUMN_APPS_NAME, appname);
                db.replace(APPS_TABLE_NAME, null, values);
            }
    	} catch (Exception e){
    		EMLog.e(TAG, e.toString());
    	}
    }
    
    public void removeApp(String appname){
    	try{
    		if(dbHelper != null){
                SQLiteDatabase db = dbHelper.getWritableDatabase();
                db.delete(APPS_TABLE_NAME, COLUMN_APPS_NAME + " = ?", new String[]{appname});
            }
    	}catch(Exception e){
    		EMLog.e(TAG, e.toString());
    	}
    }
    
    public List<String> getAppList(){
        List<String> appList = new ArrayList<String>();
        
        try{
        	if(dbHelper != null){
                SQLiteDatabase db = dbHelper.getReadableDatabase();
                Cursor cursor = db.rawQuery("select * from " + APPS_TABLE_NAME, null);
                if(cursor != null){
                    while(cursor.moveToNext()){
                        String app = cursor.getString(cursor.getColumnIndex(COLUMN_APPS_NAME));
                        appList.add(app);
                    }
                    
                    cursor.close();
                }
            }
        }catch(Exception e){
        	EMLog.e(TAG, e.toString());
        }
        
        return appList;
    }
    

    private static class EMMonitorDBHelper extends SQLiteOpenHelper {
        
        public EMMonitorDBHelper(Context context, String name, int version, String dirPath) throws HyphenateException {
            super(getCustomContext(context, dirPath), name, null, version);
        }
        
        
        @Override
        public void onCreate(SQLiteDatabase db) {
            db.execSQL(CREATE_APPS_TABLE);
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

        }

        private static CustomContext getCustomContext(Context context,String dirPath) throws HyphenateException{
            if(!EasyUtils.isSDCardExist()){
                throw new HyphenateException("sd card not exist");
            }
            return new CustomContext(context, dirPath);
        }
    }

    /**
     * 自定义context，用于把db存在sd卡
     *
     */
    private static class CustomContext extends ContextWrapper {

        private String dirPath;

        public CustomContext(Context base, String dirPath) {
            super(base);
            this.dirPath = dirPath;
        }

        @Override
        public File getDatabasePath(String name) {
            File result = new File(dirPath + File.separator + name);

            if (!result.getParentFile().exists()) {
                result.getParentFile().mkdirs();
            }

            return result;
        }

        @Override
        public SQLiteDatabase openOrCreateDatabase(String name, int mode, CursorFactory factory) {
            return SQLiteDatabase.openOrCreateDatabase(getDatabasePath(name), factory);
        }

        @Override
        public SQLiteDatabase openOrCreateDatabase(String name, int mode, CursorFactory factory,
                DatabaseErrorHandler errorHandler) {
            return SQLiteDatabase.openOrCreateDatabase(getDatabasePath(name).getAbsolutePath(), factory, errorHandler);
        }
    }
}
