/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import java.util.List;

import com.hyphenate.chat.adapter.message.EMAMessage;

public abstract class EMAChatManagerListener extends EMABase implements EMAChatManagerListenerInterface  {
	
	public EMAChatManagerListener() {
		nativeInit();
	}
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	/**
	 * create native listener class which implements EMAChatManagerListener interface.
	 */
	native void nativeInit();
	native void nativeFinalize();
	
	
	@Override
    public void onReceiveMessages( List<EMAMessage> messages) {}
	
	@Override
    public void onReceiveCmdMessages( List<EMAMessage> cmdMessage) {}
	
	@Override
    public void onMessageStatusChanged( EMAMessage message,  EMAError error) {}
	
	@Override
	public void onMessageAttachmentsStatusChanged( EMAMessage message,  EMAError error) {}
	
	@Override
 	public void onReceiveRecallMessages(List<EMAMessage> message) {}
	
	@Override
    public void onReceiveHasReadAcks(List<EMAMessage> message) {}
	
	@Override
    public void onReceiveHasDeliveredAcks(List<EMAMessage> message) {}
	
	@Override
    public void onUpdateConversationList( List<EMAConversation> conversations) {}
	
}
