/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.voice;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import com.superrtc.call.Logging;
import com.superrtc.sdk.RtcListener;
import com.superrtc.voice.WebRtcAudioEffects;
import com.superrtc.voice.WebRtcAudioUtils;

public class WebRtcAudioManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioManager";
    private static boolean blacklistDeviceForOpenSLESUsage = false;
    private static boolean blacklistDeviceForOpenSLESUsageIsOverridden = false;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int DEFAULT_FRAME_PER_BUFFER = 256;
    private static int audiosamplerate = 16000;
    private static int callAudioSource = 7;
    private static RtcListener rtcListener;
    private static final int CHANNELS = 1;
    private static final String[] AUDIO_MODES;
    private final long nativeAudioManager;
    private final Context context;
    private final AudioManager audioManager;
    private boolean initialized = false;
    private int nativeSampleRate;
    private int nativeChannels;
    private boolean hardwareAEC;
    private boolean hardwareAGC;
    private boolean hardwareNS;
    private boolean lowLatencyOutput;
    private int sampleRate;
    private int channels;
    private int outputBufferSize;
    private int inputBufferSize;

    public static synchronized void setBlacklistDeviceForOpenSLESUsage(boolean bl) {
        blacklistDeviceForOpenSLESUsageIsOverridden = true;
        blacklistDeviceForOpenSLESUsage = bl;
    }

    public static void setAudioSampleRate(int n) {
        if (n == 8000 || n == 11025 || n == 22050 || n == 16000 || n == 32000 || n == 44100 || n == 48000) {
            audiosamplerate = n;
        }
    }

    public static void setCallAudioSource(int n) {
        callAudioSource = n;
    }

    public static int getCallAudioSource() {
        return callAudioSource;
    }

    public static void setRtcListener(RtcListener rtcListener) {
        WebRtcAudioManager.rtcListener = rtcListener;
    }

    public static void openMicFail() {
        if (rtcListener != null) {
            rtcListener.onError(RtcListener.RTCError.OPEN_MIC_FAIL);
        }
    }

    WebRtcAudioManager(Context context, long l) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.context = context;
        this.nativeAudioManager = l;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.storeAudioParameters();
        this.nativeCacheAudioParameters(this.sampleRate, this.channels, this.hardwareAEC, this.hardwareAGC, this.hardwareNS, this.lowLatencyOutput, this.outputBufferSize, this.inputBufferSize, l);
    }

    private boolean init() {
        Logging.d(TAG, "init" + WebRtcAudioUtils.getThreadInfo());
        if (this.initialized) {
            return true;
        }
        this.initialized = true;
        return true;
    }

    private void dispose() {
        Logging.d(TAG, "dispose" + WebRtcAudioUtils.getThreadInfo());
        if (!this.initialized) {
            return;
        }
    }

    private boolean isCommunicationModeEnabled() {
        return true;
    }

    private boolean isDeviceBlacklistedForOpenSLESUsage() {
        boolean bl;
        boolean bl2 = bl = blacklistDeviceForOpenSLESUsageIsOverridden ? blacklistDeviceForOpenSLESUsage : WebRtcAudioUtils.deviceIsBlacklistedForOpenSLESUsage();
        if (bl) {
            Logging.e(TAG, Build.MODEL + " is blacklisted for OpenSL ES usage!");
        }
        return bl;
    }

    private void storeAudioParameters() {
        this.channels = 1;
        this.sampleRate = this.getNativeOutputSampleRate();
        this.hardwareAEC = WebRtcAudioManager.isAcousticEchoCancelerSupported();
        this.hardwareAGC = WebRtcAudioManager.isAutomaticGainControlSupported();
        this.hardwareNS = WebRtcAudioManager.isNoiseSuppressorSupported();
        Logging.d(TAG, "HW_Audio_Process hardwareAEC: " + this.hardwareAEC + ", hardwareAGC: " + this.hardwareAGC + " hardwareNS: " + this.hardwareNS + " ,sampleRate:" + this.sampleRate);
        this.hardwareAEC = false;
        this.hardwareAGC = false;
        this.hardwareNS = false;
        this.lowLatencyOutput = this.isLowLatencyOutputSupported();
        this.outputBufferSize = this.lowLatencyOutput ? this.getLowLatencyOutputFramesPerBuffer() : WebRtcAudioManager.getMinOutputFrameSize(this.sampleRate, this.channels);
        this.inputBufferSize = WebRtcAudioManager.getMinInputFrameSize(this.sampleRate, this.channels);
    }

    private boolean hasEarpiece() {
        return this.context.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private boolean isLowLatencyOutputSupported() {
        return WebRtcAudioManager.isOpenSLESSupported() && this.context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    public boolean isLowLatencyInputSupported() {
        return WebRtcAudioUtils.runningOnLollipopOrHigher() && this.isLowLatencyOutputSupported();
    }

    private int getNativeOutputSampleRate() {
        if (WebRtcAudioUtils.runningOnEmulator()) {
            Logging.d(TAG, "Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        if (WebRtcAudioUtils.isDefaultSampleRateOverridden()) {
            Logging.d(TAG, "Default sample rate is overriden to " + WebRtcAudioUtils.getDefaultSampleRateHz() + " Hz");
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        int n = WebRtcAudioUtils.runningOnJellyBeanMR1OrHigher() ? this.getSampleRateOnJellyBeanMR10OrHigher() : WebRtcAudioUtils.getDefaultSampleRateHz();
        if (audiosamplerate != 0) {
            n = audiosamplerate;
        }
        Logging.d(TAG, "Sample rate is set to " + n + " Hz");
        return n;
    }

    @TargetApi(value=17)
    private int getSampleRateOnJellyBeanMR10OrHigher() {
        String string = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return string == null ? WebRtcAudioUtils.getDefaultSampleRateHz() : Integer.parseInt(string);
    }

    @TargetApi(value=17)
    private int getLowLatencyOutputFramesPerBuffer() {
        WebRtcAudioManager.assertTrue(this.isLowLatencyOutputSupported());
        if (!WebRtcAudioUtils.runningOnJellyBeanMR1OrHigher()) {
            return 256;
        }
        String string = this.audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return string == null ? 256 : Integer.parseInt(string);
    }

    private static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.canUseAcousticEchoCanceler();
    }

    private static boolean isAutomaticGainControlSupported() {
        return WebRtcAudioEffects.canUseAutomaticGainControl();
    }

    private static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.canUseNoiseSuppressor();
    }

    private static int getMinOutputFrameSize(int n, int n2) {
        int n3;
        int n4 = n2 * 2;
        if (n2 == 1) {
            n3 = 4;
        } else if (n2 == 2) {
            n3 = 12;
        } else {
            return -1;
        }
        return AudioTrack.getMinBufferSize((int)n, (int)n3, (int)2) / n4;
    }

    private int getLowLatencyInputFramesPerBuffer() {
        WebRtcAudioManager.assertTrue(this.isLowLatencyInputSupported());
        return this.getLowLatencyOutputFramesPerBuffer();
    }

    private static int getMinInputFrameSize(int n, int n2) {
        int n3 = n2 * 2;
        WebRtcAudioManager.assertTrue(n2 == 1);
        return AudioRecord.getMinBufferSize((int)n, (int)16, (int)2) / n3;
    }

    private static boolean isOpenSLESSupported() {
        return WebRtcAudioUtils.runningOnGingerBreadOrHigher();
    }

    private static void assertTrue(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private native void nativeCacheAudioParameters(int var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6, int var7, int var8, long var9);

    static {
        AUDIO_MODES = new String[]{"MODE_NORMAL", "MODE_RINGTONE", "MODE_IN_CALL", "MODE_IN_COMMUNICATION"};
    }
}

