/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.util;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.util.Log;
import com.superrtc.util.AppRTCUtils;

public class AppRTCProximitySensor
implements SensorEventListener {
    private static final String TAG = "AppRTCProximitySensor";
    private final AppRTCUtils.NonThreadSafe nonThreadSafe = new AppRTCUtils.NonThreadSafe();
    private final Runnable onSensorStateListener;
    private final SensorManager sensorManager;
    private Sensor proximitySensor = null;
    private boolean lastStateReportIsNear = false;

    static AppRTCProximitySensor create(Context context, Runnable runnable) {
        return new AppRTCProximitySensor(context, runnable);
    }

    private AppRTCProximitySensor(Context context, Runnable runnable) {
        Log.d((String)TAG, (String)(TAG + AppRTCUtils.getThreadInfo()));
        this.onSensorStateListener = runnable;
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
    }

    public boolean start() {
        this.checkIfCalledOnValidThread();
        Log.d((String)TAG, (String)("start" + AppRTCUtils.getThreadInfo()));
        if (!this.initDefaultSensor()) {
            return false;
        }
        this.sensorManager.registerListener((SensorEventListener)this, this.proximitySensor, 3);
        return true;
    }

    public void stop() {
        this.checkIfCalledOnValidThread();
        Log.d((String)TAG, (String)("stop" + AppRTCUtils.getThreadInfo()));
        if (this.proximitySensor == null) {
            return;
        }
        this.sensorManager.unregisterListener((SensorEventListener)this, this.proximitySensor);
    }

    public boolean sensorReportsNearState() {
        this.checkIfCalledOnValidThread();
        return this.lastStateReportIsNear;
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
        this.checkIfCalledOnValidThread();
        AppRTCUtils.assertIsTrue(sensor.getType() == 8);
        if (n == 0) {
            Log.e((String)TAG, (String)"The values returned by this sensor cannot be trusted");
        }
    }

    public final void onSensorChanged(SensorEvent sensorEvent) {
        this.checkIfCalledOnValidThread();
        AppRTCUtils.assertIsTrue(sensorEvent.sensor.getType() == 8);
        float f2 = sensorEvent.values[0];
        if (f2 < this.proximitySensor.getMaximumRange()) {
            Log.d((String)TAG, (String)"Proximity sensor => NEAR state");
            this.lastStateReportIsNear = true;
        } else {
            Log.d((String)TAG, (String)"Proximity sensor => FAR state");
            this.lastStateReportIsNear = false;
        }
        if (this.onSensorStateListener != null) {
            this.onSensorStateListener.run();
        }
        Log.d((String)TAG, (String)("onSensorChanged" + AppRTCUtils.getThreadInfo() + ": accuracy=" + sensorEvent.accuracy + ", timestamp=" + sensorEvent.timestamp + ", distance=" + sensorEvent.values[0]));
    }

    private boolean initDefaultSensor() {
        if (this.proximitySensor != null) {
            return true;
        }
        this.proximitySensor = this.sensorManager.getDefaultSensor(8);
        if (this.proximitySensor == null) {
            return false;
        }
        this.logProximitySensorInfo();
        return true;
    }

    private void logProximitySensorInfo() {
        if (this.proximitySensor == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("Proximity sensor: ");
        stringBuilder.append("name=" + this.proximitySensor.getName());
        stringBuilder.append(", vendor: " + this.proximitySensor.getVendor());
        stringBuilder.append(", power: " + this.proximitySensor.getPower());
        stringBuilder.append(", resolution: " + this.proximitySensor.getResolution());
        stringBuilder.append(", max range: " + this.proximitySensor.getMaximumRange());
        if (Build.VERSION.SDK_INT >= 9) {
            stringBuilder.append(", min delay: " + this.proximitySensor.getMinDelay());
        }
        if (Build.VERSION.SDK_INT >= 20) {
            stringBuilder.append(", type: " + this.proximitySensor.getStringType());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            stringBuilder.append(", max delay: " + this.proximitySensor.getMaxDelay());
            stringBuilder.append(", reporting mode: " + this.proximitySensor.getReportingMode());
            stringBuilder.append(", isWakeUpSensor: " + this.proximitySensor.isWakeUpSensor());
        }
        Log.d((String)TAG, (String)stringBuilder.toString());
    }

    private void checkIfCalledOnValidThread() {
        if (!this.nonThreadSafe.calledOnValidThread()) {
            throw new IllegalStateException("Method is not called on valid thread");
        }
    }
}

