/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;

public class RTCNetworkReceiver
extends BroadcastReceiver {
    private NetworkListener networkListener;

    public void onReceive(Context context, Intent intent) {
        if (this.networkListener != null) {
            this.networkListener.onNetworkChanged(RTCNetworkReceiver.getNetworkType(context).ordinal());
        }
    }

    public static NetState getNetworkType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable()) {
            int n = networkInfo.getType();
            if (Build.VERSION.SDK_INT >= 13 && n == 9) {
                return NetState.WWAN;
            }
            if (n == 1) {
                return NetState.WIFI;
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            switch (telephonyManager.getNetworkType()) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return NetState.WWAN;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return NetState.WWAN;
                }
                case 13: {
                    return NetState.WWAN;
                }
            }
            return NetState.WWAN;
        }
        return NetState.NO_NETWORK;
    }

    public void setNetworkListener(NetworkListener networkListener) {
        this.networkListener = networkListener;
    }

    public static enum NetState {
        NO_NETWORK,
        WIFI,
        WWAN,
        OTHER;

    }

    public static interface NetworkListener {
        public void onNetworkChanged(int var1);
    }
}

