/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import com.superrtc.sdk.RtcConnection;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.logging.Level;

public class Logging {
    private static RtcConnection.LogListener fallbackLogger = RtcConnection.sLogListener;
    private static volatile boolean tracingEnabled;
    private static volatile boolean nativeLibLoaded;
    private static int loglevel;

    public static void enableLogThreads() {
        if (!nativeLibLoaded) {
            fallbackLogger.onLog(loglevel, "Cannot enable log thread because native lib not loaded.");
            return;
        }
        Logging.nativeEnableLogThreads();
    }

    public static void enableLogTimeStamps() {
        if (!nativeLibLoaded) {
            fallbackLogger.onLog(loglevel, "Cannot enable log timestamps because native lib not loaded.");
            return;
        }
        Logging.nativeEnableLogTimeStamps();
    }

    public static synchronized void enableTracing(String string, EnumSet<TraceLevel> enumSet, Severity severity) {
        if (!nativeLibLoaded) {
            fallbackLogger.onLog(loglevel, "Cannot enable tracing because native lib not loaded.");
            return;
        }
        if (tracingEnabled) {
            return;
        }
        int n = 0;
        for (TraceLevel traceLevel : enumSet) {
            n |= traceLevel.level;
        }
        Logging.nativeEnableTracing(string, n, severity.ordinal());
        tracingEnabled = true;
    }

    public static void log(Severity severity, String string, String string2) {
        if (tracingEnabled) {
            Logging.nativeLog(severity.ordinal(), string, string2);
            return;
        }
        switch (severity) {
            case LS_ERROR: {
                Level level = Level.SEVERE;
                break;
            }
            case LS_WARNING: {
                Level level = Level.WARNING;
                break;
            }
            case LS_INFO: {
                Level level = Level.INFO;
                break;
            }
            default: {
                Level level = Level.FINE;
            }
        }
        fallbackLogger.onLog(loglevel, string + ": " + string2);
    }

    public static void d(String string, String string2) {
        Logging.log(Severity.LS_INFO, string, string2);
    }

    public static void e(String string, String string2) {
        Logging.log(Severity.LS_ERROR, string, string2);
    }

    public static void w(String string, String string2) {
        Logging.log(Severity.LS_WARNING, string, string2);
    }

    public static void e(String string, String string2, Throwable throwable) {
        Logging.log(Severity.LS_ERROR, string, string2);
        Logging.log(Severity.LS_ERROR, string, throwable.toString());
        Logging.log(Severity.LS_ERROR, string, Logging.getStackTraceString(throwable));
    }

    public static void w(String string, String string2, Throwable throwable) {
        Logging.log(Severity.LS_WARNING, string, string2);
        Logging.log(Severity.LS_WARNING, string, throwable.toString());
        Logging.log(Severity.LS_WARNING, string, Logging.getStackTraceString(throwable));
    }

    public static void v(String string, String string2) {
        Logging.log(Severity.LS_VERBOSE, string, string2);
    }

    private static String getStackTraceString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private static native void nativeEnableTracing(String var0, int var1, int var2);

    private static native void nativeEnableLogThreads();

    private static native void nativeEnableLogTimeStamps();

    private static native void nativeLog(int var0, String var1, String var2);

    static {
        loglevel = RtcConnection.loglevel;
        try {
            System.loadLibrary("hyphenate_av");
            nativeLibLoaded = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            fallbackLogger.onLog(loglevel, "Failed to load hyphenate_av: ");
        }
    }

    public static enum Severity {
        LS_SENSITIVE,
        LS_VERBOSE,
        LS_INFO,
        LS_WARNING,
        LS_ERROR;

    }

    public static enum TraceLevel {
        TRACE_NONE(0),
        TRACE_STATEINFO(1),
        TRACE_WARNING(2),
        TRACE_ERROR(4),
        TRACE_CRITICAL(8),
        TRACE_APICALL(16),
        TRACE_DEFAULT(255),
        TRACE_MODULECALL(32),
        TRACE_MEMORY(256),
        TRACE_TIMER(512),
        TRACE_STREAM(1024),
        TRACE_DEBUG(2048),
        TRACE_INFO(4096),
        TRACE_TERSEINFO(8192),
        TRACE_ALL(65535);

        public final int level;

        private TraceLevel(int n2) {
            this.level = n2;
        }
    }
}

