package com.hyphenate.chat;


import android.view.View;

/**
 * Created by lzan13 on 2017/8/16.
 * \~chinese
 * 本地推流配置信息类
 *
 * \~english
 * Local publish stream config
 */
public class EMStreamParam {

    /**
     * \~chinese
     * 推流配置名称
     *
     * \~english
     * local publish stream name
     */
    protected String name;

    /**
     * \~chinese
     * 是否关闭视频
     *
     * \~english
     * Whether to turn off the video
     */
    protected boolean videoOff;

    /**
     * \~chinese
     * 是否静音
     *
     * \~english
     * Whether mute
     */
    protected boolean audioOff;

    /**
     * \~chinese
     * 使用后置摄像头 默认为 false
     *
     * \~english
     * Use back camera, default false
     */
    protected boolean useBackCamera;

    /**
     * \~chinese
     * 视频宽度
     *
     * \~english
     * Video width
     */
    protected int videoWidth;

    /**
     * \~chinese
     * 视频高度
     *
     * \~english
     * Video height
     */
    protected int videoHeight;

    /**
     * \~chinese
     * 扩展字段
     *
     * \~english
     * extension
     */
    protected String extension;

    /**
     * \~chinese
     * 分享的 view
     *
     * \~english
     * Share view
     */
    protected View shareView;

    /**
     * |~chinese
     * 推送 stream 类型
     *
     * \~english
     * Publish stream type
     */
    protected EMConferenceStream.StreamType streamType;

    public EMStreamParam() {
        name = "AndroidNormal";
        videoOff = false;
        audioOff = false;
        useBackCamera = false;
        videoWidth = 240;
        videoHeight = 320;
        extension = "";
        shareView = null;
        streamType = EMConferenceStream.StreamType.NORMAL;
    }

    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }


    public boolean isVideoOff() {
        return videoOff;
    }

    public void setVideoOff(boolean videoOff) {
        this.videoOff = videoOff;
    }

    public boolean isAudioOff() {
        return audioOff;
    }

    public void setAudioOff(boolean audioOff) {
        this.audioOff = audioOff;
    }

    public void setUseBackCamera(boolean useBackCamera) {
        this.useBackCamera = useBackCamera;
    }

    public boolean isUseBackCamera() {
        return useBackCamera;
    }

    public int getVideoWidth() {
        return videoWidth;
    }

    public void setVideoWidth(int videoWidth) {
        this.videoWidth = videoWidth;
    }

    public int getVideoHeight() {
        return videoHeight;
    }

    public void setVideoHeight(int videoHeight) {
        this.videoHeight = videoHeight;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public View getShareView() {
        return shareView;
    }

    public void setShareView(View shareView) {
        this.shareView = shareView;
    }

    public EMConferenceStream.StreamType getStreamType() {
        return streamType;
    }

    public void setStreamType(EMConferenceStream.StreamType streamType) {
        this.streamType = streamType;
    }
}

