/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import java.io.Serializable;

/**
 * \~chinese
 * 群组的基本信息, 用于获取公开群的列表
 * @see EMGroupManager#getPublicGroupsFromServer(int, String)
 *
 * \~english
 * get the basic group info. used when get public group list
 * @see EMGroupManager#getPublicGroupsFromServer(int, String)
 * 
 */
public class EMGroupInfo implements Serializable{

	private static final long serialVersionUID = -2004486389398310700L;
	private String groupId;
	private String groupName;
	
	/**
	 * \~chinese
	 * 构造函数
	 * @param groupId
	 * @param groupName
	 *
	 * \~english
	 * construction of EMGroupInfo
	 * @param groupId
	 * @param groupName
	 */
	public EMGroupInfo(String groupId, String groupName) {
		this.groupId = groupId;
		this.groupName = groupName;
	}

	/**
	 * \~chinese
	 * 获取群组id
	 * @return group id
	 *
	 * \~english
	 * get group id
	 * @return group id
	 */
	public String getGroupId() {
		return groupId;
	}

	/**
	 * \~chinese
	 * 设置群组id
	 *
	 * \~english
	 * set group id
	 */
	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	/**
	 * \~chinese
	 * 获取群组名称
	 * @return 群组名称 
	 *
	 * \~english
	 * get group name
	 * @return group name
	 */
	public String getGroupName() {
		return groupName;
	}

	/**
	 * \~chinese
	 * 设置群组名称
	 * @param groupName 群组名称
	 *
	 * \~english
	 * set group name
	 * @param groupName group name
	 */
	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}
	
	@Override
	public String toString() {
		return groupName;
	}
}
