/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.opengl.GLES20;
import com.superrtc.call.GlUtil;

public class GlTextureFrameBuffer {
    private final int frameBufferId;
    private final int textureId;
    private final int pixelFormat;
    private int width;
    private int height;

    public GlTextureFrameBuffer(int n) {
        switch (n) {
            case 6407: 
            case 6408: 
            case 6409: {
                this.pixelFormat = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid pixel format: " + n);
            }
        }
        this.textureId = GlUtil.generateTexture(3553);
        this.width = 0;
        this.height = 0;
        int[] nArray = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])nArray, (int)0);
        this.frameBufferId = nArray[0];
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBufferId);
        GlUtil.checkNoGLES2Error("Generate framebuffer");
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.textureId, (int)0);
        GlUtil.checkNoGLES2Error("Attach texture to framebuffer");
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public void setSize(int n, int n2) {
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException("Invalid size: " + n + "x" + n2);
        }
        if (n == this.width && n2 == this.height) {
            return;
        }
        this.width = n;
        this.height = n2;
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBufferId);
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.textureId);
        GLES20.glTexImage2D((int)3553, (int)0, (int)this.pixelFormat, (int)n, (int)n2, (int)0, (int)this.pixelFormat, (int)5121, null);
        int n3 = GLES20.glCheckFramebufferStatus((int)36160);
        if (n3 != 36053) {
            throw new IllegalStateException("Framebuffer not complete, status: " + n3);
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameBufferId() {
        return this.frameBufferId;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public void release() {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.textureId}, (int)0);
        GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{this.frameBufferId}, (int)0);
        this.width = 0;
        this.height = 0;
    }
}

