package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMACallRtcListenerDelegate;
import com.superrtc.sdk.RtcConnection;
import com.superrtc.sdk.RtcConnection.RtcStatistics;

/**
 * Created by linan on 17/6/29.
 */

public class EMVideoCallHelper {
    EMVideoCallHelper() {}

    public enum CallType {
        /**
         * \~chinese
         * 音频通话
         *
         * \~english
         * audio call
         */
        audio,
        /**
         * \~chinese
         * 视频通话
         *
         * \~english
         * voice call
         */
        video;
    }

    /**
     * Capture video image to local storage
     *
     * @param filename
     * @return true for success
     */
    public boolean takePicture(String filename) {
        return EMClient.getInstance().callManager().emaObject.capturePicture(filename);
    }

    /**
     * \~chinese
     * 开始视频录制
     * @param dirPath 录制的文件存储目录，用户可以自己实时检测该文件大小，如果占用太多空间提醒用户
     *
     * \~english
     * start video recording
     *
     * @param dirPath       save file to this directory
     */
    public void startVideoRecord(String dirPath) {
        EMClient.getInstance().callManager().emaObject.startRecordVideo(dirPath);
    }

    /**
     * \~chinese
     * 停止视频录制
     * @return 返回录制的视频文件的路径，录制失败则返回null
     *
     * \~english
     * stop video recording
     *
     * @return return video recording file path. Return null if failed
     */
    public String stopVideoRecord() {
        return EMClient.getInstance().callManager().emaObject.stopRecordVideo();
    }

    /**
     * \~chinese
     * 如果需要录像，需要调用次函数，参数为true。
     * 此方法调用需要在视频通话开始之前调用，比如放在Activity的onCreate中。
     * 如果没有设置enabled为true, 录像文件无法播放。
     *
     * \~english
     * Call this method and set 'enabled' to true to record video
     * Call this method before the video streaming start. ex. put it in Activity in onCreate
     * This method will choose H264 encoding codec, otherwise recorded file cannot be replayed.
     */
    public void setPreferMovFormatEnable(boolean enabled) {
        if (enabled) {
            RtcConnection.setGlobalVideoCodec(RtcConnection.RtcConstStringH264);
        }
        else {
            RtcConnection.setGlobalVideoCodec(null);
        }
    }

    /**
     * \~chinese
     * 时延，单位是ms
     * @return
     *
     * \~english
     * return video latency in milliseconds
     */
    @Deprecated
    public int getVideoLatency(){
        RtcConnection.Listener listener = EMClient.getInstance().callManager().mRtcListener;
        if (listener != null && listener instanceof EMACallRtcListenerDelegate) {
            EMACallRtcListenerDelegate lis = (EMACallRtcListenerDelegate)listener;
            RtcStatistics statistics = lis.getStatistics();
            if (statistics != null) {
                return statistics.localVideoRtt;
            }
        }
        return 0;
    }

    /**
     * \~chinese
     * 帧率
     * @return
     *
     * \~english
     * get video frame rate
     */
    @Deprecated
    public int getVideoFrameRate() {
        RtcConnection.Listener listener = EMClient.getInstance().callManager().mRtcListener;
        if (listener != null && listener instanceof EMACallRtcListenerDelegate) {
            EMACallRtcListenerDelegate lis = (EMACallRtcListenerDelegate)listener;
            RtcStatistics statistics = lis.getStatistics();
            if (statistics != null) {
                return statistics.remoteFps;
            }
        }
        return 0;
    }

    /**
     * \~chinese
     * 每一百个包中丢包个数
     * @return
     *
     * \~english
     * Package lost rate per 100 packages
     */
    @Deprecated
    public int getVideoLostRate(){
        RtcConnection.Listener listener = EMClient.getInstance().callManager().mRtcListener;
        if (listener != null && listener instanceof EMACallRtcListenerDelegate) {
            EMACallRtcListenerDelegate lis = (EMACallRtcListenerDelegate)listener;
            RtcStatistics statistics = lis.getStatistics();
            if (statistics != null) {
                return statistics.remoteVideoPacketsLostrate;
            }
        }
        return 0;
    }

    /**
     * \~chinese
     * 对方图像宽度
     *
     * @return 获取失败，返回0
     *
     * \~english
     * Video width of user from other side
     *
     * @return if failed, will return 0
     */
    public int getVideoWidth() {
        RtcConnection.Listener listener = EMClient.getInstance().callManager().mRtcListener;
        if (listener != null && listener instanceof EMACallRtcListenerDelegate) {
            EMACallRtcListenerDelegate lis = (EMACallRtcListenerDelegate)listener;
            RtcStatistics statistics = lis.getStatistics();
            if (statistics != null) {
                return statistics.remoteWidth;
            }
        }
        return 0;
    }

    /**
     * \~chinese
     * 对方图像高度
     *
     * @return 获取失败，返回0
     *
     * \~english
     * Video height of user from other side
     *
     * @return if failed, will return 0
     */
    public int getVideoHeight(){
        RtcConnection.Listener listener = EMClient.getInstance().callManager().mRtcListener;
        if (listener != null && listener instanceof EMACallRtcListenerDelegate) {
            EMACallRtcListenerDelegate lis = (EMACallRtcListenerDelegate)listener;
            RtcStatistics statistics = lis.getStatistics();
            if (statistics != null) {
                return statistics.remoteHeight;
            }
        }
        return 0;
    }

    /**
     * \~chinese
     * 接收视频比特率，单位为kbps
     *
     * @return 获取失败，返回0
     *
     * \~english
     * video receiving bitrate in kbps
     *
     * @return if failed, will return 0
     */
    @Deprecated
    public int getRemoteBitrate() {
        RtcConnection.Listener listener = EMClient.getInstance().callManager().mRtcListener;
        if (listener != null && listener instanceof EMACallRtcListenerDelegate) {
            EMACallRtcListenerDelegate lis = (EMACallRtcListenerDelegate)listener;
            RtcStatistics statistics = lis.getStatistics();
            if (statistics != null) {
                return statistics.remoteVideoBps;
            }
        }
        return 0;
    }

    /**
     * \~chinese
     * 发送视频比特率，单位为kbps
     *
     * @return 获取失败，返回0
     *
     * \~english
     * video sending bitrate in kbps
     *
     * @return if failed, will return 0
     */
    @Deprecated
    public int getLocalBitrate(){
        RtcConnection.Listener listener = EMClient.getInstance().callManager().mRtcListener;
        if (listener != null && listener instanceof EMACallRtcListenerDelegate) {
            EMACallRtcListenerDelegate lis = (EMACallRtcListenerDelegate)listener;
            RtcStatistics statistics = lis.getStatistics();
            if (statistics != null) {
                return statistics.localVideoActualBps;
            }
        }
        return 0;
    }

    /**
     * \~chinese
     * 发送音频比特率，单位为 kbps
     *
     * @return 获取失败，返回0
     *
     * \~english
     * audio sending bitrate in kbps
     *
     * @return if failed, will return 0
     */
    @Deprecated
    public int getLocalAudioBitrate(){
        RtcConnection.Listener listener = EMClient.getInstance().callManager().mRtcListener;
        if (listener != null && listener instanceof EMACallRtcListenerDelegate) {
            EMACallRtcListenerDelegate lis = (EMACallRtcListenerDelegate)listener;
            RtcStatistics statistics = lis.getStatistics();
            if (statistics != null) {
                return statistics.localAudioBps;
            }
        }
        return 0;
    }

    /**
     * \~chinese
     * 接受音频比特率，单位为 kbps
     *
     * @return 获取失败，返回0
     *
     * \~english
     *  audio receiving bitrate in kbps
     *
     * @return if failed, will return 0
     */
    @Deprecated
    public int getRemoteAudioBitrate(){
        RtcConnection.Listener listener = EMClient.getInstance().callManager().mRtcListener;
        if (listener != null && listener instanceof EMACallRtcListenerDelegate) {
            EMACallRtcListenerDelegate lis = (EMACallRtcListenerDelegate)listener;
            RtcStatistics statistics = lis.getStatistics();
            if (statistics != null) {
                return statistics.remoteAudioBps;
            }
        }
        return 0;
    }
}
