package com.hyphenate;

/**
 * Created by linan on 17/4/17.
 */

import java.util.List;

/**
 * Multi-device listener, listener current user action callback on other devices.
 */
@SuppressWarnings("unused")
public interface EMMultiDeviceListener {

//    /**
//     * \~chinese
//     * 在其他设备上发起好友请求
//     *
//     * ~\english
//     * current user invited contact to be friend on other device
//     */
//    int CONTACT_ADD = 1;

    /**
     * \~chinese
     * 好友已经在其他机子上被移除
     *
     * \~english
     *current user removed contact on other device
     */
    int CONTACT_REMOVE = 2;

    /**
     * \~chinese
     * 好友请求已经在其他机子上被同意
     *
     * \~english
     * current user accepted contact invitation on other device
     */
    int CONTACT_ACCEPT          = 3;

    /**
     * \~chinese
     * 好友请求已经在其他机子上被拒绝
     *
     * \~english
     * current user refused contact invitation on other device
     */
    int CONTACT_DECLINE         = 4;

    /**
     * \~chinese
     * 当前用户在其他设备加某人进入黑名单
     *
     * \~english
     * current user added some one into black list on other device
     */
     int CONTACT_BAN           = 5;

    /**
     * \~chinese
     * 好友在其他设备被移出黑名单
     *
     * \~english
     * current user removed some one from black list on other device
     */
     int CONTACT_ALLOW         = 6;



    /**
     * \~chinese
     * 创建了群组
     *
     * \~english
     * current user created group on other device
     */
    int GROUP_CREATE            = 10;

    /**
     * \~chinese
     * 销毁了群组
     *
     * \~english
     * current user destroyed the group on other device
     */
    int GROUP_DESTROY           = 11;

    /**
     * \~chinese
     * 已经加入群组
     *
     * \~english
     * current user joined the group on other device
     */
    int GROUP_JOIN              = 12;

    /**
     * \~chinese
     * 已经离开群组
     *
     * \~english
     * current user leaved the group on other device
     */
    int GROUP_LEAVE             = 13;

    /**
     * \~chinese
     * 发起群组申请
     *
     * \~english
     * current user applyed to join the group on other device
     */
    int GROUP_APPLY             = 14;

    /**
     * \~chinese
     * 同意群组申请
     *
     * \~english
     * current user accepted group application on other device
     */
    int GROUP_APPLY_ACCEPT      = 15;

    /**
     * \~chinese
     * 拒绝群组申请
     *
     * \~english
     * current user refused group application on other device
     */
    int GROUP_APPLY_DECLINE     = 16;

    /**
     * \~chinese
     * 邀请群成员
     *
     * \~english
     * current user invited some one to join the group on other device
     */
    int GROUP_INVITE            = 17; //

    /**
     * \~chinese
     * 同意群组邀请
     *
     * \~english
     * current user accepted the group invitation on other device
     */
    int GROUP_INVITE_ACCEPT     = 18; //

    /**
     * \~chinese
     * 拒绝群组邀请
     *
     * \~english
     * current user declined the group invitation on other device
     */
    int GROUP_INVITE_DECLINE    = 19;

    /**
     * \~chinese
     * 将某人踢出群
     *
     * \~english
     * current user kicked some one from group on other device
     */
    int GROUP_KICK              = 20;

    /**
     * \~chinese
     * 加入群组黑名单
     *
     * \~english
     * current user added some one into group black list on other device
     */
    int GROUP_BAN               = 21; //加入群组黑名单

    /**
     * \~chinese
     * 移除群组黑名单
     *
     * \~english
     * current user removed some one from black list on other device
     */
    int GROUP_ALLOW             = 22;

    /**
     * \~chinese
     * 屏蔽群组
     *
     * \~english
     * current user blocked the group message on other device
     */
    int GROUP_BLOCK             = 23;

    /**
     * \~chinese
     * 取消群组屏蔽
     *
     * \~english
     * current user unblock the group message on other device
     */
    int GROUP_UNBLOCK           = 24;

    /**
     * \~chinese
     * 转移群主
     *
     * \~english
     * current user assigned group owner to some one else on other device
     */
    int GROUP_ASSIGN_OWNER      = 25;

    /**
     * \~chinese
     * 添加管理员
     *
     * \~english
     * current user added administrator on other device
     */
    int GROUP_ADD_ADMIN         = 26;

    /**
     * \~chinese
     * 移除管理员
     *
     * \~english
     * current user removed administrator on other device
     */
    int GROUP_REMOVE_ADMIN      = 27;

    /**
     * \~chinese
     * 禁言用户
     *
     * \~english
     * current user added some one into mute list on other device
     */
    int GROUP_ADD_MUTE          = 28;

    /**
     * \~chinese
     * 移除禁言
     *
     * \~english
     * current user removed some one from mute list
     */
    int GROUP_REMOVE_MUTE       = 29;

    /**
     * Multi device onContact event
     * @param event
     * @param target
     * @param ext
     */
    void onContactEvent(int event, String target, String ext);

    /**
     * Multi device onGroup event
     * @param event
     * @param target
     * @param usernames
     */
    void onGroupEvent(int event, String target, List<String> usernames);
}
