/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.util;

import android.util.Log;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Scanner;

public class CpuMonitor {
    private static final int SAMPLE_SAVE_NUMBER = 10;
    private int[] percentVec = new int[10];
    private int sum3 = 0;
    private int sum10 = 0;
    private static final String TAG = "CpuMonitor";
    private long[] cpuFreq;
    private int cpusPresent;
    private double lastPercentFreq = -1.0;
    private int cpuCurrent;
    private int cpuAvg3;
    private int cpuAvgAll;
    private boolean initialized = false;
    private String[] maxPath;
    private String[] curPath;
    ProcStat lastProcStat;

    private void init() {
        block9: {
            try {
                FileReader fileReader = new FileReader("/sys/devices/system/cpu/present");
                try {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(fileReader);
                        Scanner scanner = new Scanner(bufferedReader).useDelimiter("[-\n]");
                        scanner.nextInt();
                        this.cpusPresent = 1 + scanner.nextInt();
                        scanner.close();
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)"Cannot do CPU stats due to /sys/devices/system/cpu/present parsing problem");
                        fileReader.close();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    fileReader.close();
                    throw throwable;
                }
                fileReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.e((String)TAG, (String)"Cannot do CPU stats since /sys/devices/system/cpu/present is missing");
            }
            catch (IOException iOException) {
                Log.e((String)TAG, (String)"Error closing file");
            }
        }
        this.cpuFreq = new long[this.cpusPresent];
        this.maxPath = new String[this.cpusPresent];
        this.curPath = new String[this.cpusPresent];
        int n = 0;
        while (n < this.cpusPresent) {
            this.cpuFreq[n] = 0L;
            this.maxPath[n] = "/sys/devices/system/cpu/cpu" + n + "/cpufreq/cpuinfo_max_freq";
            this.curPath[n] = "/sys/devices/system/cpu/cpu" + n + "/cpufreq/scaling_cur_freq";
            ++n;
        }
        this.lastProcStat = new ProcStat(0L, 0L);
        this.initialized = true;
    }

    public boolean sampleCpuUtilization() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        if (!this.initialized) {
            this.init();
        }
        int n = 0;
        while (n < this.cpusPresent) {
            long l4;
            if (this.cpuFreq[n] == 0L) {
                l4 = this.readFreqFromFile(this.maxPath[n]);
                if (l4 > 0L) {
                    l = l4;
                    this.cpuFreq[n] = l4;
                    this.maxPath[n] = null;
                }
            } else {
                l = this.cpuFreq[n];
            }
            l4 = this.readFreqFromFile(this.curPath[n]);
            l2 += l4;
            l3 += l;
            ++n;
        }
        if (l3 == 0L) {
            Log.e((String)TAG, (String)"Could not read max frequency for any CPU");
            return false;
        }
        double d = 100.0 * (double)l2 / (double)l3;
        double d2 = this.lastPercentFreq > 0.0 ? (this.lastPercentFreq + d) * 0.5 : d;
        this.lastPercentFreq = d;
        ProcStat procStat = this.readIdleAndRunTime();
        if (procStat == null) {
            return false;
        }
        long l5 = procStat.runTime - this.lastProcStat.runTime;
        long l6 = procStat.idleTime - this.lastProcStat.idleTime;
        this.lastProcStat = procStat;
        long l7 = l5 + l6;
        int n2 = l7 == 0L ? 0 : (int)Math.round(d2 * (double)l5 / (double)l7);
        n2 = Math.max(0, Math.min(n2, 100));
        this.sum3 += n2 - this.percentVec[2];
        this.sum10 += n2 - this.percentVec[9];
        int n3 = 9;
        while (n3 > 0) {
            this.percentVec[n3] = this.percentVec[n3 - 1];
            --n3;
        }
        this.percentVec[0] = n2;
        this.cpuCurrent = n2;
        this.cpuAvg3 = this.sum3 / 3;
        this.cpuAvgAll = this.sum10 / 10;
        return true;
    }

    public int getCpuCurrent() {
        return this.cpuCurrent;
    }

    public int getCpuAvg3() {
        return this.cpuAvg3;
    }

    public int getCpuAvgAll() {
        return this.cpuAvgAll;
    }

    private long readFreqFromFile(String string) {
        long l = 0L;
        try {
            FileReader fileReader = new FileReader(string);
            try {
                try {
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    Scanner scanner = new Scanner(bufferedReader);
                    l = scanner.nextLong();
                    scanner.close();
                }
                catch (Exception exception) {
                    fileReader.close();
                }
            }
            finally {
                fileReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"Error closing file");
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProcStat readIdleAndRunTime() {
        long l = 0L;
        long l2 = 0L;
        try {
            FileReader fileReader = new FileReader("/proc/stat");
            try {
                try {
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    Scanner scanner = new Scanner(bufferedReader);
                    scanner.next();
                    long l3 = scanner.nextLong();
                    long l4 = scanner.nextLong();
                    long l5 = scanner.nextLong();
                    l = l3 + l4 + l5;
                    l2 = scanner.nextLong();
                    scanner.close();
                    return new ProcStat(l, l2);
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"Problems parsing /proc/stat");
                    fileReader.close();
                    return null;
                }
            }
            finally {
                fileReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)TAG, (String)"Cannot open /proc/stat for reading");
            return null;
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"Problems reading /proc/stat");
            return null;
        }
    }

    private class ProcStat {
        final long runTime;
        final long idleTime;

        ProcStat(long l, long l2) {
            this.runTime = l;
            this.idleTime = l2;
        }
    }
}

