/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.superrtc.call.EglBase;
import com.superrtc.call.GlRectDrawer;
import com.superrtc.call.GlUtil;
import com.superrtc.call.Logging;
import com.superrtc.call.RendererCommon;
import com.superrtc.call.ThreadUtils;
import com.superrtc.call.VideoRenderer;
import java.util.concurrent.CountDownLatch;

public class SurfaceViewRenderer
extends SurfaceView
implements SurfaceHolder.Callback,
VideoRenderer.Callbacks {
    private static final String TAG = "SurfaceViewRenderer";
    private HandlerThread renderThread;
    private final Object handlerLock = new Object();
    private Handler renderThreadHandler;
    private EglBase eglBase;
    private final RendererCommon.YuvUploader yuvUploader = new RendererCommon.YuvUploader();
    private RendererCommon.GlDrawer drawer;
    private int[] yuvTextures = null;
    private final Object frameLock = new Object();
    private VideoRenderer.I420Frame pendingFrame;
    private final Object layoutLock = new Object();
    private Point desiredLayoutSize = new Point();
    private final Point layoutSize = new Point();
    private final Point surfaceSize = new Point();
    private boolean isSurfaceCreated;
    private int frameWidth;
    private int frameHeight;
    private int frameRotation;
    private RendererCommon.ScalingType scalingType = RendererCommon.ScalingType.SCALE_ASPECT_BALANCED;
    private boolean mirror;
    private RendererCommon.RendererEvents rendererEvents;
    private final Object statisticsLock = new Object();
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long firstFrameTimeNs;
    private long renderTimeNs;
    private final Runnable renderFrameRunnable = new Runnable(){

        @Override
        public void run() {
            SurfaceViewRenderer.this.renderFrameOnRenderThread();
        }
    };
    private final Runnable makeBlackRunnable = new Runnable(){

        @Override
        public void run() {
            SurfaceViewRenderer.this.makeBlack();
        }
    };

    public SurfaceViewRenderer(Context context) {
        super(context);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public SurfaceViewRenderer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents) {
        this.init(context, rendererEvents, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                throw new IllegalStateException(String.valueOf(this.getResourceName()) + "Already initialized");
            }
            Logging.d(TAG, String.valueOf(this.getResourceName()) + "Initializing.");
            this.rendererEvents = rendererEvents;
            this.drawer = glDrawer;
            this.renderThread = new HandlerThread(TAG);
            this.renderThread.start();
            this.eglBase = EglBase.create(context, nArray);
            this.renderThreadHandler = new Handler(this.renderThread.getLooper());
        }
        this.tryCreateEglSurface();
    }

    public void tryCreateEglSurface() {
        this.runOnRenderThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = SurfaceViewRenderer.this.layoutLock;
                synchronized (object) {
                    if (SurfaceViewRenderer.this.isSurfaceCreated && !SurfaceViewRenderer.this.eglBase.hasSurface()) {
                        SurfaceViewRenderer.this.eglBase.createSurface(SurfaceViewRenderer.this.getHolder().getSurface());
                        SurfaceViewRenderer.this.eglBase.makeCurrent();
                        GLES20.glPixelStorei((int)3317, (int)1);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                Logging.d(TAG, String.valueOf(this.getResourceName()) + "Already released");
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    SurfaceViewRenderer.this.drawer.release();
                    SurfaceViewRenderer.this.drawer = null;
                    if (SurfaceViewRenderer.this.yuvTextures != null) {
                        GLES20.glDeleteTextures((int)3, (int[])SurfaceViewRenderer.this.yuvTextures, (int)0);
                        SurfaceViewRenderer.this.yuvTextures = null;
                    }
                    SurfaceViewRenderer.this.makeBlack();
                    SurfaceViewRenderer.this.eglBase.release();
                    SurfaceViewRenderer.this.eglBase = null;
                    countDownLatch.countDown();
                }
            });
            this.renderThreadHandler = null;
        }
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        this.renderThread.quit();
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                VideoRenderer.renderFrameDone(this.pendingFrame);
                this.pendingFrame = null;
            }
        }
        ThreadUtils.joinUninterruptibly((Thread)this.renderThread);
        this.renderThread = null;
        object = this.layoutLock;
        synchronized (object) {
            this.frameWidth = 0;
            this.frameHeight = 0;
            this.frameRotation = 0;
            this.rendererEvents = null;
        }
        this.resetStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStatistics() {
        Object object = this.statisticsLock;
        synchronized (object) {
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.firstFrameTimeNs = 0L;
            this.renderTimeNs = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean bl) {
        Object object = this.layoutLock;
        synchronized (object) {
            this.mirror = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScalingType(RendererCommon.ScalingType scalingType) {
        Object object = this.layoutLock;
        synchronized (object) {
            this.scalingType = scalingType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderFrame(VideoRenderer.I420Frame i420Frame) {
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.framesReceived;
        }
        object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                Logging.d(TAG, String.valueOf(this.getResourceName()) + "Dropping frame - Not initialized or already released.");
                VideoRenderer.renderFrameDone(i420Frame);
                return;
            }
            Object object2 = this.frameLock;
            synchronized (object2) {
                if (this.pendingFrame != null) {
                    Object object3 = this.statisticsLock;
                    synchronized (object3) {
                        ++this.framesDropped;
                    }
                    VideoRenderer.renderFrameDone(this.pendingFrame);
                }
                this.pendingFrame = i420Frame;
                this.updateFrameDimensionsAndReportEvents(i420Frame);
                this.renderThreadHandler.post(this.renderFrameRunnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Point getDesiredLayoutSize(int n, int n2) {
        Object object = this.layoutLock;
        synchronized (object) {
            int n3 = SurfaceViewRenderer.getDefaultSize((int)Integer.MAX_VALUE, (int)n);
            int n4 = SurfaceViewRenderer.getDefaultSize((int)Integer.MAX_VALUE, (int)n2);
            Point point = RendererCommon.getDisplaySize(this.scalingType, this.frameAspectRatio(), n3, n4);
            if (View.MeasureSpec.getMode((int)n) == 0x40000000) {
                point.x = n3;
            }
            if (View.MeasureSpec.getMode((int)n2) == 0x40000000) {
                point.y = n4;
            }
            return point;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int n, int n2) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.frameWidth == 0 || this.frameHeight == 0) {
                super.onMeasure(n, n2);
                return;
            }
            this.desiredLayoutSize = this.getDesiredLayoutSize(n, n2);
            if (this.desiredLayoutSize.x != this.getMeasuredWidth() || this.desiredLayoutSize.y != this.getMeasuredHeight()) {
                Object object2 = this.handlerLock;
                synchronized (object2) {
                    if (this.renderThreadHandler != null) {
                        this.renderThreadHandler.postAtFrontOfQueue(this.makeBlackRunnable);
                    }
                }
            }
            this.setMeasuredDimension(this.desiredLayoutSize.x, this.desiredLayoutSize.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        Object object = this.layoutLock;
        synchronized (object) {
            this.layoutSize.x = n3 - n;
            this.layoutSize.y = n4 - n2;
        }
        this.runOnRenderThread(this.renderFrameRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        Logging.d(TAG, String.valueOf(this.getResourceName()) + "Surface created.");
        Object object = this.layoutLock;
        synchronized (object) {
            this.isSurfaceCreated = true;
        }
        this.tryCreateEglSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Logging.d(TAG, String.valueOf(this.getResourceName()) + "Surface destroyed.");
        Object object = this.layoutLock;
        synchronized (object) {
            this.isSurfaceCreated = false;
            this.surfaceSize.x = 0;
            this.surfaceSize.y = 0;
        }
        this.runOnRenderThread(new Runnable(){

            @Override
            public void run() {
                SurfaceViewRenderer.this.eglBase.releaseSurface();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        Logging.d(TAG, String.valueOf(this.getResourceName()) + "Surface changed: " + n2 + "x" + n3);
        Object object = this.layoutLock;
        synchronized (object) {
            this.surfaceSize.x = n2;
            this.surfaceSize.y = n3;
        }
        this.runOnRenderThread(this.renderFrameRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(runnable);
            }
        }
    }

    private String getResourceName() {
        try {
            return String.valueOf(this.getResources().getResourceEntryName(this.getId())) + ": ";
        }
        catch (Resources.NotFoundException notFoundException) {
            return "";
        }
    }

    private void makeBlack() {
        if (Thread.currentThread() != this.renderThread) {
            throw new IllegalStateException(String.valueOf(this.getResourceName()) + "Wrong thread.");
        }
        if (this.eglBase != null && this.eglBase.hasSurface()) {
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConsistentLayout() {
        if (Thread.currentThread() != this.renderThread) {
            throw new IllegalStateException(String.valueOf(this.getResourceName()) + "Wrong thread.");
        }
        Object object = this.layoutLock;
        synchronized (object) {
            return this.layoutSize.equals((Object)this.desiredLayoutSize) && this.surfaceSize.equals((Object)this.layoutSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void renderFrameOnRenderThread() {
        block26: {
            block25: {
                block24: {
                    if (Thread.currentThread() != this.renderThread) {
                        throw new IllegalStateException(String.valueOf(this.getResourceName()) + "Wrong thread.");
                    }
                    var2_1 = this.frameLock;
                    // MONITORENTER : var2_1
                    if (this.pendingFrame == null) {
                        // MONITOREXIT : var2_1
                        return;
                    }
                    var1_3 = this.pendingFrame;
                    this.pendingFrame = null;
                    // MONITOREXIT : var2_1
                    if (this.eglBase == null || !this.eglBase.hasSurface()) {
                        Logging.d("SurfaceViewRenderer", String.valueOf(this.getResourceName()) + "No surface to draw on");
                        VideoRenderer.renderFrameDone(var1_3);
                        return;
                    }
                    if (!this.checkConsistentLayout()) {
                        this.makeBlack();
                        VideoRenderer.renderFrameDone(var1_3);
                        return;
                    }
                    var2_1 = this.layoutLock;
                    // MONITORENTER : var2_1
                    if (this.eglBase.surfaceWidth() != this.surfaceSize.x || this.eglBase.surfaceHeight() != this.surfaceSize.y) {
                        this.makeBlack();
                    }
                    // MONITOREXIT : var2_1
                    var2_2 = System.nanoTime();
                    var5_4 = this.layoutLock;
                    // MONITORENTER : var5_4
                    var6_7 /* !! */  = RendererCommon.rotateTextureMatrix(var1_3.samplingMatrix, var1_3.rotationDegree);
                    var7_8 = RendererCommon.getLayoutMatrix(this.mirror, this.frameAspectRatio(), (float)this.layoutSize.x / (float)this.layoutSize.y);
                    var4_9 = RendererCommon.multiplyMatrices(var6_7 /* !! */ , var7_8);
                    // MONITOREXIT : var5_4
                    GLES20.glClear((int)16384);
                    if (!var1_3.yuvFrame) break block24;
                    if (this.yuvTextures != null) break block25;
                    this.yuvTextures = new int[3];
                    var5_5 = 0;
                    if (true) ** GOTO lbl58
                }
                this.drawer.drawOes(var1_3.textureId, var4_9, 0, 0, this.surfaceSize.x, this.surfaceSize.y);
                break block26;
                do {
                    this.yuvTextures[var5_5] = GlUtil.generateTexture(3553);
                    ++var5_5;
lbl58:
                    // 2 sources

                } while (var5_5 < 3);
            }
            this.yuvUploader.uploadYuvData(this.yuvTextures, var1_3.width, var1_3.height, var1_3.yuvStrides, var1_3.yuvPlanes);
            this.drawer.drawYuv(this.yuvTextures, var4_9, 0, 0, this.surfaceSize.x, this.surfaceSize.y);
        }
        this.eglBase.swapBuffers();
        VideoRenderer.renderFrameDone(var1_3);
        var5_6 = this.statisticsLock;
        // MONITORENTER : var5_6
        if (this.framesRendered == 0) {
            this.firstFrameTimeNs = var2_2;
            v3 = this.layoutLock;
            var6_7 /* !! */  = (float[])v3;
            // MONITORENTER : v3
            Logging.d("SurfaceViewRenderer", String.valueOf(this.getResourceName()) + "Reporting first rendered frame.");
            if (this.rendererEvents != null) {
                this.rendererEvents.onFirstFrameRendered();
            }
            // MONITOREXIT : var6_7 /* !! */ 
        }
        ++this.framesRendered;
        this.renderTimeNs += System.nanoTime() - var2_2;
        if (this.framesRendered % 300 == 0) {
            this.logStatistics();
        }
        // MONITOREXIT : var5_6
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float frameAspectRatio() {
        Object object = this.layoutLock;
        synchronized (object) {
            block4: {
                if (this.frameWidth != 0 && this.frameHeight != 0) break block4;
                return 0.0f;
            }
            return this.frameRotation % 180 == 0 ? (float)this.frameWidth / (float)this.frameHeight : (float)this.frameHeight / (float)this.frameWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrameDimensionsAndReportEvents(VideoRenderer.I420Frame i420Frame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.frameWidth != i420Frame.width || this.frameHeight != i420Frame.height || this.frameRotation != i420Frame.rotationDegree) {
                Logging.d(TAG, String.valueOf(this.getResourceName()) + "Reporting frame resolution changed to " + i420Frame.width + "x" + i420Frame.height + " with rotation " + i420Frame.rotationDegree);
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(i420Frame.width, i420Frame.height, i420Frame.rotationDegree);
                }
                this.frameWidth = i420Frame.width;
                this.frameHeight = i420Frame.height;
                this.frameRotation = i420Frame.rotationDegree;
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        SurfaceViewRenderer.this.requestLayout();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatistics() {
        Object object = this.statisticsLock;
        synchronized (object) {
            Logging.d(TAG, String.valueOf(this.getResourceName()) + "Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered);
            if (this.framesReceived > 0 && this.framesRendered > 0) {
                long l = System.nanoTime() - this.firstFrameTimeNs;
                Logging.d(TAG, String.valueOf(this.getResourceName()) + "Duration: " + (int)((double)l / 1000000.0) + " ms. FPS: " + (double)this.framesRendered * 1.0E9 / (double)l);
                Logging.d(TAG, String.valueOf(this.getResourceName()) + "Average render time: " + (int)(this.renderTimeNs / (long)(1000 * this.framesRendered)) + " us.");
            }
        }
    }
}

