/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import com.superrtc.call.EglBase;
import com.superrtc.call.GlShader;
import com.superrtc.call.GlUtil;
import com.superrtc.call.RendererCommon;
import com.superrtc.call.ThreadUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class SurfaceTextureHelper {
    private static final String TAG = "SurfaceTextureHelper";
    private final Handler handler;
    private final EglBase eglBase;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private YuvConverter yuvConverter;
    private OnTextureFrameAvailableListener listener;
    private boolean hasPendingTexture = false;
    private volatile boolean isTextureInUse = false;
    private boolean isQuitting = false;

    public static SurfaceTextureHelper create(final EglBase.Context context) {
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        final Handler handler = new Handler(handlerThread.getLooper());
        return ThreadUtils.invokeUninterruptibly(handler, new Callable<SurfaceTextureHelper>(){

            @Override
            public SurfaceTextureHelper call() {
                return new SurfaceTextureHelper(context, handler, null);
            }
        });
    }

    private SurfaceTextureHelper(EglBase.Context context, Handler handler) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
        }
        this.handler = handler;
        this.eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER);
        this.eglBase.createDummyPbufferSurface();
        this.eglBase.makeCurrent();
        this.oesTextureId = GlUtil.generateTexture(36197);
        this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
        this.surfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                SurfaceTextureHelper.this.hasPendingTexture = true;
                SurfaceTextureHelper.this.tryDeliverTextureFrame();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YuvConverter getYuvConverter() {
        if (this.yuvConverter != null) {
            return this.yuvConverter;
        }
        SurfaceTextureHelper surfaceTextureHelper = this;
        synchronized (surfaceTextureHelper) {
            if (this.yuvConverter == null) {
                this.yuvConverter = new YuvConverter(this.eglBase.getEglBaseContext());
            }
            return this.yuvConverter;
        }
    }

    public void startListening(final OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        if (this.listener != null) {
            throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.listener = onTextureFrameAvailableListener;
                SurfaceTextureHelper.this.tryDeliverTextureFrame();
            }
        });
    }

    public void stopListening() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        this.listener = null;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.isTextureInUse = false;
                if (SurfaceTextureHelper.this.isQuitting) {
                    SurfaceTextureHelper.this.release();
                } else {
                    SurfaceTextureHelper.this.tryDeliverTextureFrame();
                }
            }
        });
    }

    public boolean isTextureInUse() {
        return this.isTextureInUse;
    }

    public void dispose() {
        if (this.handler.getLooper().getThread() == Thread.currentThread()) {
            this.isQuitting = true;
            if (!this.isTextureInUse) {
                this.release();
            }
            return;
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.handler.postAtFrontOfQueue(new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.isQuitting = true;
                countDownLatch.countDown();
                if (!SurfaceTextureHelper.this.isTextureInUse) {
                    SurfaceTextureHelper.this.release();
                }
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
    }

    public void textureToYUV(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, float[] fArray) {
        if (n4 != this.oesTextureId) {
            throw new IllegalStateException("textureToByteBuffer called with unexpected textureId");
        }
        this.getYuvConverter().convert(byteBuffer, n, n2, n3, n4, fArray);
    }

    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isQuitting || !this.hasPendingTexture || this.isTextureInUse || this.listener == null) {
            return;
        }
        this.isTextureInUse = true;
        this.hasPendingTexture = false;
        this.eglBase.makeCurrent();
        this.surfaceTexture.updateTexImage();
        float[] fArray = new float[16];
        this.surfaceTexture.getTransformMatrix(fArray);
        long l = Build.VERSION.SDK_INT >= 14 ? this.surfaceTexture.getTimestamp() : TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        this.listener.onTextureFrameAvailable(this.oesTextureId, fArray, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isTextureInUse || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        SurfaceTextureHelper surfaceTextureHelper = this;
        synchronized (surfaceTextureHelper) {
            if (this.yuvConverter != null) {
                this.yuvConverter.release();
            }
        }
        this.eglBase.makeCurrent();
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
        this.surfaceTexture.release();
        this.eglBase.release();
        this.handler.getLooper().quit();
    }

    /* synthetic */ SurfaceTextureHelper(EglBase.Context context, Handler handler, SurfaceTextureHelper surfaceTextureHelper) {
        this(context, handler);
    }

    public static interface OnTextureFrameAvailableListener {
        public void onTextureFrameAvailable(int var1, float[] var2, long var3);
    }

    private static class YuvConverter {
        private final EglBase eglBase;
        private final GlShader shader;
        private boolean released = false;
        private static final FloatBuffer DEVICE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
        private static final FloatBuffer TEXTURE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
        private static final String VERTEX_SHADER = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
        private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES oesTex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
        private int texMatrixLoc;
        private int xUnitLoc;
        private int coeffsLoc;

        YuvConverter(EglBase.Context context) {
            this.eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_RGBA_BUFFER);
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
            this.shader = new GlShader(VERTEX_SHADER, FRAGMENT_SHADER);
            this.shader.useProgram();
            this.texMatrixLoc = this.shader.getUniformLocation("texMatrix");
            this.xUnitLoc = this.shader.getUniformLocation("xUnit");
            this.coeffsLoc = this.shader.getUniformLocation("coeffs");
            GLES20.glUniform1i((int)this.shader.getUniformLocation("oesTex"), (int)0);
            GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
            this.shader.setVertexAttribArray("in_pos", 2, DEVICE_RECTANGLE);
            this.shader.setVertexAttribArray("in_tc", 2, TEXTURE_RECTANGLE);
            this.eglBase.detachCurrent();
        }

        synchronized void convert(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, float[] fArray) {
            if (this.released) {
                throw new IllegalStateException("YuvConverter.convert called on released object");
            }
            if (n3 % 8 != 0) {
                throw new IllegalArgumentException("Invalid stride, must be a multiple of 8");
            }
            if (n3 < n) {
                throw new IllegalArgumentException("Invalid stride, must >= width");
            }
            int n5 = (n + 3) / 4;
            int n6 = (n + 7) / 8;
            int n7 = (n2 + 1) / 2;
            int n8 = n2 + n7;
            int n9 = n3 * n8;
            if (byteBuffer.capacity() < n9) {
                throw new IllegalArgumentException("YuvConverter.convert called with too small buffer");
            }
            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.verticalFlipMatrix());
            if (this.eglBase.hasSurface()) {
                if (this.eglBase.surfaceWidth() != n3 / 4 || this.eglBase.surfaceHeight() != n8) {
                    this.eglBase.releaseSurface();
                    this.eglBase.createPbufferSurface(n3 / 4, n8);
                }
            } else {
                this.eglBase.createPbufferSurface(n3 / 4, n8);
            }
            this.eglBase.makeCurrent();
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)36197, (int)n4);
            GLES20.glUniformMatrix4fv((int)this.texMatrixLoc, (int)1, (boolean)false, (float[])fArray, (int)0);
            GLES20.glViewport((int)0, (int)0, (int)n5, (int)n2);
            GLES20.glUniform2f((int)this.xUnitLoc, (float)(fArray[0] / (float)n), (float)(fArray[1] / (float)n));
            GLES20.glUniform4f((int)this.coeffsLoc, (float)0.299f, (float)0.587f, (float)0.114f, (float)0.0f);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GLES20.glViewport((int)0, (int)n2, (int)n6, (int)n7);
            GLES20.glUniform2f((int)this.xUnitLoc, (float)(2.0f * fArray[0] / (float)n), (float)(2.0f * fArray[1] / (float)n));
            GLES20.glUniform4f((int)this.coeffsLoc, (float)-0.169f, (float)-0.331f, (float)0.499f, (float)0.5f);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GLES20.glViewport((int)(n3 / 8), (int)n2, (int)n6, (int)n7);
            GLES20.glUniform4f((int)this.coeffsLoc, (float)0.499f, (float)-0.418f, (float)-0.0813f, (float)0.5f);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GLES20.glReadPixels((int)0, (int)0, (int)(n3 / 4), (int)n8, (int)6408, (int)5121, (Buffer)byteBuffer);
            GlUtil.checkNoGLES2Error("YuvConverter.convert");
            GLES20.glBindTexture((int)36197, (int)0);
            this.eglBase.detachCurrent();
        }

        synchronized void release() {
            this.released = true;
            this.eglBase.makeCurrent();
            this.shader.release();
            this.eglBase.release();
        }
    }
}

