/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.os.SystemClock;
import android.util.Range;
import android.util.Size;
import com.superrtc.call.CameraEnumerationAndroid;
import com.superrtc.call.Logging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TargetApi(value=21)
public class Camera2Enumerator
implements CameraEnumerationAndroid.Enumerator {
    private static final String TAG = "Camera2Enumerator";
    private static final double NANO_SECONDS_PER_SECOND = 1.0E9;
    private final CameraManager cameraManager;
    private final Map<Integer, List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats = new HashMap<Integer, List<CameraEnumerationAndroid.CaptureFormat>>();

    public static boolean isSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public Camera2Enumerator(Context context) {
        this.cameraManager = (CameraManager)context.getSystemService("camera");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(int n) {
        Map<Integer, List<CameraEnumerationAndroid.CaptureFormat>> map = this.cachedSupportedFormats;
        synchronized (map) {
            Range range;
            CameraCharacteristics cameraCharacteristics;
            if (this.cachedSupportedFormats.containsKey(n)) {
                return this.cachedSupportedFormats.get(n);
            }
            Logging.d(TAG, "Get supported formats for camera index " + n + ".");
            long l = SystemClock.elapsedRealtime();
            try {
                cameraCharacteristics = this.cameraManager.getCameraCharacteristics(Integer.toString(n));
            }
            catch (Exception exception) {
                Logging.e(TAG, "getCameraCharacteristics(): " + exception);
                return new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            }
            Size size = (Size)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            int n2 = 0;
            Size size2 = size;
            int n3 = ((Range[])size2).length;
            int n4 = 0;
            while (n4 < n3) {
                range = size2[n4];
                n2 = Math.max(n2, (Integer)range.getUpper());
                ++n4;
            }
            range = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            Size[] sizeArray = range.getOutputSizes(35);
            if (sizeArray == null) {
                throw new RuntimeException("ImageFormat.YUV_420_888 not supported.");
            }
            ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            Size[] sizeArray2 = sizeArray;
            int n5 = sizeArray.length;
            int n6 = 0;
            while (n6 < n5) {
                size2 = sizeArray2[n6];
                long l2 = 0L;
                try {
                    l2 = range.getOutputMinFrameDuration(35, size2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n7 = l2 == 0L ? n2 : (int)Math.round(1.0E9 / (double)l2);
                arrayList.add(new CameraEnumerationAndroid.CaptureFormat(size2.getWidth(), size2.getHeight(), 0, n7 * 1000));
                ++n6;
            }
            this.cachedSupportedFormats.put(n, arrayList);
            long l3 = SystemClock.elapsedRealtime();
            Logging.d(TAG, "Get supported formats for camera index " + n + " done." + " Time spent: " + (l3 - l) + " ms.");
            return arrayList;
        }
    }
}

