/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.cloud;

import android.content.Context;
import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.cloud.CloudFileManager;
import com.hyphenate.cloud.CloudOperationCallback;
import com.hyphenate.cloud.CustomMultiPartEntity;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.cloud.HttpClientConfig;
import com.hyphenate.cloud.HttpClientManager;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.NetUtils;
import internal.org.apache.http.entity.mime.content.FileBody;
import internal.org.apache.http.entity.mime.content.StringBody;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class HttpFileManager
extends CloudFileManager {
    private static final long MAX_ALLOWED_FILE_SIZE = 0xA00000L;
    private long totalSize;
    private Context appContext;
    boolean tokenRetrieved = false;
    private static final int max_retry_times_on_connection_refused = 20;

    public HttpFileManager() {
        this.appContext = EMClient.getInstance().getContext();
    }

    public HttpFileManager(Context context, String string) {
        this.appContext = context.getApplicationContext();
    }

    public HttpFileManager(Context context) {
        this.appContext = context.getApplicationContext();
    }

    @Override
    public boolean authorization() {
        return true;
    }

    private void sendFiletoServerHttp(String string, String string2, String string3, String string4, Map<String, String> map, CloudOperationCallback cloudOperationCallback) {
        this.sendFiletoServerHttpWithCountDown(string, string2, string3, string4, map, cloudOperationCallback, -1, false);
    }

    private void sendFiletoServerHttpWithCountDown(final String string, final String string2, final String string3, final String string4, Map<String, String> map, final CloudOperationCallback cloudOperationCallback, int n, boolean bl) {
        EMLog.d("CloudFileManager", "sendFiletoServerHttpWithCountDown .....");
        File file = new File(string);
        if (!file.isFile()) {
            EMLog.e("CloudFileManager", "Source file doesn't exist");
            cloudOperationCallback.onError("Source file doesn't exist");
            return;
        }
        if (file.length() > 0xA00000L) {
            cloudOperationCallback.onError("file doesn't bigger than 10 M");
            return;
        }
        final Map<String, String> map2 = HttpClientManager.addDomainToHeaders(map);
        HttpResponse httpResponse = null;
        String string5 = HttpClientConfig.getFileRemoteUrl(string2);
        EMLog.d("CloudFileManager", " remote path url : " + string5 + " --countDown: " + n);
        int n2 = HttpClientConfig.getTimeout(map2);
        DefaultHttpClient defaultHttpClient = HttpClientConfig.getDefaultHttpClient(n2);
        try {
            Object object;
            Object object2;
            HttpPost httpPost = new HttpPost(string5);
            CustomMultiPartEntity customMultiPartEntity = new CustomMultiPartEntity(new CustomMultiPartEntity.ProgressListener(){

                @Override
                public void transferred(long l) {
                    int n = (int)((float)l / (float)HttpFileManager.this.totalSize * 100.0f);
                    if (n != 100 && cloudOperationCallback != null) {
                        cloudOperationCallback.onProgress(n);
                    }
                }
            });
            if (string3 != null) {
                customMultiPartEntity.addPart("app", new StringBody(string3));
            }
            if (string4 != null) {
                customMultiPartEntity.addPart("id", new StringBody(string4));
            }
            if (map2 != null) {
                object2 = map2.entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    httpPost.addHeader((String)object.getKey(), (String)object.getValue());
                }
            }
            if (((String)(object2 = string2)).indexOf("/") > 0) {
                object = ((String)object2).substring(0, ((String)object2).lastIndexOf("/"));
                object2 = ((String)object2).substring(((String)object2).lastIndexOf("/"));
                customMultiPartEntity.addPart("path", new StringBody((String)object));
            }
            object = HttpFileManager.getMimeType(file);
            EMLog.d("CloudFileManager", " remote file name : " + (String)object2);
            customMultiPartEntity.addPart("file", new FileBody(file, (String)object2, (String)object, "UTF-8"));
            this.totalSize = customMultiPartEntity.getContentLength();
            httpPost.setEntity((HttpEntity)customMultiPartEntity);
            if (EMHttpClient.getInstance().chatConfig().g()) {
                HttpClientManager.checkAndProcessSSL(string5, defaultHttpClient);
            }
            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
            int n3 = httpResponse.getStatusLine().getStatusCode();
            EMLog.d("CloudFileManager", "server responseCode:" + n3 + " localFilePath : " + string);
            switch (n3) {
                case 200: {
                    cloudOperationCallback.onProgress(100);
                    HttpEntity httpEntity = httpResponse.getEntity();
                    String string6 = EntityUtils.toString((HttpEntity)httpEntity);
                    cloudOperationCallback.onSuccess(string6);
                    return;
                }
                case 401: {
                    long l = EMHttpClient.getInstance().chatConfig().o();
                    if (System.currentTimeMillis() - l <= 600000L) {
                        if (cloudOperationCallback != null) {
                            cloudOperationCallback.onError("unauthorized file");
                        }
                        return;
                    }
                    if (this.tokenRetrieved) {
                        cloudOperationCallback.onError("unauthorized file");
                        return;
                    }
                    boolean bl2 = true;
                    String string7 = EMClient.getInstance().getOptions().getAccessToken(bl2);
                    this.tokenRetrieved = true;
                    if (string7 == null) {
                        cloudOperationCallback.onError("unauthorized token is null");
                        return;
                    }
                    map2.put("Authorization", "Bearer " + string7);
                    if (!bl) {
                        new Thread(){

                            @Override
                            public void run() {
                                HttpFileManager.this.sendFiletoServerHttpWithCountDown(string, string2, string3, string4, map2, cloudOperationCallback, 3, true);
                            }
                        }.start();
                    } else if (n > 0) {
                        final int n4 = --n;
                        new Thread(){

                            @Override
                            public void run() {
                                HttpFileManager.this.sendFiletoServerHttpWithCountDown(string, string2, string3, string4, map2, cloudOperationCallback, n4, true);
                            }
                        }.start();
                    }
                    return;
                }
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            String string8 = EntityUtils.toString((HttpEntity)httpEntity);
            string8 = "Http response error : " + n3 + " error msg : " + string8;
            EMLog.e("CloudFileManager", string8);
            if (cloudOperationCallback != null) {
                cloudOperationCallback.onError(string8);
            }
            return;
        }
        catch (Exception exception) {
            String string9 = exception != null && exception.getMessage() != null ? exception.getMessage() : "failed to upload the files";
            EMLog.e("CloudFileManager", "sendFiletoServerHttp:" + string9);
            if (string9.toLowerCase().contains("refused") && NetUtils.hasNetwork(this.appContext)) {
                if (!bl) {
                    String string10 = EMHttpClient.getInstance().chatConfig().m();
                    final String string11 = HttpClientManager.getNewHost(string2, string10);
                    new Thread(){

                        @Override
                        public void run() {
                            HttpFileManager.this.sendFiletoServerHttpWithCountDown(string, string11, string3, string4, map2, cloudOperationCallback, 20, true);
                        }
                    }.start();
                    return;
                }
                if (n > 0) {
                    String string12 = EMHttpClient.getInstance().chatConfig().m();
                    final String string13 = HttpClientManager.getNewHost(string2, string12);
                    final int n5 = --n;
                    new Thread(){

                        @Override
                        public void run() {
                            HttpFileManager.this.sendFiletoServerHttpWithCountDown(string, string13, string3, string4, map2, cloudOperationCallback, n5, true);
                        }
                    }.start();
                    return;
                }
            }
            if (cloudOperationCallback != null) {
                cloudOperationCallback.onError(string9);
            }
            return;
        }
    }

    public static String getMimeType(File file) {
        String string = file.getName();
        if (string.endsWith(".3gp") || string.endsWith(".amr")) {
            return "audio/3gp";
        }
        if (string.endsWith(".jpe") || string.endsWith(".jpeg") || string.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (string.endsWith(".amr")) {
            return "audio/amr";
        }
        if (string.endsWith(".mp4")) {
            return "video/mp4";
        }
        return "image/png";
    }

    @Override
    public void uploadFileInBackground(final String string, final String string2, final String string3, final String string4, final Map<String, String> map, final CloudOperationCallback cloudOperationCallback) {
        new Thread(){

            @Override
            public void run() {
                try {
                    HttpFileManager.this.sendFiletoServerHttp(string, string2, string3, string4, map, cloudOperationCallback);
                }
                catch (Exception exception) {
                    if (exception != null && exception.toString() != null) {
                        EMLog.e("CloudFileManager", exception.toString());
                        cloudOperationCallback.onError(exception.toString());
                    }
                    cloudOperationCallback.onError("failed to upload the file : " + string + " remote path : " + string2);
                }
            }
        }.start();
    }

    public void uploadFile(String string, String string2, String string3, String string4, Map<String, String> map, CloudOperationCallback cloudOperationCallback) {
        try {
            this.sendFiletoServerHttp(string, string2, string3, string4, map, cloudOperationCallback);
        }
        catch (Exception exception) {
            EMLog.e("CloudFileManager", "uploadFile error:" + exception.toString());
            cloudOperationCallback.onError(exception.toString());
        }
    }

    @Override
    public void downloadFile(String string, String string2, String string3, Map<String, String> map, CloudOperationCallback cloudOperationCallback) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            if (cloudOperationCallback != null) {
                cloudOperationCallback.onError("remotefilepath is null or empty");
            }
            EMLog.e("CloudFileManager", "remotefilepath is null or empty");
        } else {
            String string4 = HttpClientConfig.getFileRemoteUrl(string);
            this.downloadFile(string4, string2, map, cloudOperationCallback);
        }
    }

    public void downloadFile(String string, String string2, Map<String, String> map, CloudOperationCallback cloudOperationCallback) {
        block3: {
            try {
                this.downloadFileWithCountDown(string, string2, map, cloudOperationCallback, 20);
            }
            catch (Exception exception) {
                String string3 = "failed to download file : " + string;
                if (exception != null && exception.toString() != null) {
                    string3 = exception.toString();
                }
                if (cloudOperationCallback == null) break block3;
                cloudOperationCallback.onError(string3);
            }
        }
    }

    private void downloadFileWithCountDown(String string, final String string2, Map<String, String> map, final CloudOperationCallback cloudOperationCallback, int n) {
        block18: {
            if (string == null || string.length() <= 0) {
                cloudOperationCallback.onError("invalid remoteUrl");
                return;
            }
            final Map<String, String> map2 = HttpClientManager.addDomainToHeaders(map);
            string = HttpClientConfig.getFileRemoteUrl(string);
            EMLog.d("CloudFileManager", "remoteUrl:" + string + " localFilePath:" + string2);
            string = this.processUrl(string);
            EMLog.d("CloudFileManager", "download file: remote url : " + string + " , local file : " + string2);
            File file = new File(string2);
            EMLog.d("CloudFileManager", "local exists:" + file.exists());
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            int n2 = HttpClientConfig.getTimeout(map2);
            DefaultHttpClient defaultHttpClient = HttpClientConfig.getDefaultHttpClient(n2);
            try {
                HttpGet httpGet = new HttpGet(string);
                this.processHeaders(httpGet, map2);
                HttpClientManager.checkAndProcessSSL(string, defaultHttpClient);
                HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
                int n3 = httpResponse.getStatusLine().getStatusCode();
                switch (n3) {
                    case 200: {
                        long l = this.onDownloadCompleted(httpResponse, cloudOperationCallback, string2);
                        if (l <= 0L) {
                            if (cloudOperationCallback != null) {
                                cloudOperationCallback.onError("downloaded content size is zero!");
                            }
                            return;
                        }
                        if (cloudOperationCallback != null) {
                            cloudOperationCallback.onSuccess("download successfully");
                        }
                        break;
                    }
                    case 401: {
                        long l = EMHttpClient.getInstance().chatConfig().o();
                        if (System.currentTimeMillis() - l <= 600000L) {
                            if (cloudOperationCallback != null) {
                                cloudOperationCallback.onError("unauthorized file");
                            }
                            return;
                        }
                        if (this.tokenRetrieved) {
                            if (cloudOperationCallback != null) {
                                cloudOperationCallback.onError("unauthorized file");
                            }
                            return;
                        }
                        final String string3 = string;
                        new Thread(){

                            @Override
                            public void run() {
                                boolean bl = true;
                                String string = EMClient.getInstance().getOptions().getAccessToken(bl);
                                if (string == null) {
                                    cloudOperationCallback.onError("unauthorized token is null");
                                    return;
                                }
                                HttpFileManager.this.tokenRetrieved = true;
                                if (map2 != null) {
                                    map2.put("Authorization", "Bearer " + string);
                                    HttpFileManager.this.downloadFile(string3, string2, map2, cloudOperationCallback);
                                } else {
                                    HttpFileManager.this.tokenRetrieved = false;
                                    if (cloudOperationCallback != null) {
                                        cloudOperationCallback.onError("unauthorized token is null");
                                    }
                                }
                            }
                        }.start();
                        break;
                    }
                    default: {
                        EMLog.e("CloudFileManager", "error response code is :" + n3);
                        if (cloudOperationCallback != null) {
                            cloudOperationCallback.onError(String.valueOf(n3));
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                String string4 = exception.getMessage();
                if (string4 == null && (string4 = exception.toString()) == null) {
                    string4 = "failed to download file";
                }
                if (string4.toLowerCase().contains("refused") && NetUtils.hasNetwork(this.appContext) && n > 0) {
                    String string5 = EMHttpClient.getInstance().chatConfig().m();
                    final String string6 = HttpClientManager.getNewHost(string, string5);
                    final int n4 = --n;
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                HttpFileManager.this.downloadFileWithCountDown(string6, string2, map2, cloudOperationCallback, n4);
                            }
                            catch (Exception exception) {
                                if (exception != null && exception.toString() != null) {
                                    cloudOperationCallback.onError(exception.toString());
                                }
                                cloudOperationCallback.onError("failed to download the file : " + string6);
                            }
                        }
                    }.start();
                    return;
                }
                EMLog.e("CloudFileManager", string4);
                if (cloudOperationCallback == null) break block18;
                cloudOperationCallback.onError(string4);
            }
        }
    }

    private String processUrl(String string) {
        if (string.contains("+")) {
            string = string.replaceAll("\\+", "%2B");
        }
        if (string.contains("#")) {
            string = string.replaceAll("#", "%23");
        }
        return string;
    }

    private void processHeaders(HttpGet httpGet, Map<String, String> map) {
        httpGet.addHeader("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
        httpGet.addHeader("Accept", "application/octet-stream");
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey().equals("Authorization") || entry.getKey().equals("Accept")) continue;
                httpGet.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private long onDownloadCompleted(HttpResponse httpResponse, CloudOperationCallback cloudOperationCallback, String string) throws IOException, IllegalStateException {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            return 0L;
        }
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        int n = 0;
        int n2 = 0;
        long l = httpEntity.getContentLength();
        try {
            inputStream = httpEntity.getContent();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            throw illegalStateException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        File file = new File(string);
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            inputStream.close();
            throw fileNotFoundException;
        }
        int n3 = NetUtils.getDownloadBufSize(this.appContext);
        byte[] byArray = new byte[n3];
        long l2 = 0L;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                int n4 = (int)((l2 += (long)n) * 100L / l);
                EMLog.d("HttpFileManager", n4 + "");
                if (n4 == 100 || n4 > n2 + 5) {
                    n2 = n4;
                    if (cloudOperationCallback != null) {
                        cloudOperationCallback.onProgress(n2);
                    }
                }
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            long l3 = file.length();
            return l3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        finally {
            ((OutputStream)fileOutputStream).close();
            inputStream.close();
        }
    }

    @Override
    public void deleteFileInBackground(final String string, final String string2, String string3, final CloudOperationCallback cloudOperationCallback) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                block5: {
                    HttpURLConnection httpURLConnection = null;
                    DataOutputStream dataOutputStream = null;
                    String string6 = "\r\n";
                    String string22 = "--";
                    String string3 = "*****";
                    String string4 = "";
                    string4 = HttpClientConfig.getFileRemoteUrl(string);
                    try {
                        String string5;
                        URL uRL = new URL(string4);
                        httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        httpURLConnection.setDoInput(true);
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setUseCaches(false);
                        httpURLConnection.setRequestMethod("POST");
                        httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
                        httpURLConnection.setRequestProperty("ENCTYPE", "multipart/form-data");
                        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + string3);
                        httpURLConnection.setRequestProperty("file", string);
                        dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                        dataOutputStream.writeBytes(string22 + string3 + string6);
                        if (string2 != null) {
                            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"app\"" + string6 + string6);
                            dataOutputStream.writeBytes(string2 + string6);
                            dataOutputStream.writeBytes(string22 + string3 + string6);
                        }
                        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"file\";filename=\"" + string + "\"" + string6);
                        dataOutputStream.writeBytes(string6);
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                        while ((string5 = bufferedReader.readLine()) != null) {
                            EMLog.d("CloudFileManager", "RESULT Message: " + string5);
                        }
                        bufferedReader.close();
                        dataOutputStream.close();
                        httpURLConnection.disconnect();
                        if (cloudOperationCallback != null) {
                            cloudOperationCallback.onSuccess(null);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (cloudOperationCallback == null) break block5;
                        cloudOperationCallback.onError(exception.toString());
                    }
                }
            }
        };
        thread.start();
    }
}

