/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.huawei.android.pushagent.api.PushManager;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMRandomDelay;
import com.hyphenate.chat.core.EMChatConfigPrivate;
import com.hyphenate.chat.core.a;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;
import com.xiaomi.mipush.sdk.MiPushClient;
import java.lang.reflect.Method;
import java.util.Random;
import org.json.JSONObject;

class EMPushHelper {
    public static final String TAG = EMPushHelper.class.getSimpleName();
    private static EMPushHelper instance;
    private Thread pushThread = null;
    private Object sendTokenLock = new Object();
    private String notifyDeviceToken;
    private boolean isLogout = false;
    private EMPushType pushType = EMPushType.NORMAL;

    EMPushHelper() {
    }

    public static EMPushHelper getInstance() {
        if (instance == null) {
            instance = new EMPushHelper();
        }
        return instance;
    }

    public void setPushType(EMPushType eMPushType) {
        this.pushType = eMPushType;
    }

    public EMPushType getPushType() {
        return this.pushType;
    }

    boolean checkAvailablePushService() {
        boolean bl = EMClient.getInstance().getChatConfigPrivate().j();
        EMLog.d(TAG, "GCM is enabled : " + bl);
        boolean bl2 = false;
        try {
            if (bl && Class.forName("com.google.android.gms.common.GooglePlayServicesUtil") != null) {
                int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)EMClient.getInstance().getContext());
                bl2 = n == 0;
                EMLog.d(TAG, "GCM service available : " + bl2);
                if (bl2) {
                    this.setPushType(EMPushType.GCM);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            EMLog.e(TAG, "" + classNotFoundException.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl2) {
            return bl2;
        }
        try {
            if (Class.forName("com.xiaomi.mipush.sdk.MiPushClient") != null) {
                bl2 = MiPushClient.shouldUseMIUIPush((Context)EMClient.getInstance().getContext());
                EMLog.d(TAG, "mipush available : " + bl2);
                if (bl2) {
                    this.setPushType(EMPushType.MIPUSH);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            EMLog.d(TAG, "no mipush sdk");
        }
        catch (Exception exception) {
            EMLog.d(TAG, "exception, regard it as no mipush sdk");
        }
        if (!bl2) {
            try {
                Class<?> clazz;
                Method method;
                String string;
                if (Class.forName("com.huawei.android.pushagent.api.PushManager") != null && !TextUtils.isEmpty((CharSequence)(string = (String)(method = (clazz = Class.forName("android.os.SystemProperties")).getDeclaredMethod("get", String.class)).invoke(clazz, "ro.build.version.emui")))) {
                    bl2 = true;
                    EMLog.d(TAG, "huawei push available : " + bl2);
                    this.setPushType(EMPushType.HUAWEIPUSH);
                }
            }
            catch (Exception exception) {
                EMLog.d(TAG, "no huawei push sdk or mobile is not a huawei phone");
            }
        }
        return bl2;
    }

    boolean isPushServiceEnabled() {
        return this.pushType != EMPushType.NORMAL;
    }

    void onInit() {
        this.isLogout = false;
    }

    void sendDeviceTokenToServer() {
        if (this.isPushServiceEnabled()) {
            EMLog.d(TAG, "third-party push available");
            if (this.isLogout) {
                return;
            }
            if (this.pushThread != null && this.pushThread.isAlive()) {
                return;
            }
            if (this.pushThread == null) {
                this.pushThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            class HandleSendFail {
                                HandleSendFail() {
                                }

                                void onSendFail() {
                                    EMPushHelper.this.setPushType(EMPushType.NORMAL);
                                    EMClient.getInstance().doStopService();
                                    EMClient.getInstance().doStartService();
                                }
                            }
                            int n;
                            String string = null;
                            for (n = 0; n < 3 && (string = EMPushHelper.this.getDeviceToken()) == null; ++n) {
                                try {
                                    1.sleep(new Random().nextInt(10) * 1000);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                if (!this.isInterrupted()) continue;
                                return;
                            }
                            if (string == null) {
                                new HandleSendFail().onSendFail();
                                return;
                            }
                            if (EMPushHelper.this.getPushToken() == null) {
                                n = 0;
                                for (int i = 0; i < 3 && (n = (int)(EMPushHelper.this.sendDeviceInfo(string) ? 1 : 0)) != 1; ++i) {
                                    try {
                                        1.sleep((20 + new Random().nextInt(10)) * 1000);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    if (!this.isInterrupted()) continue;
                                    return;
                                }
                                if (n == 0) {
                                    new HandleSendFail().onSendFail();
                                    return;
                                }
                            }
                            n = 0;
                            int n2 = 0;
                            EMRandomDelay eMRandomDelay = new EMRandomDelay();
                            while (n == 0 && (n = (int)(EMPushHelper.this.sendTokenToServer(string) ? 1 : 0)) != 1) {
                                try {
                                    1.sleep(eMRandomDelay.timeDelay(n2++) * 1000);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                if (!this.isInterrupted()) continue;
                                return;
                            }
                            if (n == 1) {
                                EMClient.getInstance().cancelJob();
                                EMClient.getInstance().doStopService();
                            }
                        }
                        catch (Exception exception) {
                            EMLog.e(TAG, exception.toString());
                        }
                    }
                };
                this.pushThread.start();
            }
        } else {
            EMLog.d(TAG, "GCM and mipush not available");
        }
    }

    public void onDestroy(boolean bl) throws HyphenateException {
        EMLog.d(TAG, "push notification helper ondestory");
        this.onReceiveToken(null);
        if (this.pushThread != null) {
            this.pushThread.interrupt();
            this.pushThread = null;
        }
        this.isLogout = true;
        if (bl && this.isPushServiceEnabled()) {
            boolean bl2 = this.sendTokenToServer("");
            if (!bl2) {
                EMLog.d(TAG, "unbind device token faild");
                throw new HyphenateException(212, "unbind device token failed");
            }
            this.setPushType(EMPushType.NORMAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onReceiveToken(String string) {
        this.notifyDeviceToken = string;
        Object object = this.sendTokenLock;
        synchronized (object) {
            try {
                this.sendTokenLock.notify();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendTokenToServer(String string) {
        Object object = this.sendTokenLock;
        synchronized (object) {
            String string2 = EMClient.getInstance().getChatConfigPrivate().f() + "/users/" + EMClient.getInstance().getCurrentUser();
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("device_token", (Object)string);
                String string3 = null;
                switch (this.pushType) {
                    case GCM: {
                        string3 = EMClient.getInstance().getOptions().getGCMNumber();
                        break;
                    }
                    case MIPUSH: {
                        string3 = EMClient.getInstance().getOptions().getMipushConfig().a;
                        break;
                    }
                    case HUAWEIPUSH: {
                        string3 = EMClient.getInstance().getOptions().getHuaweiPushAppId();
                    }
                }
                if (string3 == null) {
                    string3 = "";
                }
                jSONObject.put("notifier_name", (Object)string3);
                EMLog.d(TAG, "send device token to server, token = " + string + ",url = " + string2 + ",notifier_name = " + string3);
                Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string2, jSONObject.toString(), EMHttpClient.PUT);
                int n = (Integer)pair.first;
                String string4 = (String)pair.second;
                switch (n) {
                    case 200: {
                        EMLog.d(TAG, "sendTokenToServer SC_OK:");
                        return true;
                    }
                }
                EMLog.d(TAG, "sendTokenToServer error:" + string4);
            }
            catch (Exception exception) {
                EMLog.e(TAG, exception.toString());
            }
            return false;
        }
    }

    boolean sendDeviceInfo(String string) {
        String string2 = EMClient.getInstance().getChatConfigPrivate().f() + "/devices";
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("model", (Object)"android");
            jSONObject.put("name", (Object)string);
            jSONObject.put("token", (Object)string);
            jSONObject.put("sdk_version", (Object)EMClient.getInstance().getChatConfigPrivate().e());
            jSONObject.put("os_version", (Object)Build.VERSION.RELEASE);
            DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(EMClient.getInstance().getContext());
            String string3 = deviceUuidFactory.getDeviceUuid().toString();
            jSONObject.put("device_uuid", (Object)string3);
            Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequest(string2, null, jSONObject.toString(), EMHttpClient.POST);
            int n = (Integer)pair.first;
            String string4 = (String)pair.second;
            switch (n) {
                case 200: {
                    this.setPushToken(string);
                    EMLog.d(TAG, "sendDeviceToServer SC_OK:");
                    return true;
                }
            }
            if (string4.contains("duplicate_unique_property_exists")) {
                EMLog.d(TAG, "device token already exists");
                this.setPushToken(string);
                return true;
            }
            EMLog.d(TAG, "sendDeviceToServer error : " + string4);
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.toString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDeviceToken() {
        String string;
        block18: {
            string = this.getPushToken();
            if (string != null) {
                return string;
            }
            try {
                EMPushType eMPushType = this.getPushType();
                if (eMPushType == EMPushType.GCM) {
                    if (EMClient.getInstance().getOptions().getGCMNumber() != null) {
                        GoogleCloudMessaging googleCloudMessaging = null;
                        if (googleCloudMessaging == null) {
                            googleCloudMessaging = GoogleCloudMessaging.getInstance((Context)EMClient.getInstance().getContext());
                        }
                        string = googleCloudMessaging.register(new String[]{EMClient.getInstance().getOptions().getGCMNumber()});
                    }
                    break block18;
                }
                if (eMPushType == EMPushType.MIPUSH) {
                    EMChatConfigPrivate.a a2 = EMClient.getInstance().getOptions().getMipushConfig();
                    if (a2 == null) break block18;
                    MiPushClient.registerPush((Context)EMClient.getInstance().getContext(), (String)a2.a, (String)a2.b);
                    Object object = this.sendTokenLock;
                    synchronized (object) {
                        try {
                            this.sendTokenLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    string = this.notifyDeviceToken;
                    break block18;
                }
                if (eMPushType != EMPushType.HUAWEIPUSH) break block18;
                PushManager.requestToken((Context)EMClient.getInstance().getContext());
                Object object = this.sendTokenLock;
                synchronized (object) {
                    try {
                        this.sendTokenLock.wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                string = this.notifyDeviceToken;
            }
            catch (Exception exception) {
                EMLog.e(TAG, "get device token with error: " + exception.toString());
            }
        }
        EMLog.d(TAG, "devicetoken = " + string);
        if (string == null || "".equals(string)) {
            this.setPushType(EMPushType.NORMAL);
        }
        return string;
    }

    public String getPushToken() {
        return a.a().m();
    }

    public void setPushToken(String string) {
        a.a().d(string);
    }

    public static enum EMPushType {
        GCM,
        MIPUSH,
        HUAWEIPUSH,
        NORMAL;

    }
}

