/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.hyphenate.chat.EMClient;

public class EMPreferenceUtils {
    private static final String PREFERENCE_NAME = "hyphenate.sdk.pref";
    private static SharedPreferences mSharedPreferences;
    private static SharedPreferences.Editor mEditor;
    private static EMPreferenceUtils mPreferenceUtils;
    private static String SHARED_KEY_DDVERSION;
    private static String SHARED_KEY_DDXML;
    private static String SHARED_KEY_DDTIME;
    private static String VALID_BEFORE;
    private static String SCHEDULED_LOGOUT_TIME;
    private static String SHARED_KEY_GCM_ID;
    private long reservedLogoutTime = 0L;

    @SuppressLint(value={"CommitPrefEdits"})
    private EMPreferenceUtils(Context context) {
        mSharedPreferences = context.getSharedPreferences(PREFERENCE_NAME, 0);
        mEditor = mSharedPreferences.edit();
    }

    public static synchronized EMPreferenceUtils getInstance() {
        if (mPreferenceUtils == null) {
            mPreferenceUtils = new EMPreferenceUtils(EMClient.getInstance().getContext());
        }
        return mPreferenceUtils;
    }

    public void setDNSConfigVersion(String string) {
        mEditor.putString(SHARED_KEY_DDVERSION, string);
        mEditor.apply();
    }

    public void setDNSConfig(String string) {
        mEditor.putString(SHARED_KEY_DDXML, string);
        mEditor.apply();
    }

    public void setDNSConfigTime(long l) {
        mEditor.putLong(SHARED_KEY_DDTIME, l);
        mEditor.apply();
    }

    public void setDNSValidBefore(long l) {
        mEditor.putLong(VALID_BEFORE, l);
        mEditor.apply();
    }

    public long getDNSValidBefore() {
        return mSharedPreferences.getLong(VALID_BEFORE, -1L);
    }

    public String getDNSVersion() {
        return mSharedPreferences.getString(SHARED_KEY_DDVERSION, "");
    }

    public String getDNSConfig() {
        return mSharedPreferences.getString(SHARED_KEY_DDXML, "");
    }

    public long getDNSTime() {
        return mSharedPreferences.getLong(SHARED_KEY_DDTIME, -1L);
    }

    public boolean hasReservedLogoutTime() {
        if (this.reservedLogoutTime != 0L) {
            return true;
        }
        return mSharedPreferences.contains(SCHEDULED_LOGOUT_TIME);
    }

    public long getLogoutTime() {
        if (this.reservedLogoutTime != 0L) {
            return this.reservedLogoutTime;
        }
        this.reservedLogoutTime = mSharedPreferences.getLong(SCHEDULED_LOGOUT_TIME, -1L);
        return this.reservedLogoutTime;
    }

    public void setLogoutTime(long l) {
        this.reservedLogoutTime = l;
        mEditor.putLong(SCHEDULED_LOGOUT_TIME, l);
        mEditor.apply();
    }

    public void removeLogoutTime() {
        if (this.hasReservedLogoutTime()) {
            this.reservedLogoutTime = 0L;
            mEditor.remove(SCHEDULED_LOGOUT_TIME);
            mEditor.apply();
        }
    }

    public void setDebugServer(String string, String string2) {
        if (string == null && string2 == null) {
            mEditor.remove("debugIM");
            mEditor.remove("debugRest");
        } else {
            mEditor.putString("debugIM", string);
            mEditor.putString("debugRest", string2);
        }
        mEditor.apply();
    }

    public String getDebugIMAddress() {
        return mSharedPreferences.getString("debugIM", null);
    }

    public String getDebugRestAddress() {
        return mSharedPreferences.getString("debugRest", null);
    }

    public void setDebugAppkey(String string) {
        mEditor.putString("debugAppkey", string);
        mEditor.apply();
    }

    public String getDebugAppkey() {
        return mSharedPreferences.getString("debugAppkey", null);
    }

    public void setDebugMode(boolean bl) {
        mEditor.putString("debugMode", String.valueOf(bl));
        mEditor.apply();
    }

    public String getDebugMode() {
        return mSharedPreferences.getString("debugMode", null);
    }

    public void setGCMToken(String string) {
        mEditor.putString(SHARED_KEY_GCM_ID, string);
        mEditor.apply();
    }

    public String getGCMToken() {
        return mSharedPreferences.getString(SHARED_KEY_GCM_ID, null);
    }

    static {
        SHARED_KEY_DDVERSION = "shared_key_ddversion";
        SHARED_KEY_DDXML = "shared_key_ddxml";
        SHARED_KEY_DDTIME = "shared_key_ddtime";
        VALID_BEFORE = "valid_before";
        SCHEDULED_LOGOUT_TIME = "scheduled_logout_time";
        SHARED_KEY_GCM_ID = "shared_key_gcm_id";
    }

    public static class Token {
        String token;
        long savedTime;

        public Token() {
        }

        public Token(String string, long l) {
            this.token = string;
            this.savedTime = l;
        }

        public String getToken() {
            if (this.savedTime <= 0L) {
                this.token = null;
            }
            return this.token;
        }

        public Token setToken(String string) {
            this.token = string;
            return this;
        }

        public long getSavedTime() {
            return this.savedTime;
        }

        public Token setSavedTime(long l) {
            this.savedTime = l;
            return this;
        }
    }
}

