/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.cloud;

import java.util.Map;
import java.util.Properties;

import android.text.format.Time;

public abstract class CloudFileManager {
	
	protected Properties sessionContext;
	protected final static String TAG = "CloudFileManager";
	
	public static CloudFileManager instance = null;
	
	/**
	 * authorization process, put token, session or access key into sessionContext 
	 * @deprecated
	 * @return
	 */
	abstract public boolean authorization();
	
	/**
	 * generate unique remote file path from user id, file name, also app id
	 * user id, filename, timestamp
	 */
	public String getRemoteFileName(String userId, String fileName) {
		Time now = new Time();
		now.setToNow();
		String extension = fileName.substring(fileName.lastIndexOf("."), fileName.length());
		String fullName = userId + now.toString().substring(0, 15);
		//fullName = Base64.encodeToString(fullName.getBytes(), Base64.DEFAULT);
		return fullName + extension;
	}
		
	/*
	 * upload local file to cloud
	 */
	abstract public void uploadFileInBackground(String localFilePath, String remoteFilePath, String appId, String jid,Map<String,String> headers,CloudOperationCallback listener) ;
	
	/**
	 * download file from cloud to local storage
	 * @param filePath
	 * @return
	 */
	abstract public void downloadFile(String remoteFilePath, String localFilePath, String appId,Map<String,String> headers,CloudOperationCallback listener);
	
	/**
	 * use http delete to delete file
	 * @param remoteFilePath
	 * @param appId
	 * @param jid
	 * @param listener
	 * @deprecated
	 */
	abstract public void deleteFileInBackground(String remoteFilePath, String appId, String jid, CloudOperationCallback listener);

}
