/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import com.superrtc.sdk.RtcConnection;

public interface EMACallManagerListenerInterface {
    void onSendPushMessage(String from, String to);
    void onRecvCallFeatureUnsupported(EMACallSession session, EMAError error);    
    void onRecvCallIncoming(EMACallSession callSession);
    void onRecvCallConnected(EMACallSession callSession);
    void onRecvCallAccepted(EMACallSession callSession);
    void onRecvCallEnded(EMACallSession callSession, int endReasonOrdinal, EMAError error);
    
    void onRecvCallNetworkStatusChanged(EMACallSession callSession, int toStatus);
    void onRecvCallStateChanged(EMACallSession callSession, int StreamControlType);


    // this is C++ interface, but can not be implemented in java, use substitute method
    //virtual void onNewRtcConnection(const std::string& callId, const std::string& remoteName, EMCallRtcListener *listener, EMCallRtcInterface** outRtcImpl) = 0;
    void onNewRtcConnection(String callId, int mode, EMACallStream callStream, String to, 
            RtcConnection.Listener listener, EMACallRtcImpl rtcImpl);
    
    
    //  virtual void onConferenceInviteToEnter(EMCallSessionPtr callConference) = 0;
    void onConferenceMemberJoined(EMACallConference callConference, String enteredName);
    void onConferenceMemberLeaved(EMACallConference callConference, String exitedName);
    void onConferenceMemberPublished(EMACallConference callConference, String pubedName);
    void onConferenceMembersUpdated(EMACallConference callConference);
    
    void onConferenceStreamConnected(EMACallConference callSession, EMACallStream subedStream);
    void onConferenceStreamClosed(EMACallConference callSession, EMACallStream subedStream, EMAError error);
    void onConferenceClosed(EMACallConference callSession);

}
