/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.util;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.concurrent.Executor;

public class LooperExecutor
extends Thread
implements Executor {
    private static final String TAG = "LooperExecutor";
    private final Object looperStartedEvent = new Object();
    private Handler handler = null;
    private boolean running = false;
    private long threadId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Looper.prepare();
        Object object = this.looperStartedEvent;
        synchronized (object) {
            Log.d((String)TAG, (String)"Looper thread started.");
            this.handler = new Handler();
            this.threadId = Thread.currentThread().getId();
            this.looperStartedEvent.notify();
        }
        Looper.loop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void requestStart() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.handler = null;
        this.start();
        Object object = this.looperStartedEvent;
        synchronized (object) {
            while (true) {
                if (this.handler != null) {
                    return;
                }
                try {
                    this.looperStartedEvent.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.e((String)TAG, (String)"Can not start looper thread");
                    this.running = false;
                }
            }
        }
    }

    public synchronized void requestStop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                Looper.myLooper().quit();
                Log.d((String)LooperExecutor.TAG, (String)"Looper thread finished.");
            }
        });
    }

    public boolean checkOnLooperThread() {
        return Thread.currentThread().getId() == this.threadId;
    }

    @Override
    public synchronized void execute(Runnable runnable) {
        if (!this.running) {
            Log.w((String)TAG, (String)"Running looper executor without calling requestStart()");
            return;
        }
        this.handler.post(runnable);
    }
}

