/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMBase;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMLocationMessageBody;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.EMNormalFileMessageBody;
import com.hyphenate.chat.EMSessionManager;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.chat.adapter.EMACallback;
import com.hyphenate.chat.adapter.message.EMACmdMessageBody;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAImageMessageBody;
import com.hyphenate.chat.adapter.message.EMALocationMessageBody;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.chat.adapter.message.EMAMessageBody;
import com.hyphenate.chat.adapter.message.EMATextMessageBody;
import com.hyphenate.chat.adapter.message.EMAVideoMessageBody;
import com.hyphenate.chat.adapter.message.EMAVoiceMessageBody;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EMMessage
extends EMBase<EMAMessage>
implements Parcelable,
Cloneable {
    static final String ATTR_ENCRYPTED = "isencrypted";
    private static final String TAG = "msg";
    EMAMessage emaObject;
    EMMessageBody body;
    EMCallbackHolder messageStatusCallBack;
    public static final Parcelable.Creator<EMMessage> CREATOR = new Parcelable.Creator<EMMessage>(){

        public EMMessage createFromParcel(Parcel parcel) {
            return new EMMessage(parcel);
        }

        public EMMessage[] newArray(int n) {
            return new EMMessage[n];
        }
    };

    public Status status() {
        EMAMessage.EMAMessageStatus eMAMessageStatus = this.emaObject._status();
        Status status = Status.CREATE;
        if (eMAMessageStatus == EMAMessage.EMAMessageStatus.NEW) {
            status = Status.CREATE;
        } else if (eMAMessageStatus == EMAMessage.EMAMessageStatus.SUCCESS) {
            status = Status.SUCCESS;
        } else if (eMAMessageStatus == EMAMessage.EMAMessageStatus.FAIL) {
            status = Status.FAIL;
        } else if (eMAMessageStatus == EMAMessage.EMAMessageStatus.DELIVERING) {
            status = Status.INPROGRESS;
        }
        return status;
    }

    public EMMessage(EMAMessage eMAMessage) {
        this.emaObject = eMAMessage;
    }

    public void setStatus(Status status) {
        EMAMessage.EMAMessageStatus eMAMessageStatus = EMAMessage.EMAMessageStatus.SUCCESS;
        if (status == Status.CREATE) {
            eMAMessageStatus = EMAMessage.EMAMessageStatus.NEW;
        } else if (status == Status.SUCCESS) {
            eMAMessageStatus = EMAMessage.EMAMessageStatus.SUCCESS;
        } else if (status == Status.FAIL) {
            eMAMessageStatus = EMAMessage.EMAMessageStatus.FAIL;
        } else if (status == Status.INPROGRESS) {
            eMAMessageStatus = EMAMessage.EMAMessageStatus.DELIVERING;
        }
        this.emaObject.setStatus(eMAMessageStatus.ordinal());
    }

    public Type getType() {
        List<EMAMessageBody> list = this.emaObject.bodies();
        if (list.size() > 0) {
            int n = list.get(0).type();
            if (n == Type.TXT.ordinal()) {
                return Type.TXT;
            }
            if (n == Type.IMAGE.ordinal()) {
                return Type.IMAGE;
            }
            if (n == Type.CMD.ordinal()) {
                return Type.CMD;
            }
            if (n == Type.FILE.ordinal()) {
                return Type.FILE;
            }
            if (n == Type.VIDEO.ordinal()) {
                return Type.VIDEO;
            }
            if (n == Type.VOICE.ordinal()) {
                return Type.VOICE;
            }
            if (n == Type.LOCATION.ordinal()) {
                return Type.LOCATION;
            }
        }
        return Type.TXT;
    }

    public EMMessageBody getBody() {
        if (this.body != null) {
            return this.body;
        }
        List<EMAMessageBody> list = this.emaObject.bodies();
        if (list.size() > 0) {
            EMAMessageBody eMAMessageBody = list.get(0);
            if (eMAMessageBody instanceof EMATextMessageBody) {
                this.body = new EMTextMessageBody((EMATextMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMACmdMessageBody) {
                this.body = new EMCmdMessageBody((EMACmdMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMAVideoMessageBody) {
                this.body = new EMVideoMessageBody((EMAVideoMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMAVoiceMessageBody) {
                this.body = new EMVoiceMessageBody((EMAVoiceMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMAImageMessageBody) {
                this.body = new EMImageMessageBody((EMAImageMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMALocationMessageBody) {
                this.body = new EMLocationMessageBody((EMALocationMessageBody)eMAMessageBody);
            } else if (eMAMessageBody instanceof EMAFileMessageBody) {
                this.body = new EMNormalFileMessageBody((EMAFileMessageBody)eMAMessageBody);
            }
            return this.body;
        }
        return null;
    }

    public long getMsgTime() {
        return this.emaObject.timeStamp();
    }

    public void setMsgTime(long l) {
        this.emaObject.setTimeStamp(l);
    }

    public long localTime() {
        return this.emaObject.getLocalTime();
    }

    public void setLocalTime(long l) {
        this.emaObject.setLocalTime(l);
    }

    public static EMMessage createSendMessage(Type type) {
        EMAMessage eMAMessage = EMAMessage.createSendMessage(EMMessage.self(), "", null, ChatType.Chat.ordinal());
        EMMessage eMMessage = new EMMessage(eMAMessage);
        return eMMessage;
    }

    public static EMMessage createReceiveMessage(Type type) {
        EMAMessage eMAMessage = EMAMessage.createReceiveMessage("", EMMessage.self(), null, ChatType.Chat.ordinal());
        EMMessage eMMessage = new EMMessage(eMAMessage);
        eMMessage.setTo(EMSessionManager.getInstance().currentUser.getUsername());
        return eMMessage;
    }

    public static EMMessage createTxtSendMessage(String string, String string2) {
        String string3 = EMClient.getInstance().getCurrentUser();
        if (string3 == null) {
            string3 = EMSessionManager.getInstance().getLastLoginUser();
        }
        if (string.length() > 0) {
            EMMessage eMMessage = EMMessage.createSendMessage(Type.TXT);
            EMTextMessageBody eMTextMessageBody = new EMTextMessageBody(string);
            eMMessage.addBody(eMTextMessageBody);
            eMMessage.setTo(string2);
            return eMMessage;
        }
        EMLog.e(TAG, "text content size must be greater than 10");
        return null;
    }

    public static EMMessage createVoiceSendMessage(String string, int n, String string2) {
        if (!new File(string).exists()) {
            EMLog.e(TAG, "voice file does not exsit");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.VOICE);
        EMVoiceMessageBody eMVoiceMessageBody = new EMVoiceMessageBody(new File(string), n);
        eMMessage.addBody(eMVoiceMessageBody);
        eMMessage.setTo(string2);
        return eMMessage;
    }

    public static EMMessage createImageSendMessage(String string, boolean bl, String string2) {
        if (!new File(string).exists()) {
            EMLog.e(TAG, "image file does not exsit");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.IMAGE);
        eMMessage.setTo(string2);
        EMImageMessageBody eMImageMessageBody = new EMImageMessageBody(new File(string));
        eMImageMessageBody.setSendOriginalImage(bl);
        eMMessage.addBody(eMImageMessageBody);
        return eMMessage;
    }

    public static EMMessage createVideoSendMessage(String string, String string2, int n, String string3) {
        File file = new File(string);
        if (!file.exists()) {
            EMLog.e(TAG, "video file does not exist");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.VIDEO);
        eMMessage.setTo(string3);
        EMVideoMessageBody eMVideoMessageBody = new EMVideoMessageBody(string, string2, n, file.length());
        eMMessage.addBody(eMVideoMessageBody);
        return eMMessage;
    }

    public static EMMessage createLocationSendMessage(double d, double d2, String string, String string2) {
        EMMessage eMMessage = EMMessage.createSendMessage(Type.LOCATION);
        EMLocationMessageBody eMLocationMessageBody = new EMLocationMessageBody(string, d, d2);
        eMMessage.addBody(eMLocationMessageBody);
        eMMessage.setTo(string2);
        return eMMessage;
    }

    public static EMMessage createFileSendMessage(String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            EMLog.e(TAG, "file does not exist");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.FILE);
        eMMessage.setTo(string2);
        EMNormalFileMessageBody eMNormalFileMessageBody = new EMNormalFileMessageBody(new File(string));
        eMMessage.addBody(eMNormalFileMessageBody);
        return eMMessage;
    }

    public void addBody(EMMessageBody eMMessageBody) {
        this.body = eMMessageBody;
        this.emaObject.addBody(eMMessageBody.emaObject);
    }

    public String getFrom() {
        return this.emaObject.from();
    }

    public void setFrom(String string) {
        this.emaObject.setFrom(string);
        if (!EMMessage.self().equals(string)) {
            this.emaObject.setConversationId(string);
        }
    }

    public void setTo(String string) {
        this.emaObject.setTo(string);
        if (!EMMessage.self().equals(string)) {
            this.emaObject.setConversationId(string);
        }
    }

    public String getTo() {
        return this.emaObject.to();
    }

    public String getMsgId() {
        return this.emaObject.msgId();
    }

    public void setMsgId(String string) {
        this.emaObject.setMsgId(string);
    }

    synchronized void setInnerCallback(EMCallBack eMCallBack) {
        EMCallbackHolder eMCallbackHolder = this.messageStatusCallBack;
        if (eMCallbackHolder != null) {
            eMCallbackHolder.innerCallback = eMCallBack;
        } else {
            this.messageStatusCallBack = new EMCallbackHolder(null);
            this.messageStatusCallBack.innerCallback = eMCallBack;
        }
        this.setCallback(this.messageStatusCallBack);
    }

    public synchronized void setMessageStatusCallback(EMCallBack eMCallBack) {
        EMCallbackHolder eMCallbackHolder = this.messageStatusCallBack;
        if (eMCallbackHolder != null) {
            eMCallbackHolder.update(eMCallBack);
        } else {
            this.messageStatusCallBack = new EMCallbackHolder(eMCallBack);
        }
        this.setCallback(this.messageStatusCallBack);
    }

    void setCallback(final EMCallbackHolder eMCallbackHolder) {
        this.emaObject.setCallback(new EMACallback(new EMCallBack(){

            @Override
            public void onSuccess() {
                if (eMCallbackHolder != null) {
                    eMCallbackHolder.onSuccess();
                }
            }

            @Override
            public void onProgress(int n, String string) {
                if (eMCallbackHolder != null) {
                    eMCallbackHolder.onProgress(n, string);
                }
            }

            @Override
            public void onError(int n, String string) {
                if (eMCallbackHolder != null) {
                    eMCallbackHolder.onError(n, string);
                }
            }
        }));
    }

    void makeCallbackStrong() {
        EMCallbackHolder eMCallbackHolder = this.messageStatusCallBack;
        if (eMCallbackHolder != null) {
            eMCallbackHolder.makeItStrong();
        }
    }

    public String toString() {
        String string = "msg{from:" + this.getFrom() + ", to:" + this.getTo() + " body:" + this.getBody();
        return string;
    }

    public void setAttribute(String string, boolean bl) {
        if (string == null || string.equals("")) {
            return;
        }
        this.emaObject.setAttribute(string, bl);
    }

    public void setAttribute(String string, int n) {
        if (string == null || string.equals("")) {
            return;
        }
        this.emaObject.setAttribute(string, n);
    }

    public void setAttribute(String string, long l) {
        if (string == null || string.equals("")) {
            return;
        }
        this.emaObject.setAttribute(string, l);
    }

    public void setAttribute(String string, JSONObject jSONObject) {
        if (string == null || string.equals("")) {
            return;
        }
        this.emaObject.setJsonAttribute(string, jSONObject.toString());
    }

    public void setAttribute(String string, JSONArray jSONArray) {
        if (string == null || string.equals("")) {
            return;
        }
        this.emaObject.setJsonAttribute(string, jSONArray.toString());
    }

    public void setAttribute(String string, String string2) {
        if (string == null || string.equals("")) {
            return;
        }
        this.emaObject.setAttribute(string, string2);
    }

    public boolean getBooleanAttribute(String string) throws HyphenateException {
        if (string == null || string.equals("")) {
            throw new HyphenateException("attribute " + string + " can not be null or empty");
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        boolean bl = this.emaObject.getBooleanAttribute(string, false, atomicBoolean);
        if (!bl) {
            throw new HyphenateException("attribute " + string + " not found");
        }
        return atomicBoolean.get();
    }

    public boolean getBooleanAttribute(String string, boolean bl) {
        if (string == null || string.equals("")) {
            return bl;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        boolean bl2 = this.emaObject.getBooleanAttribute(string, false, atomicBoolean);
        if (!bl2) {
            return bl;
        }
        return atomicBoolean.get();
    }

    public int getIntAttribute(String string, int n) {
        if (string == null || string.equals("")) {
            return n;
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        boolean bl = this.emaObject.getIntAttribute(string, -1, atomicInteger);
        if (!bl) {
            return n;
        }
        return atomicInteger.intValue();
    }

    public long getLongAttribute(String string, long l) {
        if (string == null || string.equals("")) {
            return l;
        }
        AtomicLong atomicLong = new AtomicLong();
        boolean bl = this.emaObject.getLongAttribute(string, -1L, atomicLong);
        if (!bl) {
            return l;
        }
        return atomicLong.longValue();
    }

    public int getIntAttribute(String string) throws HyphenateException {
        if (string == null || string.equals("")) {
            throw new HyphenateException("attribute " + string + " can not be null or empty");
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        boolean bl = this.emaObject.getIntAttribute(string, -1, atomicInteger);
        if (!bl) {
            throw new HyphenateException("attribute " + string + " not found");
        }
        return atomicInteger.intValue();
    }

    public long getLongAttribute(String string) throws HyphenateException {
        if (string == null || string.equals("")) {
            throw new HyphenateException("attribute " + string + " can not be null or empty");
        }
        AtomicLong atomicLong = new AtomicLong();
        boolean bl = this.emaObject.getLongAttribute(string, -1L, atomicLong);
        if (!bl) {
            throw new HyphenateException("attribute " + string + " not found");
        }
        return atomicLong.longValue();
    }

    public String getStringAttribute(String string) throws HyphenateException {
        if (string == null || string.equals("")) {
            throw new HyphenateException("attribute " + string + " can not be null or empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.emaObject.getStringAttribute(string, "", stringBuilder);
        if (!bl) {
            throw new HyphenateException("attribute " + string + " not found");
        }
        return stringBuilder.toString();
    }

    public String getStringAttribute(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.emaObject.getStringAttribute(string, "", stringBuilder);
        if (!bl) {
            return string2;
        }
        return stringBuilder.toString();
    }

    public JSONObject getJSONObjectAttribute(String string) throws HyphenateException {
        if (string == null || string.equals("")) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.emaObject.getJsonAttribute(string, "{}", stringBuilder);
        if (bl) {
            try {
                JSONObject jSONObject = new JSONObject(stringBuilder.toString());
                return jSONObject;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        throw new HyphenateException("attribute " + string + " not found");
    }

    public JSONArray getJSONArrayAttribute(String string) throws HyphenateException {
        if (string == null || string.equals("")) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.emaObject.getJsonAttribute(string, "[]", stringBuilder);
        if (bl) {
            try {
                JSONArray jSONArray = new JSONArray(stringBuilder.toString());
                return jSONArray;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        throw new HyphenateException("attribute " + string + " not found");
    }

    public ChatType getChatType() {
        EMAMessage.EMAChatType eMAChatType = this.emaObject.chatType();
        ChatType chatType = ChatType.Chat;
        chatType = eMAChatType == EMAMessage.EMAChatType.SINGLE ? ChatType.Chat : (eMAChatType == EMAMessage.EMAChatType.GROUP ? ChatType.GroupChat : ChatType.ChatRoom);
        return chatType;
    }

    public void setChatType(ChatType chatType) {
        EMAMessage.EMAChatType eMAChatType = EMAMessage.EMAChatType.SINGLE;
        eMAChatType = chatType == ChatType.Chat ? EMAMessage.EMAChatType.SINGLE : (chatType == ChatType.GroupChat ? EMAMessage.EMAChatType.GROUP : EMAMessage.EMAChatType.CHATROOM);
        this.emaObject.setChatType(eMAChatType);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.getMsgId());
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean isAcked() {
        return this.emaObject.isAcked();
    }

    public void setAcked(boolean bl) {
        this.emaObject.setIsAcked(bl);
    }

    public boolean isDelivered() {
        return this.emaObject.isDeliverAcked();
    }

    public void setDelivered(boolean bl) {
        this.emaObject.setIsDeliverAcked(bl);
    }

    public boolean isUnread() {
        return !this.emaObject.isRead();
    }

    public void setUnread(boolean bl) {
        this.emaObject.setIsRead(!bl);
    }

    public boolean isListened() {
        return this.emaObject.isListened();
    }

    public void setListened(boolean bl) {
        this.emaObject.setListened(bl);
    }

    public String getUserName() {
        String string = "";
        string = this.getFrom() != null && this.getFrom().equals(EMClient.getInstance().getCurrentUser()) ? this.getTo() : this.getFrom();
        return string;
    }

    public void setDeliverAcked(boolean bl) {
        this.emaObject.setIsDeliverAcked(bl);
    }

    public int progress() {
        return this.emaObject.progress();
    }

    public void setProgress(int n) {
        this.emaObject.setProgress(n);
    }

    public Direct direct() {
        if (this.emaObject.direction() == EMAMessage.EMADirection.SEND) {
            return Direct.SEND;
        }
        return Direct.RECEIVE;
    }

    public void setDirection(Direct direct) {
        this.emaObject.setDirection(direct.ordinal());
    }

    String conversationId() {
        return this.emaObject.conversationId();
    }

    static String self() {
        String string = EMClient.getInstance().getCurrentUser();
        if (string == null) {
            string = EMSessionManager.getInstance().getLastLoginUser();
        }
        return string;
    }

    private EMMessage(Parcel parcel) {
        String string = parcel.readString();
        EMMessage eMMessage = EMClient.getInstance().chatManager().getMessage(string);
        this.emaObject = eMMessage == null ? null : eMMessage.emaObject;
    }

    public Map<String, Object> ext() {
        return this.emaObject.ext();
    }

    static class EMCallbackHolder
    implements EMCallBack {
        private EMCallBack strong;
        private WeakReference<EMCallBack> weak;
        EMCallBack innerCallback = null;

        EMCallbackHolder(EMCallBack eMCallBack) {
            this.weak = new WeakReference<EMCallBack>(eMCallBack);
        }

        synchronized void update(EMCallBack eMCallBack) {
            if (this.strong != null) {
                this.strong = eMCallBack;
                return;
            }
            this.weak = new WeakReference<EMCallBack>(eMCallBack);
        }

        synchronized void makeItStrong() {
            if (this.strong != null) {
                return;
            }
            if (this.weak != null && this.weak.get() != null) {
                this.strong = (EMCallBack)this.weak.get();
            }
        }

        synchronized void release() {
            if (this.strong == null) {
                return;
            }
            this.weak = new WeakReference<EMCallBack>(this.strong);
            this.strong = null;
        }

        synchronized EMCallBack getRef() {
            if (this.strong != null) {
                return this.strong;
            }
            if (this.weak != null) {
                EMCallBack eMCallBack = (EMCallBack)this.weak.get();
                if (eMCallBack == null) {
                    EMLog.d(EMMessage.TAG, "getRef weak:" + eMCallBack);
                }
                return eMCallBack;
            }
            return null;
        }

        @Override
        public void onSuccess() {
            EMCallBack eMCallBack;
            if (this.innerCallback != null) {
                this.innerCallback.onSuccess();
            }
            if ((eMCallBack = this.getRef()) != null) {
                eMCallBack.onSuccess();
                this.release();
            } else {
                EMLog.d(EMMessage.TAG, "CallbackHolder getRef: null");
            }
        }

        @Override
        public void onError(int n, String string) {
            EMCallBack eMCallBack;
            if (this.innerCallback != null) {
                this.innerCallback.onError(n, string);
            }
            if ((eMCallBack = this.getRef()) != null) {
                eMCallBack.onError(n, string);
                this.release();
            } else {
                EMLog.d(EMMessage.TAG, "CallbackHolder getRef: null");
            }
        }

        @Override
        public void onProgress(int n, String string) {
            EMCallBack eMCallBack;
            if (this.innerCallback != null) {
                this.innerCallback.onProgress(n, string);
            }
            if ((eMCallBack = this.getRef()) != null) {
                eMCallBack.onProgress(n, string);
            }
        }
    }

    public static enum ChatType {
        Chat,
        GroupChat,
        ChatRoom;

    }

    public static enum Status {
        SUCCESS,
        FAIL,
        INPROGRESS,
        CREATE;

    }

    public static enum Direct {
        SEND,
        RECEIVE;

    }

    public static enum Type {
        TXT,
        IMAGE,
        VIDEO,
        LOCATION,
        VOICE,
        FILE,
        CMD;

    }
}

