/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.cloud;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import com.hyphenate.EMError;
import com.hyphenate.chat.EMClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EMPrivateConstant;
import com.hyphenate.util.NetUtils;

import android.util.Pair;

/**
 * httpclient请求，支持Https
 * @author lyuzhao
 * @deprecated 此类是内部类，请谨慎调用，请用EMChatManager提供的API进行替代
 */
public class HttpClientManager {
	private static final String TAG = "HttpClientManager";
    public static String Method_GET = "GET";
	public static String Method_POST = "POST";
	public static String Method_PUT = "PUT";
	public static String Method_DELETE = "DELETE";
	public static final int max_retries_times_on_connection_refused = 3;

	private static volatile long retrivedTokenTime = 0; 
	private static final int retriveInterval = 2 * 60 * 1000; //2 minute interval
	private static volatile boolean isRetring = false;
	
	/**
	 * Send SSL Request
	 * 
	 * @param reqURL
	 * @param token
	 * @param str
	 * @return
	 * @throws HyphenateException
	 * @throws KeyStoreException
	 * @throws IOException
	 * @throws CertificateException
	 * @throws NoSuchAlgorithmException
	 * @throws UnrecoverableKeyException
	 * @throws KeyManagementException
	 * @deprecated this API is deprecated, please use {@link #sendRequest(String, Map, String, String)}
	 */
	public static String sendHttpRequest(final String reqURL, final Map<String, String> headers, final String body, final String method) throws HyphenateException, IOException{
		String responseContent = null;
		IOException ioe = null;
		HyphenateException eme = null;
		
		String url = reqURL;
		for(int i = 0; i < max_retries_times_on_connection_refused; i++){
			EMLog.d(TAG, "try send request, request url: " + url + " with number: " + i);
			ioe = null;
			eme = null;
			
			try{
				responseContent = sendHttpRequestWithCountDown(url,headers,body,method);
			}catch(IOException e){
				ioe = e;
			}catch(HyphenateException e){
				eme = e;
			}
			
			if (responseContent != null) {
			    break;
			}
			url = getNewHost(reqURL, EMHttpClient.getInstance().chatConfig().getNextAvailableBaseUrl());
		}
		
		if(ioe != null){
			throw ioe;
		}else if( eme != null){
			throw eme;
		}
		
		return responseContent;
	}
	
	public static Pair<Integer, String> sendRequestWithToken(String url, String body, String method) throws HyphenateException{
		Map<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
        
        try {
			return sendHttpRequestWithRetryToken(url,headers,body,method);
		} catch (IOException e) {
			String errorMsg = " send request : " + url + " failed!";
			
			if(e != null && e.toString() != null){
				errorMsg = e.toString();
			}
			
			EMLog.d(TAG, errorMsg);
			
			throw new HyphenateException(EMError.GENERAL_ERROR,errorMsg);
		}
   	}
	
	/**
	 * send http request with retry get token if it was overdue
	 * @param reqURL
	 * @param headers
	 * @param body
	 * @param method
	 * @return return a pair which contains int statusCode and string response content 
	 * @throws HyphenateException
	 * @throws IOException
	 */
	static Pair<Integer, String> sendHttpRequestWithRetryToken(final String reqURL, final Map<String, String> headers, final String body, final String method) throws HyphenateException, IOException{
	    Pair<Integer, String> result = sendRequest(reqURL, headers, body, method);
        
        //token过期
        if(result != null && result.first == 401){
            String token = null;
            long currentTime = System.currentTimeMillis();
            //间隔大于规定间隔时间并且当前不在取token
            if((currentTime - retrivedTokenTime) > retriveInterval && !isRetring){
                isRetring = true;
                token = EMClient.getInstance().getOptions().getAccessToken(true);
                isRetring = false;
                retrivedTokenTime = System.currentTimeMillis();
                if(token != null){
                    headers.put("Authorization", "Bearer " + token);
                    result = sendRequest(reqURL, headers, body, method);
                }
            }
        }
            
	    return result;
	}
	
	

	public static Pair<Integer,String> sendRequest(final String reqURL, final Map<String, String> headers, final String body, final String method) throws IOException, HyphenateException{
		Pair<Integer,String> value = null;
		IOException ioe = null;
		HyphenateException eme = null;
		
		String url = reqURL;
		for(int i = 0; i < max_retries_times_on_connection_refused; i++){
			EMLog.d(TAG, "try send request, request url: " + url + " with number: " + i);
			ioe = null;
			eme = null;
			Exception ex = null;
			
			try{
				HttpResponse response = sendRequestWithCountDown(url,headers,body,method);
				HttpEntity entity = response.getEntity();

				if (null != entity) {
					String content = EntityUtils.toString(entity, "UTF-8");
					
					value = new Pair<Integer, String>(response.getStatusLine().getStatusCode(),content);
				}
			}catch(IOException e){
				ioe = e;
				ex = e;
			}catch(HyphenateException e){
				eme = e;
				ex =e;
			}
			
			String errorMsg = "failed to send request, request url: " + reqURL;
			
			if(ex != null){
				if(ex.getMessage() != null){
					errorMsg = ex.getMessage();
				}else if(ex.toString() != null){
					errorMsg = ex.toString();
				}
			}

//			if(EMInternalConfigManager.getInstance().dnsRestResolverEnabled()){
	            if(errorMsg.toLowerCase().contains(EMPrivateConstant.CONNECTION_REFUSED) && NetUtils.hasNetwork(EMClient.getInstance().getContext())){
	    			url = getNewHost(reqURL, EMHttpClient.getInstance().chatConfig().getNextAvailableBaseUrl());
                }else{
                	break;
                }
//	        }else{
//	        	break;
//	        }
		}
		
		if(ioe != null){
			throw ioe;
		}else if( eme != null){
			throw eme;
		}
		
		return value;
	}
	
	private static HttpResponse sendRequestWithCountDown(final String reqURL, final Map<String, String> headers, final String body, final String method) throws HyphenateException, IOException{
		HttpResponse response = null;
		try {
			response = getHttpResponse(reqURL, headers, body, method);
		}catch(IOException e){
		    throw e;
		}catch (Exception e) {
			if(e != null){
				e.printStackTrace();
			}
			
		    String errorMsg = "http request failed : " + reqURL;
		    if(e != null && e.toString() != null){
		        errorMsg = e.toString();
		    }

		    
			if (errorMsg.contains("Unable to resolve host")) {
				throw new HyphenateException(EMError.NETWORK_ERROR, "Unable to resolve host");
			} else {
			    throw new HyphenateException(EMError.SERVER_NOT_REACHABLE, errorMsg);
		    }
		}

		return response;
	}
	
	private static String sendHttpRequestWithCountDown(final String reqURL, final Map<String, String> headers, final String body, final String method) throws HyphenateException, IOException{
		String responseContent = null;
		try {
			HttpResponse response = getHttpResponse(reqURL, headers, body, method);
			HttpEntity entity = response.getEntity();

			if (null != entity) {
				responseContent = EntityUtils.toString(entity, "UTF-8");
			}
		}catch(IOException e){
		    throw e;
		}catch (Exception e) {
			if(e != null){
				e.printStackTrace();
			}
			
		    String errorMsg = "http request failed : " + reqURL;
		    
		    if(e != null && e.toString() != null){
		        errorMsg = e.toString();
		    }

			if (errorMsg.contains("Unable to resolve host")) {
                throw new HyphenateException(EMError.NETWORK_ERROR, "Unable to resolve host");
			} else {
		        throw new HyphenateException(EMError.SERVER_NOT_REACHABLE, errorMsg);
		    }
		}
		
		return responseContent;
	}

//    static String getNewHost(final String reqURL, EMSelectedHost selectedHost) {
//        String host = selectedHost.host;
//        int port = selectedHost.port;
//        String protocol = selectedHost.protocol;
//        
//        String baseUrl = protocol + "://" + host + ":" + port;
//        String s = reqURL.substring(reqURL.indexOf("/", 8));
//        String url = baseUrl + s;
//        return url;
//    }
    
    static String getNewHost(final String reqUrl, final String baseUrl) {
        String s = reqUrl.substring(reqUrl.indexOf("/", 8));	// trim base part
        s = s.substring(s.indexOf("/", 1));						// trim appkey_pre#
        s = s.substring(s.indexOf("/", 1));						// trim #appkey_post
		return baseUrl + s;
    }

    static Map<String,String> addDomainToHeaders(Map<String,String> headers){
//    	if(EMInternalConfigManager.getInstance().dnsRestResolverEnabled()){
//    		EMSelectedHost host = EMDNSManager.getInstance().getCurrentRestHost();
//    		
//    		if(host != null 
//			&& host.dnsHost != null
//			&& host.protocol != null
//			&& host.protocol.contains("https")
//			&& host.dnsHost.domain != null
//			&& !host.dnsHost.domain.trim().equals("")){
//    			if(headers == null){
//    				headers = new HashMap<String,String>();
//    			}
//    			
//    			headers.put("Host", host.dnsHost.domain);	
//    		}	
//    	}
		// TODO: jni
		return headers;
    }

    static void checkAndProcessSSL(String url, DefaultHttpClient client) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, KeyManagementException, UnrecoverableKeyException{
    }
    
    /**
     * 
     * @param reqURL
     * @param headers
     * @param body
     * @param method
     * @return
     * @throws KeyStoreException
     * @throws KeyManagementException
     * @throws UnrecoverableKeyException
     * @throws NoSuchAlgorithmException
     * @throws CertificateException
     * @throws IOException
     */
	public static HttpResponse getHttpResponse(String reqURL, Map<String, String> headers, String body, String method)
			throws KeyStoreException, KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException,
			IOException {		
		headers = addDomainToHeaders(headers);

        return httpExecute(reqURL,headers,body,method);
	}
	
    public static HttpResponse httpExecute(String reqURL, Map<String, String> headers, String body, String method) throws ClientProtocolException, IOException, KeyStoreException, KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException{
    	HttpResponse response = null;
    	
    	int timeout = HttpClientConfig.getTimeout(headers);
    	
        HttpClient httpClient = HttpClientConfig.getDefaultHttpClient(timeout);
		
		HttpRequestBase request = null;
		
    	if (method.equals(Method_POST)) {
			HttpPost httpPost = new HttpPost(reqURL);
			httpPost.setEntity(new StringEntity(body, "UTF-8"));
			request = httpPost;
		} else if (method.equals(Method_PUT)) {
			HttpPut httpPut = new HttpPut(reqURL);
			httpPut.setEntity(new StringEntity(body, "UTF-8"));
			request = httpPut;
		} else if (method.equals(Method_GET)) {
			request = new HttpGet(reqURL);
		} else if (method.equals(Method_DELETE)) {
			request = new HttpDelete(reqURL);
		}
    	
    	if(request != null){
    		if (headers != null) {
    			for (Entry<String, String> item : headers.entrySet()) {
    				request.setHeader(item.getKey(), item.getValue());
    			}
    		}
    		
    		response = httpClient.execute(request);
    	}
    	
		return response;
    }
}
