/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import java.util.List;

public interface EMAChatRoomManagerListenerInterface {
  /**
    * \brief Callback user when user is kicked out from a chatroom or the chatroom is destroyed.
    *
    * @param chatroom The chatroom that user left.
    * @param leaveReason The leave reason.
    * @return NA
    */
  void onLeaveChatRoom(EMAChatRoom chatroom, int leaveReason);
  
  /**
    * \brief Callback user when a user join the chatroom.
    *
    * @param chatroom The chatroom that user joined.
    * @param member The member.
    * @return NA
    */
  void onMemberJoinedChatRoom(EMAChatRoom chatroom, String member);
  
  /**
    * \brief Callback user when a user leave the chatroom.
    *
    * @param chatroom The chatroom that user left.
    * @param member The member.
    * @return NA
    */
  void onMemberLeftChatRoom(EMAChatRoom chatroom, String member);


  // ============================= group_reform new add api begin
  /**
   * \brief Callback user when user add to chat room mute list.
   *
   * @param  chatRoom The chat room that take action
   * @param mutes entry key is user who was added into chat room mute list,
   *              entry value is mute time
   * @return NA
   */
  void onAddMuteList(EMAChatRoom chatRoom, List<String> mutes, long duration);

  /**
   * \brief Callback user when user remove from chat room mute list.
   *
   * @param  chatRoom The chat room that take action
   * @param mutes  users who was removed from chat room mute list
   * @return NA
   */
  void onRemoveMutes(EMAChatRoom chatRoom, List<String> mutes);

  /**
   * \brief Callback user when user promote to admin.
   *
   * @param  chatRoom The chat room that take action
   * @param  admin member whom got administrator privilege.
   * @return NA
   */
  void onAddAdmin(EMAChatRoom chatRoom, String admin);

  /**
   * \brief Callback user when user cancel admin.
   *
   * @param  chatRoom The chat room that take action
   * @param  admin member who was deprived administrator privilege.
   * @return NA
   */
  void onRemoveAdmin(EMAChatRoom chatRoom, String admin);

  /**
   * \brief Callback user when promote to chat room owner.
   *
   * @param chatRoom The chat room that take action
   * @param newOwner transfer ownership to
   * @return NA
   */
  void onOwnerChanged(EMAChatRoom chatRoom, String newOwner, String oldOwner);

  // ============================= group_reform new add api end

}
