/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

/**
 * Easemob Adapter
 * @author linan
 *
 */
public class EMAChatClient extends EMABase {
	
	public static EMAChatClient create(EMAChatConfig chatConfig) {
		EMAChatClient obj = new EMAChatClient();
		obj.nativeHandler = native_create(chatConfig);
		
		if (obj.getChatManager() == null) {
			obj.chatManager = new EMAChatManager();
			obj.getChatManager().nativeHandler = obj.native_getChatManager();
		}
		
		if (obj.getChatRoomManager() == null) {
			obj.chatRoomManager = new EMAChatRoomManager();
			obj.getChatRoomManager().nativeHandler = obj.native_getChatRoomManager();
		}

		if (obj.getCallManager() == null) {
			obj.callManager = new EMACallManager();
			obj.getCallManager().nativeHandler = obj.native_getCallManager();
		}
		
		if (obj.getGroupManager() == null) {
			obj.groupManager = new EMAGroupManager();
			obj.getGroupManager().nativeHandler = obj.native_getGroupManager();
		}
		
		if (obj.getContactManager() == null) {
			obj.contactManager = new EMAContactManager();
			obj.getContactManager().nativeHandler = obj.native_getContactManager();
		}

		if (obj.getPushMnager() == null) {
			obj.pushManager = new EMAPushManager();
			obj.getPushMnager().nativeHandler = obj.native_getPushManager();
		}
		return obj;
	}
	
	public void login(String username, String password, EMAError error) {
		native_login(username, password, error);
	}
	
	public void autoLogin(String username, String password, EMAError error) {
		native_autoLogin(username, password, error);
	}

	public void loginWithToken(String username, String token, EMAError error) {
		native_loginWithToken(username, token, error);
	}
	
	public void logout() {
		native_logout();
	}
	
	public EMAError createAccount(String username, String password) {
		return native_createAccount(username, password); 
	}

	public EMAError changeAppkey(String appkey) {
	    return native_changeAppkey(appkey);
	}
	
	public EMAChatManager getChatManager() {
		return chatManager;
	}

	public EMAChatRoomManager getChatRoomManager() {
		return chatRoomManager;
	}

	public EMACallManager getCallManager() {
		return callManager;
	}
	
	public EMAGroupManager getGroupManager() {
		return groupManager;
	}

	public EMAPushManager getPushMnager() {
		return pushManager;
	}

	public EMAContactManager getContactManager() {
		return contactManager;
	}
	
	public void addConnectionListener(EMAConnectionListener listener) {
		native_addConnectionListener(listener);
	}
	
	public void removeConnectionListener(EMAConnectionListener listener) {
		native_removeConnectionListener(listener);
	}

	public boolean sendPing(boolean waitPong, long timeout){
		return native_sendPing(waitPong,timeout);
	}
	
	public void disconnect(){
		native_disconnect();
	}
	
	public void reconnect(){
		natvie_reconnect();
	}
	
	public void onNetworkChanged(EMANetwork network) {
	    native_onNetworkChanged(network.ordinal());
	}
	
	public boolean isConnected(){
		return native_isConnected();
	}

	public void setPresence(String location) { native_setPresence(location); }

	public String compressLogs(EMAError error) {
		return native_compressLogs(error);
	}

	native static long native_create(EMAChatConfig chatConfig);
	native EMAError native_createAccount(String username, String password);
	native void native_login(String username, String password, EMAError error);
	native void native_autoLogin(String username, String password, EMAError error);
	native void native_loginWithToken(String username, String token, EMAError error);
	native void native_logout();
	native EMAError native_changeAppkey(String appkey);
	native long native_getChatManager();
	native long native_getCallManager();
	native long native_getGroupManager();
	native long native_getContactManager();
	native long native_getChatRoomManager();
	native long native_getPushManager();
	native void native_onNetworkChanged(int network);

	public enum EMANetwork {
	    NETWORK_NONE,
	    NETWORK_CABLE,
	    NETWORK_WIFI,
	    NETWORK_MOBILE
	}

	native void native_addConnectionListener(EMAConnectionListener listener);
	native void native_removeConnectionListener(EMAConnectionListener listener);
	native boolean native_sendPing(boolean waitPong, long timeout);
	native void native_disconnect();
	native void natvie_reconnect();
	native boolean native_isConnected();
	native void native_setPresence(String location);
	native String native_compressLogs(EMAError error);

	private EMAChatManager chatManager = null;
	private EMAChatRoomManager chatRoomManager = null;
	private EMACallManager callManager = null;
	private EMAGroupManager groupManager = null;
	private EMAContactManager contactManager = null;
	private EMAPushManager pushManager = null;
	
}
