/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;

import com.hyphenate.chat.adapter.message.EMAFileMessageBody.EMADownloadStatus;
import com.hyphenate.chat.adapter.message.EMAMessageBody;
import com.hyphenate.chat.adapter.message.EMAVideoMessageBody;
import com.hyphenate.util.EMLog;

/**
 * \~chinese
 * 视频消息体
 * 
 * <pre>
 * EMVideoMessageBody body = new EMVideoMessageBody(videoFilePath,thumbPath, duration,filelength);
 * </pre>
 * 
 * \~english
 * the video message body class
 * <pre>
 * EMVideoMessageBody body = new EMVideoMessageBody(videoFilePath,thumbPath, duration,filelength);
 * </pre>
 */
public class EMVideoMessageBody extends EMFileMessageBody implements Parcelable {

	public EMVideoMessageBody() {
		super("", EMAMessageBody.EMAMessageBodyType_VIDEO);
	}
	
	public EMVideoMessageBody(EMAVideoMessageBody body) {
		super(body);
	}

	/**
	 * \~chinese
	 * 创建一个视频消息体
	 * 
	 * @param videoFilePath
	 *            视频文件路径
	 * @param thumbPath 预览图路径
	 * @param duration 视频时间
	 * @param filelength 视频文件长度
	 * 
	 * \~english
	 * create a video message body
	 * @param videoFilePath the path of the video file
     * @param thumbPath the path of the video first frame
     * @param duration video duration,unit s
     * @param filelength the length of the video file
	 * 
	 */
	public EMVideoMessageBody(String videoFilePath,String thumbPath, int duration,long filelength) {
		super(videoFilePath, EMAMessageBody.EMAMessageBodyType_VIDEO);
		((EMAVideoMessageBody)emaObject).setThumbnailLocalPath(thumbPath);
		((EMAVideoMessageBody)emaObject).setDuration(duration);
		((EMAVideoMessageBody)emaObject).setFileLength(filelength);
		EMLog.d("videomsg", "create video,message body for:" + videoFilePath);
	}

    /**
     * create video message body from incoming xmpp message json
     */
	EMVideoMessageBody(String fileName, String remoteUrl, String thumbnailUrl, int length) {
    	super(fileName, EMAMessageBody.EMAMessageBodyType_VIDEO);
    	((EMAVideoMessageBody)emaObject).setThumbnailLocalPath(thumbnailUrl);
    	((EMAVideoMessageBody)emaObject).setLocalPath(fileName);
    	((EMAVideoMessageBody)emaObject).setRemotePath(remoteUrl);
    	((EMAVideoMessageBody)emaObject).setThumbnailRemotePath(thumbnailUrl);
    	((EMAVideoMessageBody)emaObject).setFileLength(length);
    }
    
	/**
	 * \~chinese
	 * 获取缩略图的url <li>接受消息时，sdk会自动下载缩略图，存储到本地</li>
	 * 
	 * @return
	 * 
	 * \~english
	 * get the thumbnail url
	 * @return
	 */
	public String getThumbnailUrl() {
		return ((EMAVideoMessageBody)emaObject).thumbnailRemotePath();
	}

	public void setThumbnailUrl(String thumbnailUrl) {
		((EMAVideoMessageBody)emaObject).setThumbnailRemotePath(thumbnailUrl);
	}
	
	
	/**
	 * \~chinese
	 * 获取视频文件的文件大小
	 * @return
	 * 
	 * \~english
	 * get the video file length
	 * @return
	 */
	public long getVideoFileLength(){
		return ((EMAVideoMessageBody)emaObject).fileLength();
	}
	
	
	public void setVideoFileLength(long filelength) {
		((EMAVideoMessageBody)emaObject).setFileLength(filelength);
	}
	
	
	public void setLocalThumb(String localThumbPath) {
		((EMAVideoMessageBody)emaObject).setThumbnailLocalPath(localThumbPath);
	}

	/**
	 * \~chinese
	 * 获取本地Video缩略图
	 * @return
	 * 
	 * \~english
	 * get the local thumbnail
	 * @return
	 */
	public String getLocalThumb() {
//		if(!TextUtils.isEmpty(localThumb)&&new File(localThumb).exists())
//		{
//			return localThumb;
//		}
//		else if(!TextUtils.isEmpty(thumbnailUrl)&&!thumbnailUrl.equals("null")){
//			String fileName="th" + thumbnailUrl.substring(thumbnailUrl.lastIndexOf("/")+1, thumbnailUrl.length());
//        	File localThumbFile=new File(PathUtil.getInstance().getVideoPath(), fileName);
//			if(localThumbFile.exists())
//			{
//				return localThumbFile.getAbsolutePath();
//			}
//		}else if(!TextUtils.isEmpty(localUrl)&&new File(localUrl).exists()){
//			String fileName="th" + new File(localUrl).getName();
//			File localThumbFile=new File(PathUtil.getInstance().getVideoPath(), fileName);
//			if(localThumbFile.exists())
//			{
//				return localThumbFile.getAbsolutePath();
//			}
//		}
		return ((EMAVideoMessageBody)emaObject).thumbnailLocalPath();
	}

	/**
	 * \~chinese
	 * 获得视频文件的长度（单位为秒）
	 * @return
	 * 
	 * \~english
	 * get the video duration
	 * @return
	 */
	public int getDuration() {
		return (int) ((EMAVideoMessageBody)emaObject).duration();
	}

	public String toString() {
		return "video:" + ((EMAVideoMessageBody)emaObject).displayName() + ",localUrl:" + ((EMAVideoMessageBody)emaObject).getLocalUrl() + ",remoteUrl:" + ((EMAVideoMessageBody)emaObject).getRemoteUrl()
				+ ",thumbnailUrl:" + ((EMAVideoMessageBody)emaObject).thumbnailLocalPath() + ",length:" + ((EMAVideoMessageBody)emaObject).fileLength();
	}

	@Override
	public int describeContents() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		// members from FileMessageBody
		dest.writeString(((EMAVideoMessageBody)emaObject).displayName());
		dest.writeString(((EMAVideoMessageBody)emaObject).getLocalUrl());
		dest.writeString(((EMAVideoMessageBody)emaObject).getRemoteUrl());
		dest.writeString(((EMAVideoMessageBody)emaObject).thumbnailLocalPath());
		dest.writeString(((EMAVideoMessageBody)emaObject).thumbnailLocalPath());
		dest.writeInt(((EMAVideoMessageBody)emaObject).duration());
		dest.writeLong(((EMAVideoMessageBody)emaObject).fileLength());

	}

	public static final Parcelable.Creator<EMVideoMessageBody> CREATOR = new Creator<EMVideoMessageBody>() {

		@Override
		public EMVideoMessageBody[] newArray(int size) {
			return new EMVideoMessageBody[size];
		}

		@Override
		public EMVideoMessageBody createFromParcel(Parcel in) {

			return new EMVideoMessageBody(in);
		}
	};

	private EMVideoMessageBody(Parcel in) {
		super("", EMAMessageBody.EMAMessageBodyType_VIDEO);
		// members from FileMessageBody
		((EMAVideoMessageBody)emaObject).setDisplayName(in.readString());
		((EMAVideoMessageBody)emaObject).setLocalPath(in.readString());
		((EMAVideoMessageBody)emaObject).setRemotePath(in.readString());
		((EMAVideoMessageBody)emaObject).setThumbnailRemotePath(in.readString());
		((EMAVideoMessageBody)emaObject).setThumbnailLocalPath(in.readString());
		((EMAVideoMessageBody)emaObject).setDuration(in.readInt());
		((EMAVideoMessageBody)emaObject).setFileLength(in.readLong());
	}

	public void setThumbnailSecret(String secret) {
		((EMAVideoMessageBody)emaObject).setThumbnailSecretKey(secret);
	}

	public String getThumbnailSecret() {
		return ((EMAVideoMessageBody)emaObject).thumbnailSecretKey();
	}
	
	void setThumbnailDownloadStatus(EMDownloadStatus status) {
		((EMAVideoMessageBody)emaObject).setThumbnailDownloadStatus(EMADownloadStatus.valueOf(status.name()));
	}
	
	/**
     * \~chinese
     * 获取缩略图的下载状态
     * @return
     * 
     * \~english
     * get the download status of the thumbnail
     * @return
     */
	public EMDownloadStatus thumbnailDownloadStatus() {
	    EMADownloadStatus _status = ((EMAVideoMessageBody)emaObject).thumbnailDownloadStatus();
	    switch (_status) {
	    case DOWNLOADING:
	        return EMDownloadStatus.DOWNLOADING;
	    case SUCCESSED:
	        return EMDownloadStatus.SUCCESSED;
	    case FAILED:
	        return EMDownloadStatus.FAILED;
	    case PENDING:
	        return EMDownloadStatus.PENDING;
	    }
	    return EMDownloadStatus.SUCCESSED;
	}
}
