/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import java.io.File;

import com.hyphenate.chat.adapter.message.EMAFileMessageBody.EMADownloadStatus;
import com.hyphenate.chat.adapter.message.EMAImageMessageBody;
import com.hyphenate.chat.adapter.message.EMAMessageBody;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * \~chinese
 * 图片消息体
 * <pre>
 * EMImageMessageBody body = new EMImageMessageBody(imageFile);
 * </pre>
 *
 * \~english 
 * the image message body class
 * <pre>
 * EMImageMessageBody body = new EMImageMessageBody(imageFile);
 * </pre>
 */
public class EMImageMessageBody extends EMFileMessageBody implements Parcelable {
	
	private boolean sendOriginalImage = false;
    
    public EMImageMessageBody(File imageFile, File thumbnailFile) {
    	super(imageFile.getAbsolutePath(), EMAMessageBody.EMAMessageBodyType_IMAGE);
    	((EMAImageMessageBody)emaObject).setThumbnailLocalPath(thumbnailFile.getAbsolutePath());
    }
    
    /**
     * \~chinese
     * 创建一个图片消息体
     * @param imageFile 图片文件
     * 
     * \~english
     * create a image message body
     * @param imageFile the image file 
     */
    public EMImageMessageBody(File imageFile){
    	super(imageFile.getAbsolutePath(), EMAMessageBody.EMAMessageBodyType_IMAGE);
    }
    
    public EMImageMessageBody(EMAImageMessageBody body) {
    	super(body);
	}
    
    /**
     * create EMImageMessageBody from incoming message
     * @param fileName
     * @param remoteUrl
     * @param thumbnilUrl
     */
    EMImageMessageBody(String fileName, String remoteUrl, String thumbnailUrl) {
    	super("", EMAMessageBody.EMAMessageBodyType_IMAGE);
    	emaObject = new EMAImageMessageBody("", "");
    	((EMAImageMessageBody)emaObject).setDisplayName(fileName);
    	((EMAImageMessageBody)emaObject).setRemotePath(remoteUrl);
    	((EMAImageMessageBody)emaObject).setThumbnailRemotePath(thumbnailUrl);
    }
    
    /**
     * \~chinese
     * 获取 缩略图的url
     * <li>接受消息时，sdk 会自动下载缩略图，存储到本地</li>
     * @return
     * 
     * \~english
     * get the thumbnail url
     * <li>when received the message ,sdk will download the thumbnail automatic</li>
     * @return
     */
    public String getThumbnailUrl() {
        return ((EMAImageMessageBody)emaObject).thumbnailRemotePath();
    }
    
    /**
     * \~chinese
     * 设置缩略图路径
     * @param thumbnailUrl
     * 
     * \~english
     * set the thumbnail url
     * @param thumbnailUrl
     */
    public void setThumbnailUrl(String thumbnailUrl) {
    	((EMAImageMessageBody)emaObject).setThumbnailRemotePath(thumbnailUrl); 
    }
    
    public String toString() {
        return "image:" + ((EMAImageMessageBody)emaObject).displayName() + ",localurl:" + ((EMAImageMessageBody)emaObject).getLocalUrl() + ""
            + ",remoteurl:" + ((EMAImageMessageBody)emaObject).getRemoteUrl() + ",thumbnial:" + ((EMAImageMessageBody)emaObject).thumbnailRemotePath();
    }

    @Override
    public int describeContents() {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        //members from FileMessageBody
        dest.writeString(((EMAImageMessageBody)emaObject).displayName());
        dest.writeString(((EMAImageMessageBody)emaObject).getLocalUrl());
        dest.writeString(((EMAImageMessageBody)emaObject).getRemoteUrl());
        dest.writeString(((EMAImageMessageBody)emaObject).thumbnailRemotePath());
        
        dest.writeInt(((EMAImageMessageBody)emaObject).width());
        dest.writeInt(((EMAImageMessageBody)emaObject).height());
        
    }
    
    public static final Parcelable.Creator<EMImageMessageBody> CREATOR
            = new Parcelable.Creator<EMImageMessageBody>() {
        public EMImageMessageBody createFromParcel(Parcel in) {
            return new EMImageMessageBody(in);
        }

        public EMImageMessageBody[] newArray(int size) {
            return new EMImageMessageBody[size];
        }
    };

    private EMImageMessageBody(Parcel in) {
    	super("", EMAMessageBody.EMAMessageBodyType_IMAGE);
        //members from FileMessageBody
    	((EMAImageMessageBody)emaObject).setDisplayName(in.readString());
    	((EMAImageMessageBody)emaObject).setLocalPath(in.readString());
    	((EMAImageMessageBody)emaObject).setRemotePath(in.readString());
    	((EMAImageMessageBody)emaObject).setThumbnailRemotePath(in.readString());
    	((EMAImageMessageBody)emaObject).setSize(in.readInt(), in.readInt());
    }
    
    public void setThumbnailSecret(String secret) {
    	((EMAImageMessageBody)emaObject).setThumbnailSecretKey(secret);
    }
    
    public String getThumbnailSecret() {
    	return ((EMAImageMessageBody)emaObject).thumbnailSecretKey();
    }
    
    /**
     * \~chinese
     * 设置发送图片时，是否发送原图，默认是发送压缩过后的图(图片超过100k会被压缩)
     * @param sendOriginalImage
     * 
     * \~english
     * set whether send original image when sending image, 
     * the default is to send the figure after the compression(image greater than 100k will be compress)
     * @param sendOriginalImage
     */
    public void setSendOriginalImage(boolean sendOriginalImage) {
    	this.sendOriginalImage = sendOriginalImage;
    }
    
    /**
     * \~chinese
     * 获取发送图片时，是否发送原图
     * @return
     * 
     * \~english
     * get whether send original image
     */
    public boolean isSendOriginalImage(){
    	return sendOriginalImage;
    }
    
    /**
     * \~chinese
     * 获取图片的宽度
     * @return
     * 
     * \~english
     * get image width
     * @return
     */
    public int getWidth() {
		return ((EMAImageMessageBody)emaObject).width();
	}

    /**
     * \~chinese
     * 获取图片的高度
     * @return
     * 
     * \~english
     * get image height
     * @return
     */
	public int getHeight() {
		return ((EMAImageMessageBody)emaObject).height();
	}
	
	/**
     * \~chinese
     * 获取图片文件名字
     * @return
     * 
     * \~english
     * get image file name
     * @return
     */
	public String getFileName() {
		return ((EMAImageMessageBody)emaObject).displayName();
	}
	
	void setSize(int width, int height) {
		((EMAImageMessageBody)emaObject).setSize(width, height);
	}
	
	/**
     * \~chinese
     * 获取缩略图本地路径
     * @return
     * 
     * \~english
     * get local path of thumbnail
     * @return
     */
	public String thumbnailLocalPath() {
		return ((EMAImageMessageBody)emaObject).thumbnailLocalPath();
	}
	
	/**
     * \~chinese
     * 设置缩略图本地路径
     * @return
     * 
     * \~english
     * set local path of thumbnail
     * @return
     */
    public void setThumbnailLocalPath(String localPath) {
        ((EMAImageMessageBody)emaObject).setThumbnailLocalPath(localPath);
    }

	/**
	 * \~chinese
	 * 获取缩略图的下载状态
	 * @return
	 * 
	 * \~english
	 * get the download status of the thumbnail
	 * @return
	 */
	public EMDownloadStatus thumbnailDownloadStatus() {
	    EMADownloadStatus _status = ((EMAImageMessageBody)emaObject).thumbnailDownloadStatus();
	    switch (_status) {
	    case DOWNLOADING:
	        return EMDownloadStatus.DOWNLOADING;
	    case SUCCESSED:
	        return EMDownloadStatus.SUCCESSED;
	    case FAILED:
	        return EMDownloadStatus.FAILED;
	    case PENDING:
	        return EMDownloadStatus.PENDING;
	    }
	    return EMDownloadStatus.SUCCESSED;
	}
	
	void setThumbnailDownloadStatus(EMDownloadStatus status) {
		((EMAImageMessageBody)emaObject).setThumbnailDownloadStatus(EMADownloadStatus.valueOf(status.name()));
    }
}
