/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMAChatRoom;

import java.util.List;
import java.util.Map;

public class EMChatRoom extends EMBase<EMAChatRoom> {

    enum EMChatRoomStyle{
        /**
         *\~chinese
         * 私有群组，创建完成后，只允许Owner邀请用户加入
         *
         * \~english
         * Private groups, after created, only allowing owner invite users to join
         */
        EMChatRoomStylePrivateOnlyOwnerInvite,

        /**
         * \~chinese
         * 私有群组，创建完成后，只允许Owner和群成员邀请用户加入
         *
         * \~english
         * Private groups, after created, only allowing owner and members invite users to join
         */
        EMChatRoomStylePrivateMemberCanInvite,

        /**
         * \~chinese
         * 公开群组，创建完成后，只允许Owner邀请用户加入; 非群成员用户需发送入群申请，Owner同意后才能入组
         *
         * *\~english
         * Public groups, after created, only allowing owner invite users to join; Non-group members into the group must send an application to the owner after the Owner agree
         */
        EMChatRoomStylePublicJoinNeedApproval,

        /**
         * \~chinese
         * 公开群组，创建完成后，允许非群组成员加入，不需要Owner同意
         *
         * \~english Public groups, after created, to allow non-members to join the group, does not require owner agrees
         */
        EMChatRoomStylePublicOpenJoin
    }

	public EMChatRoom(){
	    emaObject = new EMAChatRoom();
	}
	
	public EMChatRoom(EMAChatRoom room) {
	    emaObject = new EMAChatRoom(room);
	}
	
    public EMChatRoom(String roomId){
        emaObject = new EMAChatRoom(roomId);
    }
    
    public EMChatRoom(String roomId, String roomName){
        emaObject = new EMAChatRoom(roomId);
//        this.nick = roomName;
    }

    public String getId() {
        return emaObject.getId();
     }

     public String getName() {
        return emaObject.getName();
     }

     public String getDescription() {
        return emaObject.getDescription();
    }

    /**
     * \~chinese
     * 获取聊天室的所有者，如果没有获取聊天室详情，返回可能为空
     *
     * \~english
     * get chat room owner, if not fetch the chat room's detail specification, return result can be empty
     * @return
     */
    public String getOwner() {
        return emaObject.getOwner();
    }

    /**
     * \~chinese
     * 获取聊天室的管理员列表，如果没有获取聊天室详情，返回可能为空
     *
     * \~english
     * get chat room administrator list, if not fetch the chat room's detail specification, return result can be empty
     * @return
     */
    public List<String> getAdminList() { return emaObject.getAdministratorList();}

    /**
     * \~chinese
     * @deprecated  使用{@link EMChatRoom#getMemberCount()} 替代
     *
     * \~english
     * @deprecated  use {@link EMChatRoom#getMemberCount()} instead
     */
    @Deprecated
    public int getAffiliationsCount()
    {
        return emaObject.getAffiliationsCount();
    }

    /**
     * \~chinese
     * 返回在线成员人数
     * @return
     *
     * \~english
     * return online member count
     */
    public int getMemberCount()
    {
        return emaObject.getAffiliationsCount();
    }

    public int getMaxUsers() {
        return emaObject.getMaxUserCount();
    }

    /**
     * \~chinese
     * 返回成员列表
     * @return
     *
     * \~english
     * return member list
     */
    public List<String> getMemberList(){
        return emaObject.getMemberList();
    }

    /**
     * \~chinese
     * 返回聊天室黑名单
     * @return
     *
     * \~english
     * return black list
     * @return
     */
    public List<String> getBlackList() { return emaObject.getBlockList(); }

    /**
     * \~chinese
     * 返回禁言列表, Map.entry.key 是禁言的成员id，Map.entry.value是禁言动作存在的时间，单位是毫秒。
     * @return
     *
     * \~english
     * return mute list, Map.entry.key is username of mute action, Map.entry.value is expired time of banning post action, in milli-seconds
     * @return
     */
    public Map<String, Long> getMuteList() { return emaObject.getMuteList(); }

}
