/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

/*!
 *  \~chinese
 *  联系人监听器，监听联系变化，包括添加好友的申请，对方删除好友的通知, 对方同意好友请求，对方拒绝好友请求。
 *  注册联系人监听，请执行EMClient.getInstance().contactManager().setContactListener(EMContactListener listener);
 *
 *  \~english
 *  Contact updates listener. if your app is using Hyphenate's contact management, then you will need to use the following listeners for updates
 */
public interface EMContactListener {
    
    /**
     * \~chinese
     * 增加联系人时回调此方法
     * @param username 增加的联系人
     * 
     * \~english
     * callback the user is added as a contact by another user
     * @param username   new contact added
     */
    void onContactAdded(String username);
    
    /**
     * \~chinese
     * 被删除时回调此方法
     * @param username 删除的联系人

     *
     * \~english
     * callback when user is removed as a contact by another user
     * @param username    contact removed
     */
    void onContactDeleted(String username);

    /**
     * \~chinese
     * 收到好友邀请
     * @param username 发起加为好友用户的名称
     * @param reason   对方发起好友邀请时发出的文字性描述
     *
     * \~english
     * callback when user receives a friend request
     * @param username    User who initiated the friend request
     * @param reason      User's friend request message.
     */
    void onContactInvited(String username, String reason);
    
    /**
     * \~chinese
     * 好友请求被同意
     * @param username
     *
     * \~english
     * callback when a friend request is approved
     * @param username
     */
    void onFriendRequestAccepted(String username);

    /**
     * \~chinese
     * 好友请求被拒绝
     * @param username
     *
     * \~english
     * callback when a friend request is declined
     * @param username
     */
    void onFriendRequestDeclined(String username);
}
