/*
 * Decompiled with CFR 0.152.
 */
package easemob.hyphenate.calluikit.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.appcompat.widget.AppCompatImageView;
import easemob.hyphenate.calluikit.R;
import easemob.hyphenate.calluikit.widget.CanvasLegacy;

public class EaseImageView
extends AppCompatImageView {
    private Paint pressPaint;
    private int width;
    private int height;
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLORDRAWABLE_DIMENSION = 1;
    private int borderColor;
    private int borderWidth;
    private int pressAlpha;
    private int pressColor;
    private int radius;
    private int shapeType;

    public EaseImageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public EaseImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public EaseImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.borderWidth = 0;
        this.borderColor = -570425345;
        this.pressAlpha = 66;
        this.pressColor = 0x42000000;
        this.radius = 16;
        this.shapeType = 0;
        if (attrs != null) {
            TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.EaseImageView);
            this.borderColor = array.getColor(R.styleable.EaseImageView_ease_border_color, this.borderColor);
            this.borderWidth = array.getDimensionPixelOffset(R.styleable.EaseImageView_ease_border_width, this.borderWidth);
            this.pressAlpha = array.getInteger(R.styleable.EaseImageView_ease_press_alpha, this.pressAlpha);
            this.pressColor = array.getColor(R.styleable.EaseImageView_ease_press_color, this.pressColor);
            this.radius = array.getDimensionPixelOffset(R.styleable.EaseImageView_ease_radius, this.radius);
            this.shapeType = array.getInteger(R.styleable.EaseImageView_ease_shape_type, this.shapeType);
            array.recycle();
        }
        this.pressPaint = new Paint();
        this.pressPaint.setAntiAlias(true);
        this.pressPaint.setStyle(Paint.Style.FILL);
        this.pressPaint.setColor(this.pressColor);
        this.pressPaint.setAlpha(0);
        this.pressPaint.setFlags(1);
        this.setDrawingCacheEnabled(true);
        this.setWillNotDraw(false);
    }

    protected void onDraw(Canvas canvas) {
        if (this.shapeType == 0) {
            super.onDraw(canvas);
            return;
        }
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        Bitmap bitmap = this.getBitmapFromDrawable(drawable2);
        this.drawDrawable(canvas, bitmap);
        if (this.isClickable()) {
            this.drawPress(canvas);
        }
        this.drawBorder(canvas);
    }

    private void drawDrawable(Canvas canvas, Bitmap bitmap) {
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setAntiAlias(true);
        PorterDuffXfermode xfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_IN);
        if (Build.VERSION.SDK_INT < 23) {
            int saveFlags = CanvasLegacy.MATRIX_SAVE_FLAG | CanvasLegacy.CLIP_SAVE_FLAG | CanvasLegacy.HAS_ALPHA_LAYER_SAVE_FLAG | CanvasLegacy.FULL_COLOR_LAYER_SAVE_FLAG | CanvasLegacy.CLIP_TO_LAYER_SAVE_FLAG;
            CanvasLegacy.saveLayer(canvas, 0.0f, 0.0f, this.width, this.height, null, saveFlags);
        } else {
            canvas.saveLayer(0.0f, 0.0f, (float)this.width, (float)this.height, null);
        }
        if (this.shapeType == 1) {
            canvas.drawCircle((float)(this.width / 2), (float)(this.height / 2), (float)(this.width / 2 - 1), paint);
        } else if (this.shapeType == 2) {
            RectF rectf = new RectF(1.0f, 1.0f, (float)(this.getWidth() - 1), (float)(this.getHeight() - 1));
            canvas.drawRoundRect(rectf, (float)(this.radius + 1), (float)(this.radius + 1), paint);
        }
        paint.setXfermode((Xfermode)xfermode);
        float scaleWidth = (float)this.getWidth() / (float)bitmap.getWidth();
        float scaleHeight = (float)this.getHeight() / (float)bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        canvas.restore();
    }

    private void drawPress(Canvas canvas) {
        if (this.shapeType == 1) {
            canvas.drawCircle((float)(this.width / 2), (float)(this.height / 2), (float)(this.width / 2 - 1), this.pressPaint);
        } else if (this.shapeType == 2) {
            RectF rectF = new RectF(1.0f, 1.0f, (float)(this.width - 1), (float)(this.height - 1));
            canvas.drawRoundRect(rectF, (float)(this.radius + 1), (float)(this.radius + 1), this.pressPaint);
        }
    }

    private void drawBorder(Canvas canvas) {
        if (this.borderWidth > 0) {
            Paint paint = new Paint();
            paint.setStrokeWidth((float)this.borderWidth);
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(this.borderColor);
            paint.setAntiAlias(true);
            if (this.shapeType == 1) {
                canvas.drawCircle((float)(this.width / 2), (float)(this.height / 2), (float)((this.width - this.borderWidth) / 2), paint);
            } else if (this.shapeType == 2) {
                RectF rectf = new RectF((float)(this.borderWidth / 2), (float)(this.borderWidth / 2), (float)(this.getWidth() - this.borderWidth / 2), (float)(this.getHeight() - this.borderWidth / 2));
                canvas.drawRoundRect(rectf, (float)this.radius, (float)this.radius, paint);
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.width = w;
        this.height = h;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.pressPaint.setAlpha(this.pressAlpha);
                this.invalidate();
                break;
            }
            case 1: {
                this.pressPaint.setAlpha(0);
                this.invalidate();
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.pressPaint.setAlpha(0);
                this.invalidate();
            }
        }
        return super.onTouchEvent(event);
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable2) {
        Bitmap bitmap;
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        int width = Math.max(drawable2.getIntrinsicWidth(), 2);
        int height = Math.max(drawable2.getIntrinsicHeight(), 2);
        try {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)BITMAP_CONFIG);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            bitmap = null;
        }
        return bitmap;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.invalidate();
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public void setPressAlpha(int pressAlpha) {
        this.pressAlpha = pressAlpha;
    }

    public void setPressColor(int pressColor) {
        this.pressColor = pressColor;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.invalidate();
    }

    public void setShapeType(int shapeType) {
        this.shapeType = shapeType;
        this.invalidate();
    }
}

