/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easecallkit.livedatas;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;

public class EaseSingleSourceLiveData<T>
extends MutableLiveData<T> {
    private LiveData<T> lastSource;
    private T lastData;
    private final Observer<T> observer = new Observer<T>(){

        public void onChanged(T t) {
            if (t != null && t == EaseSingleSourceLiveData.this.lastData) {
                return;
            }
            EaseSingleSourceLiveData.this.lastData = t;
            EaseSingleSourceLiveData.this.setValue(t);
        }
    };

    public void setSource(LiveData<T> source) {
        if (this.lastSource == source) {
            return;
        }
        if (this.lastSource != null) {
            this.lastSource.removeObserver(this.observer);
        }
        this.lastSource = source;
        if (this.hasActiveObservers()) {
            this.lastSource.observeForever(this.observer);
        }
    }

    protected void onActive() {
        super.onActive();
        if (this.lastSource != null) {
            this.lastSource.observeForever(this.observer);
        }
    }

    protected void onInactive() {
        super.onInactive();
        if (this.lastSource != null) {
            this.lastSource.removeObserver(this.observer);
        }
    }
}

