/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easecallkit.base;

import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Scroller;
import androidx.annotation.Nullable;
import com.hyphenate.easecallkit.base.EaseCallMemberView;
import com.hyphenate.util.EMLog;

public class EaseCallMemberViewGroup
extends ViewGroup {
    private static final String TAG = "EaseViewGroup1";
    private static final int MAX_SIZE_PER_PAGE = 15;
    private OnItemClickListener onItemClickListener;
    private OnScreenModeChangeListener onScreenModeChangeListener;
    private OnPageStatusListener onPageStatusListener;
    private Scroller mScroller;
    private float mLastMotionX = 0.0f;
    private PointF actionDownPoint = new PointF();
    private int pageWidth = 0;
    private int screenHeight = 0;
    private int pageIndex = 0;
    private int pageCount = 1;
    private View fullScreenView;
    int touchSlop;

    public EaseCallMemberViewGroup(Context context) {
        super(context);
        this.init();
    }

    public EaseCallMemberViewGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public EaseCallMemberViewGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mScroller = new Scroller(this.getContext());
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        Point p = new Point();
        wm.getDefaultDisplay().getSize(p);
        this.pageWidth = p.x;
        this.screenHeight = p.y;
        this.touchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
    }

    public void addView(View child) {
        super.addView(child);
        if (this.isFullScreenMode()) {
            EMLog.i((String)TAG, (String)("addView, isFullScreenMode: " + this.isFullScreenMode()));
            return;
        }
        if (this.pageCount == 1) {
            this.calculateChildrenParamsAndSet();
        } else {
            int viewBorder = this.pageWidth / 3;
            this.setViewParams(child, viewBorder, viewBorder);
        }
        int index = this.pageCount - 1;
        this.scrollTo(index, false);
    }

    public void removeView(View view) {
        super.removeView(view);
        this.calculateChildrenParamsAndSet();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int rightLimit = this.pageWidth;
        int baseLeft = 0;
        int baseTop = 0;
        int curLeft = baseLeft;
        int curTop = baseTop;
        View child = null;
        ViewGroup.MarginLayoutParams params = null;
        int lastChildHeight = 0;
        for (int i = 0; i < count; ++i) {
            int viewB;
            int viewR;
            int viewT;
            int viewL;
            if ((i + 1) % 15 == 1) {
                int p = (i + 1) / 15;
                baseLeft = this.pageWidth * p + this.getPaddingLeft();
                baseTop = this.getPaddingTop();
                rightLimit = this.pageWidth * (p + 1);
                curLeft = baseLeft;
                curTop = baseTop;
            }
            if (8 == (child = this.getChildAt(i)).getVisibility()) continue;
            int childW = child.getMeasuredWidth();
            int childH = child.getMeasuredHeight();
            params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidth = childW + params.leftMargin + params.rightMargin;
            int childHeight = childH + params.topMargin + params.bottomMargin;
            if (curLeft + childWidth > rightLimit) {
                viewL = baseLeft + params.leftMargin;
                viewT = (curTop += lastChildHeight) + params.topMargin;
                viewR = viewL + childW;
                viewB = viewT + childH;
                curLeft = baseLeft + childWidth;
            } else {
                viewL = curLeft + params.leftMargin;
                viewT = curTop + params.topMargin;
                viewR = viewL + childW;
                viewB = viewT + childH;
                curLeft += childWidth;
            }
            lastChildHeight = childHeight;
            child.layout(viewL, viewT, viewR, viewB);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMeasure = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMeasure = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int maxLineWidth = 0;
        int totalHeight = 0;
        int curLineWidth = 0;
        int curLineHeight = 0;
        int count = this.getChildCount();
        View child = null;
        ViewGroup.MarginLayoutParams params = null;
        for (int i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (8 == child.getVisibility()) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            params = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth() + params.leftMargin + params.rightMargin;
            int childHeight = child.getMeasuredHeight() + params.topMargin + params.bottomMargin;
            if (curLineWidth + childWidth > widthMeasure - this.getPaddingLeft() - this.getPaddingRight()) {
                maxLineWidth = Math.max(maxLineWidth, curLineWidth);
                totalHeight += curLineHeight;
                curLineWidth = childWidth;
                curLineHeight = childHeight;
            } else {
                curLineWidth += childWidth;
                curLineHeight = Math.max(curLineHeight, childHeight);
            }
            if (i != count - 1) continue;
            maxLineWidth = Math.max(maxLineWidth, curLineWidth);
            totalHeight += childHeight;
        }
        int measuredWidth = widthMode != 0x40000000 ? maxLineWidth + this.getPaddingLeft() + this.getPaddingRight() : widthMeasure;
        this.setMeasuredDimension(measuredWidth * this.pageCount, heightMode != 0x40000000 ? totalHeight + this.getPaddingTop() + this.getPaddingBottom() : heightMeasure);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mScroller.isFinished()) {
            return true;
        }
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.actionDownPoint.x = event.getX();
                this.actionDownPoint.y = event.getY();
                EMLog.i((String)TAG, (String)("onInterceptTouchEvent ACTION_DOWN: downPointX: " + this.actionDownPoint.x));
                this.mLastMotionX = event.getX();
                break;
            }
            case 2: {
                if (this.isFullScreenMode()) {
                    return true;
                }
                float x = event.getX();
                EMLog.i((String)TAG, (String)("onInterceptTouchEvent: move action: " + x));
                float delt = this.mLastMotionX - x;
                this.mLastMotionX = x;
                if (this.pageIndex == 0 && delt < 0.0f || this.pageIndex == this.pageCount - 1 && delt > 0.0f) {
                    delt /= 5.0f;
                }
                this.scrollBy((int)delt, 0);
                break;
            }
            case 1: {
                EMLog.i((String)TAG, (String)("onTouchEvent: " + this.getScrollX()));
                float delta = this.actionDownPoint.x - event.getX();
                if (Math.abs(delta) < (float)this.touchSlop && Math.abs(this.actionDownPoint.y - event.getY()) < (float)this.touchSlop) {
                    this.performClick((int)event.getX(), (int)event.getY());
                } else {
                    if (this.isFullScreenMode()) {
                        return true;
                    }
                    if (Math.abs(delta) < (float)(this.pageWidth / 3)) {
                        this.scrollTo(this.pageIndex, true);
                    } else {
                        int index = this.pageIndex;
                        if (delta < 0.0f) {
                            if (index > 0) {
                                --index;
                            }
                        } else if (index < this.pageCount - 1) {
                            ++index;
                        }
                        this.scrollTo(index, true);
                    }
                }
                this.actionDownPoint.set(0.0f, 0.0f);
            }
        }
        return true;
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            this.postInvalidate();
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        return new ViewGroup.MarginLayoutParams(lp);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int currentIndex() {
        return this.pageIndex;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.onItemClickListener = listener;
    }

    public void setOnScreenModeChangeListener(OnScreenModeChangeListener listener) {
        this.onScreenModeChangeListener = listener;
    }

    public void setOnPageStatusListener(OnPageStatusListener listener) {
        this.onPageStatusListener = listener;
    }

    public void performClick(int x, int y) {
        Pair<Integer, View> result = this.findTargetView(x, y);
        if (result == null) {
            EMLog.i((String)TAG, (String)"onTouchEvent: no child on click point.");
        } else {
            EMLog.i((String)TAG, (String)("onTouchEvent: child click , index: " + result.first + ", child view: " + result.second));
            this.handleItemClickAction((View)result.second, (Integer)result.first);
        }
    }

    public boolean isFullScreenMode() {
        return this.fullScreenView != null;
    }

    public View getFullScreenView() {
        return this.fullScreenView;
    }

    private void scrollTo(int index, boolean smooth) {
        if (!smooth) {
            this.scrollTo(index * this.pageWidth, 0);
        } else {
            this.smoothScrollTo(index * this.pageWidth, 0);
        }
        if (this.onPageStatusListener != null && index != this.pageIndex) {
            this.onPageStatusListener.onPageScroll(index);
        }
        this.pageIndex = index;
    }

    private void smoothScrollTo(int x, int y) {
        EMLog.i((String)TAG, (String)("smoothScrollTo: " + this.getScrollX() + ", target : " + x));
        int deltaX = x - this.getScrollX();
        int deltaY = y - this.getScrollY();
        this.mScroller.startScroll(this.getScrollX(), 0, deltaX, deltaY);
        this.invalidate();
    }

    private void calculateChildrenParamsAndSet() {
        int childCount = this.getChildCount();
        int itemWidth = this.pageWidth;
        if (childCount > 6) {
            itemWidth = this.pageWidth / 3;
        } else if (childCount > 1) {
            itemWidth = this.pageWidth / 2;
        }
        int lastheight = itemWidth;
        int height = 0;
        height = this.getChildCount() > 6 && this.getChildCount() <= 15 ? this.screenHeight / 5 : (this.getChildCount() > 4 && this.getChildCount() <= 6 ? this.screenHeight / 3 : itemWidth);
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.setViewParams(this.getChildAt(i), itemWidth, height);
        }
    }

    private void setViewParams(View target, int widthBorder, int heightBorder) {
        ViewGroup.LayoutParams params = target.getLayoutParams();
        params.width = widthBorder;
        params.height = heightBorder;
        target.setLayoutParams(params);
    }

    private void calculatePageCount() {
        int count = (this.getChildCount() - 1) / 15 + 1;
        if (this.pageCount != count && this.onPageStatusListener != null) {
            this.onPageStatusListener.onPageCountChange(count);
        }
        this.pageCount = count;
    }

    private Pair<Integer, View> findTargetView(int x, int y) {
        int start = this.pageIndex * 15;
        int count = this.getChildCount() - start > 15 ? 15 : this.getChildCount() - start;
        for (int i = start; i < start + count; ++i) {
            View result = this.getChildAt(i);
            int[] location = new int[2];
            result.getLocationOnScreen(location);
            int left = location[0];
            int top = location[1];
            int right = left + result.getMeasuredWidth();
            int bottom = top + result.getMeasuredHeight();
            if (!new Rect(left, top, right, bottom).contains(x, y)) continue;
            return new Pair((Object)i, (Object)result);
        }
        return null;
    }

    private void handleItemClickAction(View v, int index) {
        if (this.isFullScreenMode()) {
            this.resetAllViews(v);
        } else if (v instanceof EaseCallMemberView && !((EaseCallMemberView)v).isVideoOff()) {
            this.fullScreen(v);
        }
        if (this.onItemClickListener != null) {
            this.onItemClickListener.onItemClick(v, index);
        }
    }

    private void fullScreen(View view) {
        this.fullScreenView = view;
        int pageIndex = this.indexOfChild(view) / 15;
        int start = pageIndex * 15;
        int end = this.getChildCount() - start > 15 ? start + 15 : this.getChildCount();
        for (int i = start; i < end; ++i) {
            View child = this.getChildAt(i);
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (view == child) {
                lp.width = this.pageWidth;
                lp.height = this.screenHeight;
            } else {
                lp.width = 0;
                lp.height = 0;
            }
            child.setLayoutParams(lp);
        }
        if (view instanceof EaseCallMemberView) {
            ((EaseCallMemberView)view).setFullScreen(this.isFullScreenMode());
        }
        if (this.onScreenModeChangeListener != null) {
            this.onScreenModeChangeListener.onScreenModeChange(this.isFullScreenMode(), this.fullScreenView);
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        this.pageWidth = this.getMeasuredWidth();
        this.screenHeight = this.getMeasuredHeight();
        this.calculateChildrenParamsAndSet();
    }

    private void resetAllViews(View view) {
        this.fullScreenView = null;
        if (this.pageCount == 1) {
            this.calculateChildrenParamsAndSet();
        } else {
            int pageIndex = this.indexOfChild(view) / 15;
            int start = pageIndex * 15;
            int end = this.getChildCount() - start > 15 ? start + 15 : this.getChildCount();
            int itemWidth = this.pageWidth / 3;
            for (int i = start; i < end; ++i) {
                this.setViewParams(this.getChildAt(i), itemWidth, itemWidth);
            }
        }
        if (view instanceof EaseCallMemberView) {
            ((EaseCallMemberView)view).setFullScreen(this.isFullScreenMode());
        }
        if (this.onScreenModeChangeListener != null) {
            this.onScreenModeChangeListener.onScreenModeChange(this.isFullScreenMode(), this.fullScreenView);
        }
    }

    public static interface OnPageStatusListener {
        public void onPageCountChange(int var1);

        public void onPageScroll(int var1);
    }

    public static interface OnScreenModeChangeListener {
        public void onScreenModeChange(boolean var1, @Nullable View var2);
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }
}

