/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easecallkit.base;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.hyphenate.chat.EMClient;
import com.hyphenate.easecallkit.EaseCallKit;
import com.hyphenate.easecallkit.R;
import com.hyphenate.easecallkit.base.EaseCallMemberView;
import com.hyphenate.easecallkit.base.EaseCallType;
import com.hyphenate.easecallkit.ui.EaseMultipleVideoActivity;
import com.hyphenate.easecallkit.ui.EaseVideoCallActivity;
import com.hyphenate.easecallkit.utils.EaseCallKitUtils;
import com.hyphenate.util.EMLog;
import io.agora.rtc.RtcEngine;
import io.agora.rtc.video.VideoCanvas;

public class EaseCallFloatWindow {
    private static final String TAG = "EaseCallFloatWindow";
    private Context context;
    private static EaseCallFloatWindow instance;
    private WindowManager windowManager = null;
    private WindowManager.LayoutParams layoutParams = null;
    private View floatView;
    private ImageView avatarView;
    private SurfaceView surfaceView;
    private int screenWidth;
    private int floatViewWidth;
    private EaseCallType callType;
    private EaseCallMemberView memberView;
    private RtcEngine rtcEngine;
    private int uId;

    public EaseCallFloatWindow(Context context) {
        this.context = context;
        this.windowManager = (WindowManager)context.getSystemService("window");
        Point point = new Point();
        this.windowManager.getDefaultDisplay().getSize(point);
        this.screenWidth = point.x;
    }

    public static EaseCallFloatWindow getInstance(Context context) {
        if (instance == null) {
            instance = new EaseCallFloatWindow(context);
        }
        return instance;
    }

    public void setCallType(EaseCallType callType) {
        this.callType = callType;
    }

    public EaseCallMemberView getCallMemberView() {
        return this.memberView;
    }

    public void setRtcEngine(RtcEngine rtcEngine) {
        this.rtcEngine = rtcEngine;
    }

    public EaseCallType getCallType() {
        return this.callType;
    }

    public void show() {
        if (this.floatView != null) {
            return;
        }
        this.layoutParams = new WindowManager.LayoutParams();
        this.layoutParams.gravity = 8388661;
        this.layoutParams.width = -2;
        this.layoutParams.height = -2;
        this.layoutParams.format = -2;
        this.layoutParams.type = EaseCallKitUtils.getSupportedWindowType();
        this.layoutParams.flags = 131080;
        this.floatView = LayoutInflater.from((Context)this.context).inflate(R.layout.activity_float_window, null);
        this.floatView.setFocusableInTouchMode(true);
        this.windowManager.addView(this.floatView, (ViewGroup.LayoutParams)this.layoutParams);
        this.floatView.post(new Runnable(){

            @Override
            public void run() {
                if (EaseCallFloatWindow.this.floatView != null) {
                    EaseCallFloatWindow.this.floatViewWidth = EaseCallFloatWindow.this.floatView.getWidth();
                }
            }
        });
        this.avatarView = (ImageView)this.floatView.findViewById(R.id.iv_avatar);
        this.floatView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent;
                if (EaseCallFloatWindow.this.callType == EaseCallType.CONFERENCE_CALL) {
                    intent = new Intent(EaseCallKit.getInstance().getAppContext(), EaseMultipleVideoActivity.class).addFlags(0x10000000);
                } else {
                    intent = new Intent(EaseCallKit.getInstance().getAppContext(), EaseVideoCallActivity.class).addFlags(0x10000000);
                    intent.putExtra("uId", EaseCallFloatWindow.this.uId);
                }
                intent.putExtra("isClickByFloat", true);
                EaseCallKit.getInstance().getAppContext().startActivity(intent);
                EaseCallFloatWindow.this.dismiss();
            }
        });
        this.floatView.setOnTouchListener(new View.OnTouchListener(){
            boolean result = false;
            int left;
            int top;
            float startX = 0.0f;
            float startY = 0.0f;

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        this.result = false;
                        this.startX = event.getRawX();
                        this.startY = event.getRawY();
                        this.left = ((EaseCallFloatWindow)EaseCallFloatWindow.this).layoutParams.x;
                        this.top = ((EaseCallFloatWindow)EaseCallFloatWindow.this).layoutParams.y;
                        EMLog.i((String)EaseCallFloatWindow.TAG, (String)("startX: " + this.startX + ", startY: " + this.startY + ", left: " + this.left + ", top: " + this.top));
                        break;
                    }
                    case 2: {
                        if (Math.abs(event.getRawX() - this.startX) > 20.0f || Math.abs(event.getRawY() - this.startY) > 20.0f) {
                            this.result = true;
                        }
                        int deltaX = (int)(this.startX - event.getRawX());
                        ((EaseCallFloatWindow)EaseCallFloatWindow.this).layoutParams.x = this.left + deltaX;
                        ((EaseCallFloatWindow)EaseCallFloatWindow.this).layoutParams.y = (int)((float)this.top + event.getRawY() - this.startY);
                        EMLog.i((String)EaseCallFloatWindow.TAG, (String)("startX: " + (event.getRawX() - this.startX) + ", startY: " + (event.getRawY() - this.startY) + ", left: " + this.left + ", top: " + this.top));
                        EaseCallFloatWindow.this.windowManager.updateViewLayout(EaseCallFloatWindow.this.floatView, (ViewGroup.LayoutParams)EaseCallFloatWindow.this.layoutParams);
                        break;
                    }
                    case 1: {
                        EaseCallFloatWindow.this.smoothScrollToBorder();
                    }
                }
                return this.result;
            }
        });
    }

    public void update(EaseCallMemberView view) {
        if (this.floatView == null) {
            return;
        }
        this.memberView = view;
        this.uId = this.memberView.getUserId();
        if (this.memberView.isVideoOff()) {
            this.floatView.findViewById(R.id.layout_call_voice).setVisibility(0);
            this.floatView.findViewById(R.id.layout_call_video).setVisibility(8);
        } else {
            this.floatView.findViewById(R.id.layout_call_voice).setVisibility(8);
            this.floatView.findViewById(R.id.layout_call_video).setVisibility(0);
            String userAccount = this.memberView.getUserAccount();
            int uId = this.memberView.getUserId();
            boolean isSelf = userAccount.equals(EMClient.getInstance().getCurrentUser());
            this.prepareSurfaceView(isSelf, uId);
        }
    }

    public void updateCallWindow(boolean isSelf, int uId, boolean surface) {
        this.uId = uId;
        if (this.callType == EaseCallType.SINGLE_VIDEO_CALL && surface) {
            this.floatView.findViewById(R.id.layout_call_voice).setVisibility(8);
            this.floatView.findViewById(R.id.layout_call_video).setVisibility(0);
            this.prepareSurfaceView(isSelf, uId);
        } else {
            this.floatView.findViewById(R.id.layout_call_voice).setVisibility(0);
            this.floatView.findViewById(R.id.layout_call_video).setVisibility(8);
        }
    }

    public boolean isShowing() {
        if (this.callType == EaseCallType.CONFERENCE_CALL) {
            return this.memberView != null;
        }
        return this.floatView != null;
    }

    public int getUid() {
        if (this.callType == EaseCallType.CONFERENCE_CALL && this.memberView != null) {
            return this.memberView.getUserId();
        }
        return -1;
    }

    public void dismiss() {
        Log.i((String)TAG, (String)"dismiss: ");
        if (this.windowManager != null && this.floatView != null) {
            this.windowManager.removeView(this.floatView);
            this.floatView = null;
        }
    }

    private void prepareSurfaceView(boolean isSelf, int uid) {
        RelativeLayout surfaceLayout = (RelativeLayout)this.floatView.findViewById(R.id.layout_call_video);
        surfaceLayout.removeAllViews();
        this.surfaceView = RtcEngine.CreateRendererView((Context)EaseCallKit.getInstance().getAppContext());
        surfaceLayout.addView((View)this.surfaceView);
        this.surfaceView.setZOrderOnTop(false);
        this.surfaceView.setZOrderMediaOverlay(false);
        if (isSelf) {
            this.rtcEngine.setupLocalVideo(new VideoCanvas((View)this.surfaceView, 1, 0));
        } else {
            this.rtcEngine.setupRemoteVideo(new VideoCanvas((View)this.surfaceView, 1, uid));
        }
    }

    private void smoothScrollToBorder() {
        EMLog.i((String)TAG, (String)("screenWidth: " + this.screenWidth + ", floatViewWidth: " + this.floatViewWidth));
        int splitLine = this.screenWidth / 2 - this.floatViewWidth / 2;
        int left = this.layoutParams.x;
        final int top = this.layoutParams.y;
        int targetX = left < splitLine ? 0 : this.screenWidth - this.floatViewWidth;
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{left, targetX});
        animator.setDuration(100L).addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (EaseCallFloatWindow.this.floatView == null) {
                    return;
                }
                int value = (Integer)animation.getAnimatedValue();
                EMLog.i((String)EaseCallFloatWindow.TAG, (String)("onAnimationUpdate, value: " + value));
                ((EaseCallFloatWindow)EaseCallFloatWindow.this).layoutParams.x = value;
                ((EaseCallFloatWindow)EaseCallFloatWindow.this).layoutParams.y = top;
                EaseCallFloatWindow.this.windowManager.updateViewLayout(EaseCallFloatWindow.this.floatView, (ViewGroup.LayoutParams)EaseCallFloatWindow.this.layoutParams);
            }
        });
        animator.start();
    }
}

