/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easecallkit;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMMessageListener;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.easecallkit.R;
import com.hyphenate.easecallkit.base.EaseCallInfo;
import com.hyphenate.easecallkit.base.EaseCallKitConfig;
import com.hyphenate.easecallkit.base.EaseCallKitListener;
import com.hyphenate.easecallkit.base.EaseCallType;
import com.hyphenate.easecallkit.event.AlertEvent;
import com.hyphenate.easecallkit.event.AnswerEvent;
import com.hyphenate.easecallkit.event.BaseEvent;
import com.hyphenate.easecallkit.event.CallCancelEvent;
import com.hyphenate.easecallkit.event.ConfirmCallEvent;
import com.hyphenate.easecallkit.event.InviteEvent;
import com.hyphenate.easecallkit.livedatas.EaseLiveDataBus;
import com.hyphenate.easecallkit.ui.EaseMultipleVideoActivity;
import com.hyphenate.easecallkit.ui.EaseVideoCallActivity;
import com.hyphenate.easecallkit.utils.EaseCallAction;
import com.hyphenate.easecallkit.utils.EaseCallKitNotifier;
import com.hyphenate.easecallkit.utils.EaseCallKitUtils;
import com.hyphenate.easecallkit.utils.EaseCallState;
import com.hyphenate.easecallkit.utils.EaseMsgUtils;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EasyUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONObject;

public class EaseCallKit {
    private static final String TAG = EaseCallKit.class.getSimpleName();
    private static EaseCallKit instance = null;
    private boolean callKitInit = false;
    private Context appContext = null;
    private EMMessageListener messageListener = null;
    private EaseCallType callType = EaseCallType.SINGLE_VIDEO_CALL;
    private EaseCallState callState = EaseCallState.CALL_IDLE;
    private String channelName;
    private String fromUserId;
    public static String deviceId = "android_";
    public String clallee_devId;
    private String callID = null;
    private JSONObject inviteExt = null;
    private EaseCallInfo callInfo = new EaseCallInfo();
    private TimeHandler timeHandler;
    private Map<String, EaseCallInfo> callInfoMap = new HashMap<String, EaseCallInfo>();
    private EaseCallKitListener callListener;
    private static boolean isComingCall = true;
    private ArrayList<String> inviteeUsers = new ArrayList();
    private EaseCallKitConfig callKitConfig;
    private EaseMultipleVideoActivity multipleVideoActivity;
    private EaseCallKitNotifier notifier;

    private EaseCallKit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaseCallKit getInstance() {
        if (instance != null) return instance;
        Class<EaseCallKit> clazz = EaseCallKit.class;
        synchronized (EaseCallKit.class) {
            if (instance != null) return instance;
            instance = new EaseCallKit();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized boolean init(Context context, EaseCallKitConfig config) {
        if (this.callKitInit) {
            return true;
        }
        this.removeMessageListener();
        this.appContext = context;
        if (!this.isMainProcess(this.appContext)) {
            Log.e((String)TAG, (String)"enter the service process!");
            return false;
        }
        deviceId = deviceId + EaseCallKitUtils.getPhoneSign();
        this.timeHandler = new TimeHandler();
        this.callKitConfig = new EaseCallKitConfig();
        this.callKitConfig.setUserInfoMap(config.getUserInfoMap());
        this.callKitConfig.setDefaultHeadImage(config.getDefaultHeadImage());
        this.callKitConfig.setCallTimeOut(config.getCallTimeOut());
        this.callKitConfig.setRingFile(config.getRingFile());
        this.callKitConfig.setEnableRTCToken(config.isEnableRTCToken());
        this.initNotifier();
        this.addMessageListener();
        this.callKitInit = true;
        return true;
    }

    public EaseCallKitConfig getCallKitConfig() {
        return this.callKitConfig;
    }

    private void initNotifier() {
        this.notifier = new EaseCallKitNotifier(this.appContext);
    }

    public void startSingleCall(EaseCallType type, String user, Map<String, Object> ext) {
        if (this.callState != EaseCallState.CALL_IDLE) {
            if (this.callListener != null) {
                this.callListener.onCallError(EaseCallError.PROCESS_ERROR, CALL_PROCESS_ERROR.CALL_STATE_ERROR.code, "current state is busy");
            }
            return;
        }
        if (type == EaseCallType.CONFERENCE_CALL) {
            if (this.callListener != null) {
                this.callListener.onCallError(EaseCallError.PROCESS_ERROR, CALL_PROCESS_ERROR.CALL_TYPE_ERROR.code, "call type is error");
            }
            return;
        }
        if (user != null && user.length() == 0) {
            if (this.callListener != null) {
                this.callListener.onCallError(EaseCallError.PROCESS_ERROR, CALL_PROCESS_ERROR.CALL_PARAM_ERROR.code, "user is null");
            }
            return;
        }
        this.callType = type;
        this.callState = EaseCallState.CALL_OUTGOING;
        this.fromUserId = user;
        if (ext != null) {
            this.inviteExt = EaseCallKitUtils.convertMapToJSONObject(ext);
        }
        EaseVideoCallActivity callActivity = new EaseVideoCallActivity();
        Intent intent = new Intent(this.appContext, ((Object)((Object)callActivity)).getClass()).addFlags(0x10000000);
        Bundle bundle = new Bundle();
        isComingCall = false;
        bundle.putBoolean("isComingCall", false);
        bundle.putString("username", user);
        this.channelName = EaseCallKitUtils.getRandomString(10);
        bundle.putString("channelName", this.channelName);
        intent.putExtras(bundle);
        this.appContext.startActivity(intent);
    }

    public void startInviteMultipleCall(String[] users, Map<String, Object> ext) {
        if (this.callState != EaseCallState.CALL_IDLE && this.callType != EaseCallType.CONFERENCE_CALL) {
            if (this.callListener != null) {
                this.callListener.onCallError(EaseCallError.PROCESS_ERROR, CALL_PROCESS_ERROR.CALL_STATE_ERROR.code, "current state is busy");
            }
            return;
        }
        if (users == null || ((String[])users).length == 0) {
            if (!this.isDestroy((Activity)this.multipleVideoActivity)) {
                this.inviteeUsers.clear();
                Intent intent = new Intent(this.appContext, ((Object)((Object)this.multipleVideoActivity)).getClass()).addFlags(0x10000000);
                this.appContext.startActivity(intent);
            } else if (this.callListener != null) {
                this.callListener.onCallError(EaseCallError.PROCESS_ERROR, CALL_PROCESS_ERROR.CALL_PARAM_ERROR.code, "users is null");
            }
        } else {
            Intent intent;
            this.callType = EaseCallType.CONFERENCE_CALL;
            this.inviteeUsers.clear();
            for (String user : users) {
                this.inviteeUsers.add(user);
            }
            if (this.isDestroy((Activity)this.multipleVideoActivity)) {
                if (users != null && ((String[])users).length > 0) {
                    if (ext != null) {
                        this.inviteExt = EaseCallKitUtils.convertMapToJSONObject(ext);
                    }
                    this.callState = EaseCallState.CALL_OUTGOING;
                    this.multipleVideoActivity = new EaseMultipleVideoActivity();
                    intent = new Intent(this.appContext, ((Object)((Object)this.multipleVideoActivity)).getClass()).addFlags(0x10000000);
                    Bundle bundle = new Bundle();
                    isComingCall = false;
                    bundle.putBoolean("isComingCall", false);
                    this.channelName = EaseCallKitUtils.getRandomString(10);
                    bundle.putString("channelName", this.channelName);
                    intent.putExtras(bundle);
                    this.appContext.startActivity(intent);
                }
            } else {
                intent = new Intent(this.appContext, ((Object)((Object)this.multipleVideoActivity)).getClass()).addFlags(0x10000000);
                this.appContext.startActivity(intent);
            }
        }
    }

    private void addMessageListener() {
        this.messageListener = new EMMessageListener(){

            public void onMessageReceived(List<EMMessage> messages) {
                for (EMMessage message : messages) {
                    String messageType = message.getStringAttribute(EaseMsgUtils.CALL_MSG_TYPE, "");
                    EMLog.d((String)TAG, (String)("Receive msg:" + message.getMsgId() + " from:" + message.getFrom() + "  messageType:" + messageType));
                    if (!messageType.equals(EaseMsgUtils.CALL_MSG_INFO) || message.getFrom().equals(EMClient.getInstance().getCurrentUser())) continue;
                    String action = message.getStringAttribute(EaseMsgUtils.CALL_ACTION, "");
                    String callerDevId = message.getStringAttribute(EaseMsgUtils.CALL_DEVICE_ID, "");
                    String fromCallId = message.getStringAttribute(EaseMsgUtils.CLL_ID, "");
                    String fromUser = message.getFrom();
                    String channel = message.getStringAttribute(EaseMsgUtils.CALL_CHANNELNAME, "");
                    JSONObject ext = null;
                    try {
                        ext = message.getJSONObjectAttribute(EaseMsgUtils.CALL_INVITE_EXT);
                    }
                    catch (HyphenateException exception) {
                        exception.printStackTrace();
                    }
                    if (action == null || callerDevId == null || fromCallId == null || fromUser == null || channel == null) {
                        if (EaseCallKit.this.callListener == null) continue;
                        EaseCallKit.this.callListener.onCallError(EaseCallError.PROCESS_ERROR, CALL_PROCESS_ERROR.CALL_RECEIVE_ERROR.code, "receive message error");
                        continue;
                    }
                    EaseCallAction callAction = EaseCallAction.getfrom(action);
                    switch (callAction) {
                        case CALL_INVITE: {
                            BaseEvent callEvent;
                            int calltype = message.getIntAttribute(EaseMsgUtils.CALL_TYPE, 0);
                            EaseCallType callkitType = EaseCallType.getfrom(calltype);
                            if (EaseCallKit.this.callState != EaseCallState.CALL_IDLE) {
                                if (fromCallId.equals(EaseCallKit.this.callID) && fromUser.equals(EaseCallKit.this.fromUserId) && callkitType == EaseCallType.SINGLE_VOICE_CALL && EaseCallKit.this.callType == EaseCallType.SINGLE_VIDEO_CALL) {
                                    InviteEvent inviteEvent = new InviteEvent();
                                    inviteEvent.callId = fromCallId;
                                    inviteEvent.type = callkitType;
                                    EaseLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)inviteEvent);
                                    break;
                                }
                                callEvent = new AnswerEvent();
                                callEvent.result = EaseMsgUtils.CALL_ANSWER_BUSY;
                                callEvent.callerDevId = callerDevId;
                                callEvent.callId = fromCallId;
                                EaseCallKit.this.sendCmdMsg(callEvent, fromUser);
                                break;
                            }
                            EaseCallKit.this.callInfo.setCallerDevId(callerDevId);
                            EaseCallKit.this.callInfo.setCallId(fromCallId);
                            EaseCallKit.this.callInfo.setCallKitType(callkitType);
                            EaseCallKit.this.callInfo.setChannelName(channel);
                            EaseCallKit.this.callInfo.setComming(true);
                            EaseCallKit.this.callInfo.setFromUser(fromUser);
                            EaseCallKit.this.callInfo.setExt(ext);
                            EaseCallKit.this.callInfoMap.put(fromCallId, EaseCallKit.this.callInfo);
                            callEvent = new AlertEvent();
                            ((AlertEvent)callEvent).callerDevId = callerDevId;
                            ((AlertEvent)callEvent).callId = fromCallId;
                            EaseCallKit.this.sendCmdMsg(callEvent, fromUser);
                            EaseCallKit.this.timeHandler.startTime();
                            break;
                        }
                    }
                }
            }

            public void onCmdMessageReceived(List<EMMessage> messages) {
                for (EMMessage message : messages) {
                    String messageType = message.getStringAttribute(EaseMsgUtils.CALL_MSG_TYPE, "");
                    EMLog.d((String)TAG, (String)("Receive cmdmsg:" + message.getMsgId() + " from:" + message.getFrom() + "  messageType:" + messageType));
                    if (!messageType.equals(EaseMsgUtils.CALL_MSG_INFO) || message.getFrom().equals(EMClient.getInstance().getCurrentUser())) continue;
                    String action = message.getStringAttribute(EaseMsgUtils.CALL_ACTION, "");
                    String callerDevId = message.getStringAttribute(EaseMsgUtils.CALL_DEVICE_ID, "");
                    String fromCallId = message.getStringAttribute(EaseMsgUtils.CLL_ID, "");
                    String fromUser = message.getFrom();
                    String channel = message.getStringAttribute(EaseMsgUtils.CALL_CHANNELNAME, "");
                    EaseCallAction callAction = EaseCallAction.getfrom(action);
                    switch (callAction) {
                        case CALL_CANCEL: {
                            if (EaseCallKit.this.callState == EaseCallState.CALL_IDLE) {
                                EaseCallKit.this.timeHandler.stopTime();
                                EaseCallKit.this.callInfoMap.remove(fromCallId);
                                break;
                            }
                            CallCancelEvent event = new CallCancelEvent();
                            event.callerDevId = callerDevId;
                            event.callId = fromCallId;
                            event.userId = fromUser;
                            if (EaseCallKit.this.callID.equals(fromCallId)) {
                                EaseCallKit.this.callState = EaseCallState.CALL_IDLE;
                            }
                            EaseCallKit.this.notifier.reset();
                            EaseLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)event);
                            break;
                        }
                        case CALL_ALERT: {
                            String calleedDeviceId = message.getStringAttribute(EaseMsgUtils.CALLED_DEVICE_ID, "");
                            AlertEvent alertEvent = new AlertEvent();
                            alertEvent.callId = fromCallId;
                            alertEvent.calleeDevId = calleedDeviceId;
                            alertEvent.userId = fromUser;
                            EaseLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)alertEvent);
                            break;
                        }
                        case CALL_CONFIRM_RING: {
                            String calledDvId = message.getStringAttribute(EaseMsgUtils.CALLED_DEVICE_ID, "");
                            boolean vaild = message.getBooleanAttribute(EaseMsgUtils.CALL_STATUS, false);
                            if (!calledDvId.equals(deviceId)) break;
                            EaseCallKit.this.timeHandler.stopTime();
                            if (!vaild) {
                                EaseCallKit.this.callInfoMap.remove(fromCallId);
                                break;
                            }
                            if (EaseCallKit.this.callState == EaseCallState.CALL_IDLE) {
                                EaseCallKit.this.callState = EaseCallState.CALL_ALERTING;
                                EaseCallKit.this.clallee_devId = callerDevId;
                                EaseCallKit.this.callID = fromCallId;
                                EaseCallInfo info = (EaseCallInfo)EaseCallKit.this.callInfoMap.get(fromCallId);
                                if (info != null) {
                                    EaseCallKit.this.channelName = info.getChannelName();
                                    EaseCallKit.this.callType = info.getCallKitType();
                                    EaseCallKit.this.fromUserId = info.getFromUser();
                                    EaseCallKit.this.inviteExt = info.getExt();
                                }
                                EaseCallKit.this.callInfoMap.clear();
                                EaseCallKit.this.timeHandler.startSendEvent();
                                break;
                            }
                            EaseCallKit.this.callInfoMap.remove(fromCallId);
                            EaseCallKit.this.timeHandler.stopTime();
                            break;
                        }
                        case CALL_CONFIRM_CALLEE: {
                            String result = message.getStringAttribute(EaseMsgUtils.CALL_RESULT, "");
                            String calledDevId = message.getStringAttribute(EaseMsgUtils.CALLED_DEVICE_ID, "");
                            ConfirmCallEvent event = new ConfirmCallEvent();
                            event.calleeDevId = calledDevId;
                            event.result = result;
                            event.callerDevId = callerDevId;
                            event.callId = fromCallId;
                            event.userId = fromUser;
                            EaseLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)event);
                            break;
                        }
                        case CALL_ANSWER: {
                            AnswerEvent answerEvent;
                            String result1 = message.getStringAttribute(EaseMsgUtils.CALL_RESULT, "");
                            String calledDevId1 = message.getStringAttribute(EaseMsgUtils.CALLED_DEVICE_ID, "");
                            boolean transVoice = message.getBooleanAttribute(EaseMsgUtils.CALLED_TRANSE_VOICE, false);
                            if (EaseCallKit.this.callType != EaseCallType.CONFERENCE_CALL) {
                                if ((!isComingCall || !calledDevId1.equals(deviceId)) && isComingCall) break;
                                answerEvent = new AnswerEvent();
                                answerEvent.result = result1;
                                answerEvent.calleeDevId = calledDevId1;
                                answerEvent.callerDevId = callerDevId;
                                answerEvent.callId = fromCallId;
                                answerEvent.userId = fromUser;
                                answerEvent.transVoice = transVoice;
                                EaseLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)answerEvent);
                                break;
                            }
                            if (fromUser.equals(EMClient.getInstance().getCurrentUser())) break;
                            answerEvent = new AnswerEvent();
                            answerEvent.result = result1;
                            answerEvent.calleeDevId = calledDevId1;
                            answerEvent.callerDevId = callerDevId;
                            answerEvent.callId = fromCallId;
                            answerEvent.userId = fromUser;
                            answerEvent.transVoice = transVoice;
                            EaseLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)answerEvent);
                            break;
                        }
                        case CALL_VIDEO_TO_VOICE: {
                            if (EaseCallKit.this.callState == EaseCallState.CALL_IDLE || !fromCallId.equals(EaseCallKit.this.callID) || !fromUser.equals(EaseCallKit.this.fromUserId)) break;
                            InviteEvent inviteEvent = new InviteEvent();
                            inviteEvent.callId = fromCallId;
                            inviteEvent.type = EaseCallType.SINGLE_VOICE_CALL;
                            EaseLiveDataBus.get().with(EaseCallType.SINGLE_VIDEO_CALL.toString()).postValue((Object)inviteEvent);
                            break;
                        }
                    }
                }
            }

            public void onMessageRead(List<EMMessage> messages) {
            }

            public void onMessageDelivered(List<EMMessage> messages) {
            }

            public void onMessageRecalled(List<EMMessage> messages) {
            }

            public void onMessageChanged(EMMessage message, Object change) {
            }
        };
        EMClient.getInstance().chatManager().addMessageListener(this.messageListener);
    }

    public void setCallKitListener(EaseCallKitListener listener) {
        this.callListener = listener;
    }

    public void removeCallKitListener(EaseCallKitListener listener) {
        this.callListener = null;
    }

    private void removeMessageListener() {
        EMClient.getInstance().chatManager().removeMessageListener(this.messageListener);
        this.messageListener = null;
    }

    public EaseCallState getCallState() {
        return this.callState;
    }

    public EaseCallType getCallType() {
        return this.callType;
    }

    public void setCallType(EaseCallType callType) {
        this.callType = callType;
    }

    public void setCallState(EaseCallState callState) {
        this.callState = callState;
    }

    public String getCallID() {
        return this.callID;
    }

    public void setCallID(String callID) {
        this.callID = callID;
    }

    public String getClallee_devId() {
        return this.clallee_devId;
    }

    public EaseCallKitListener getCallListener() {
        return this.callListener;
    }

    private boolean isMainProcess(Context context) {
        int pid = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : activityManager.getRunningAppProcesses()) {
            if (appProcess.pid != pid) continue;
            return context.getApplicationInfo().packageName.equals(appProcess.processName);
        }
        return false;
    }

    private void sendCmdMsg(BaseEvent event, String username) {
        final EMMessage message = EMMessage.createSendMessage((EMMessage.Type)EMMessage.Type.CMD);
        message.setTo(username);
        String action = "rtcCall";
        EMCmdMessageBody cmdBody = new EMCmdMessageBody(action);
        message.addBody((EMMessageBody)cmdBody);
        message.setAttribute(EaseMsgUtils.CALL_ACTION, event.callAction.state);
        message.setAttribute(EaseMsgUtils.CALL_DEVICE_ID, event.callerDevId);
        message.setAttribute(EaseMsgUtils.CLL_ID, event.callId);
        message.setAttribute(EaseMsgUtils.CLL_TIMESTRAMEP, System.currentTimeMillis());
        message.setAttribute(EaseMsgUtils.CALL_MSG_TYPE, EaseMsgUtils.CALL_MSG_INFO);
        if (event.callAction == EaseCallAction.CALL_ANSWER) {
            message.setAttribute(EaseMsgUtils.CALLED_DEVICE_ID, deviceId);
            message.setAttribute(EaseMsgUtils.CALL_RESULT, ((AnswerEvent)event).result);
        } else if (event.callAction == EaseCallAction.CALL_ALERT) {
            message.setAttribute(EaseMsgUtils.CALLED_DEVICE_ID, deviceId);
        }
        final EMConversation conversation = EMClient.getInstance().chatManager().getConversation(username, EMConversation.EMConversationType.Chat, true);
        message.setMessageStatusCallback(new EMCallBack(){

            public void onSuccess() {
                EMLog.d((String)TAG, (String)"Invite call success");
                conversation.removeMessage(message.getMsgId());
            }

            public void onError(int code, String error) {
                EMLog.e((String)TAG, (String)("Invite call error " + code + ", " + error));
                conversation.removeMessage(message.getMsgId());
                if (EaseCallKit.this.callListener != null) {
                    EaseCallKit.this.callListener.onCallError(EaseCallError.IM_ERROR, code, error);
                }
            }

            public void onProgress(int progress, String status) {
            }
        });
        EMClient.getInstance().chatManager().sendMessage(message);
    }

    private boolean isDestroy(Activity mActivity) {
        return mActivity == null || mActivity.isFinishing() || Build.VERSION.SDK_INT >= 17 && mActivity.isDestroyed();
    }

    public ArrayList<String> getInviteeUsers() {
        return this.inviteeUsers;
    }

    public void InitInviteeUsers() {
        this.inviteeUsers.clear();
    }

    public void setMultipleVideoActivity(EaseMultipleVideoActivity activity) {
        this.multipleVideoActivity = null;
    }

    public JSONObject getInviteExt() {
        return this.inviteExt;
    }

    public Context getAppContext() {
        return this.appContext;
    }

    private class TimeHandler
    extends Handler {
        private final int MSG_TIMER = 0;
        private final int MSG_START_ACTIVITY = 1;
        private DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        private int timePassed = 0;

        public TimeHandler() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public void startTime() {
            this.timePassed = 0;
            this.sendEmptyMessageDelayed(0, 1000L);
        }

        public void startSendEvent() {
            this.sendEmptyMessage(1);
        }

        public void stopTime() {
            this.removeMessages(1);
            this.removeMessages(0);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                ++this.timePassed;
                String time = this.dateFormat.format(this.timePassed * 1000);
                if (this.timePassed * 1000 == 5000) {
                    EaseCallKit.this.timeHandler.stopTime();
                    EaseCallKit.this.callState = EaseCallState.CALL_IDLE;
                }
                this.sendEmptyMessageDelayed(0, 1000L);
            } else if (msg.what == 1) {
                EaseCallKit.this.timeHandler.stopTime();
                String info = "";
                String userName = EaseCallKitUtils.getUserNickName(EaseCallKit.this.fromUserId);
                if (EaseCallKit.this.callType != EaseCallType.CONFERENCE_CALL) {
                    EaseVideoCallActivity callActivity = new EaseVideoCallActivity();
                    Intent intent = new Intent(EaseCallKit.this.appContext, ((Object)((Object)callActivity)).getClass()).addFlags(0x10000000);
                    Bundle bundle = new Bundle();
                    isComingCall = true;
                    bundle.putBoolean("isComingCall", true);
                    bundle.putString("channelName", EaseCallKit.this.channelName);
                    bundle.putString("username", EaseCallKit.this.fromUserId);
                    intent.putExtras(bundle);
                    EaseCallKit.this.appContext.startActivity(intent);
                    if (Build.VERSION.SDK_INT >= 29 && !EasyUtils.isAppRunningForeground((Context)EaseCallKit.this.appContext)) {
                        EMLog.e((String)TAG, (String)("notifier.notify:" + info));
                        info = EaseCallKit.this.callType == EaseCallType.SINGLE_VIDEO_CALL ? EaseCallKit.this.appContext.getString(R.string.alert_request_video, new Object[]{userName}) : EaseCallKit.this.appContext.getString(R.string.alert_request_voice, new Object[]{userName});
                        EaseCallKit.this.notifier.notify(intent, "\u73af\u4fe1 ", info);
                    }
                } else {
                    EaseCallKit.this.multipleVideoActivity = new EaseMultipleVideoActivity();
                    Intent intent = new Intent(EaseCallKit.this.appContext, ((Object)((Object)EaseCallKit.this.multipleVideoActivity)).getClass()).addFlags(0x10000000);
                    Bundle bundle = new Bundle();
                    isComingCall = true;
                    bundle.putBoolean("isComingCall", true);
                    bundle.putString("channelName", EaseCallKit.this.channelName);
                    bundle.putString("username", EaseCallKit.this.fromUserId);
                    intent.putExtras(bundle);
                    EaseCallKit.this.appContext.startActivity(intent);
                    if (Build.VERSION.SDK_INT >= 29 && EaseCallKitUtils.isAppRunningForeground(EaseCallKit.this.appContext)) {
                        info = EaseCallKit.this.appContext.getString(R.string.alert_request_multiple_video, new Object[]{userName});
                        EaseCallKit.this.notifier.notify(intent, "Hyphenate", info);
                    }
                }
                if (EaseCallKit.this.callListener != null) {
                    EaseCallKit.this.callListener.onReceivedCall(EaseCallKit.this.callType, EaseCallKit.this.fromUserId, EaseCallKit.this.inviteExt);
                }
            }
            super.handleMessage(msg);
        }
    }

    public static enum CALL_PROCESS_ERROR {
        CALL_STATE_ERROR(0),
        CALL_TYPE_ERROR(1),
        CALL_PARAM_ERROR(2),
        CALL_RECEIVE_ERROR(3);

        public int code;

        private CALL_PROCESS_ERROR(int code) {
            this.code = code;
        }
    }

    public static enum EaseCallError {
        PROCESS_ERROR,
        RTC_ERROR,
        IM_ERROR;

    }
}

